Liferay.Loader.define('@questions-web$apollo/client@3.0.0-beta.50/cache/inmemory/inMemoryCache', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { __extends, __assign } from 'tslib';
        import { addTypenameToDocument } from '../../utilities/graphql/transform.js';
        import { dep, wrap } from 'optimism';
        import { ApolloCache } from '../core/cache.js';
        import { Policies, defaultDataIdFromObject } from './policies.js';
        import { EntityStore, supportsResultCaching } from './entityStore.js';
        import { StoreReader } from './readFromStore.js';
        import { StoreWriter } from './writeToStore.js';

        var defaultConfig = {
            dataIdFromObject: defaultDataIdFromObject,
            addTypename: true,
            resultCaching: true,
            typePolicies: {}
        };
        var InMemoryCache = function (_super) {
            __extends(InMemoryCache, _super);
            function InMemoryCache(config) {
                if (config === void 0) {
                    config = {};
                }
                var _this = _super.call(this) || this;
                _this.watches = new Set();
                _this.typenameDocumentCache = new Map();
                _this.txCount = 0;
                _this.varDep = dep();
                _this.config = __assign(__assign({}, defaultConfig), config);
                _this.addTypename = !!_this.config.addTypename;
                _this.policies = new Policies({
                    dataIdFromObject: _this.config.dataIdFromObject,
                    possibleTypes: _this.config.possibleTypes,
                    typePolicies: _this.config.typePolicies
                });
                _this.data = new EntityStore.Root({
                    policies: _this.policies,
                    resultCaching: _this.config.resultCaching
                });
                _this.optimisticData = _this.data;
                _this.storeWriter = new StoreWriter({
                    policies: _this.policies,
                    reader: _this.storeReader = new StoreReader({
                        addTypename: _this.addTypename,
                        policies: _this.policies
                    })
                });
                var cache = _this;
                var maybeBroadcastWatch = cache.maybeBroadcastWatch;
                _this.maybeBroadcastWatch = wrap(function (c) {
                    return maybeBroadcastWatch.call(_this, c);
                }, {
                    makeCacheKey: function (c) {
                        var store = c.optimistic ? cache.optimisticData : cache.data;
                        if (supportsResultCaching(store)) {
                            var optimistic = c.optimistic,
                                rootId = c.rootId,
                                variables = c.variables;
                            return store.makeCacheKey(c.query, c.callback, JSON.stringify({ optimistic: optimistic, rootId: rootId, variables: variables }));
                        }
                    }
                });
                return _this;
            }
            InMemoryCache.prototype.restore = function (data) {
                if (data) this.data.replace(data);
                return this;
            };
            InMemoryCache.prototype.extract = function (optimistic) {
                if (optimistic === void 0) {
                    optimistic = false;
                }
                return (optimistic ? this.optimisticData : this.data).toObject();
            };
            InMemoryCache.prototype.read = function (options) {
                var store = options.optimistic ? this.optimisticData : this.data;
                if (typeof options.rootId === 'string' && !store.has(options.rootId)) {
                    return null;
                }
                return this.storeReader.readQueryFromStore({
                    store: store,
                    query: options.query,
                    variables: options.variables,
                    rootId: options.rootId,
                    config: this.config
                }) || null;
            };
            InMemoryCache.prototype.write = function (options) {
                this.storeWriter.writeQueryToStore({
                    store: this.data,
                    query: options.query,
                    result: options.result,
                    dataId: options.dataId,
                    variables: options.variables
                });
                if (options.broadcast !== false) {
                    this.broadcastWatches();
                }
            };
            InMemoryCache.prototype.diff = function (options) {
                return this.storeReader.diffQueryAgainstStore({
                    store: options.optimistic ? this.optimisticData : this.data,
                    rootId: options.id || "ROOT_QUERY",
                    query: options.query,
                    variables: options.variables,
                    returnPartialData: options.returnPartialData,
                    config: this.config
                });
            };
            InMemoryCache.prototype.watch = function (watch) {
                var _this = this;
                this.watches.add(watch);
                if (watch.immediate) {
                    this.maybeBroadcastWatch(watch);
                }
                return function () {
                    _this.watches.delete(watch);
                };
            };
            InMemoryCache.prototype.gc = function () {
                return this.optimisticData.gc();
            };
            InMemoryCache.prototype.retain = function (rootId, optimistic) {
                return (optimistic ? this.optimisticData : this.data).retain(rootId);
            };
            InMemoryCache.prototype.release = function (rootId, optimistic) {
                return (optimistic ? this.optimisticData : this.data).release(rootId);
            };
            InMemoryCache.prototype.identify = function (object) {
                return this.policies.identify(object)[0];
            };
            InMemoryCache.prototype.evict = function (idOrOptions, fieldName, args) {
                var evicted = this.optimisticData.evict(typeof idOrOptions === "string" ? {
                    id: idOrOptions,
                    fieldName: fieldName,
                    args: args
                } : idOrOptions);
                if (typeof idOrOptions === "string" || idOrOptions.broadcast !== false) {
                    this.broadcastWatches();
                }
                return evicted;
            };
            InMemoryCache.prototype.reset = function () {
                this.data.clear();
                this.optimisticData = this.data;
                this.broadcastWatches();
                return Promise.resolve();
            };
            InMemoryCache.prototype.removeOptimistic = function (idToRemove) {
                var newOptimisticData = this.optimisticData.removeLayer(idToRemove);
                if (newOptimisticData !== this.optimisticData) {
                    this.optimisticData = newOptimisticData;
                    this.broadcastWatches();
                }
            };
            InMemoryCache.prototype.performTransaction = function (transaction, optimisticId) {
                var _this = this;
                var perform = function (layer) {
                    var _a = _this,
                        data = _a.data,
                        optimisticData = _a.optimisticData;
                    ++_this.txCount;
                    if (layer) {
                        _this.data = _this.optimisticData = layer;
                    }
                    try {
                        transaction(_this);
                    } finally {
                        --_this.txCount;
                        _this.data = data;
                        _this.optimisticData = optimisticData;
                    }
                };
                if (typeof optimisticId === 'string') {
                    this.optimisticData = this.optimisticData.addLayer(optimisticId, perform);
                } else {
                    perform();
                }
                this.broadcastWatches();
            };
            InMemoryCache.prototype.recordOptimisticTransaction = function (transaction, id) {
                return this.performTransaction(transaction, id);
            };
            InMemoryCache.prototype.transformDocument = function (document) {
                if (this.addTypename) {
                    var result = this.typenameDocumentCache.get(document);
                    if (!result) {
                        result = addTypenameToDocument(document);
                        this.typenameDocumentCache.set(document, result);
                        this.typenameDocumentCache.set(result, result);
                    }
                    return result;
                }
                return document;
            };
            InMemoryCache.prototype.broadcastWatches = function () {
                var _this = this;
                if (!this.txCount) {
                    this.watches.forEach(function (c) {
                        return _this.maybeBroadcastWatch(c);
                    });
                }
            };
            InMemoryCache.prototype.maybeBroadcastWatch = function (c) {
                c.callback(this.diff({
                    query: c.query,
                    variables: c.variables,
                    optimistic: c.optimistic
                }));
            };
            InMemoryCache.prototype.makeVar = function (value) {
                var cache = this;
                return function rv(newValue) {
                    if (arguments.length > 0) {
                        if (value !== newValue) {
                            value = newValue;
                            cache.varDep.dirty(rv);
                            cache.broadcastWatches();
                        }
                    } else {
                        cache.varDep(rv);
                    }
                    return value;
                };
            };
            return InMemoryCache;
        }(ApolloCache);

        export { InMemoryCache };
        //# sourceMappingURL=inMemoryCache.js.map
    }
});
//# sourceMappingURL=inMemoryCache.js.map