Liferay.Loader.define('@questions-web$apollo/client@3.0.0-beta.50/link/http/parseAndCheckHttpResponse', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { throwServerError } from '../utils/throwServerError.js';

        var hasOwnProperty = Object.prototype.hasOwnProperty;
        function parseAndCheckHttpResponse(operations) {
            return function (response) {
                return response.text().then(function (bodyText) {
                    try {
                        return JSON.parse(bodyText);
                    } catch (err) {
                        var parseError = err;
                        parseError.name = 'ServerParseError';
                        parseError.response = response;
                        parseError.statusCode = response.status;
                        parseError.bodyText = bodyText;
                        throw parseError;
                    }
                }).then(function (result) {
                    if (response.status >= 300) {
                        throwServerError(response, result, "Response not successful: Received status code " + response.status);
                    }
                    if (!Array.isArray(result) && !hasOwnProperty.call(result, 'data') && !hasOwnProperty.call(result, 'errors')) {
                        throwServerError(response, result, "Server response was missing for query '" + (Array.isArray(operations) ? operations.map(function (op) {
                            return op.operationName;
                        }) : operations.operationName) + "'.");
                    }
                    return result;
                });
            };
        }

        export { parseAndCheckHttpResponse };
        //# sourceMappingURL=parseAndCheckHttpResponse.js.map
    }
});
//# sourceMappingURL=parseAndCheckHttpResponse.js.map