Liferay.Loader.define('@questions-web$apollo/client@3.0.0-beta.50/link/http/rewriteURIForGET', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { serializeFetchParameter } from './serializeFetchParameter.js';

        function rewriteURIForGET(chosenURI, body) {
            var queryParams = [];
            var addQueryParam = function (key, value) {
                queryParams.push(key + "=" + encodeURIComponent(value));
            };
            if ('query' in body) {
                addQueryParam('query', body.query);
            }
            if (body.operationName) {
                addQueryParam('operationName', body.operationName);
            }
            if (body.variables) {
                var serializedVariables = void 0;
                try {
                    serializedVariables = serializeFetchParameter(body.variables, 'Variables map');
                } catch (parseError) {
                    return { parseError: parseError };
                }
                addQueryParam('variables', serializedVariables);
            }
            if (body.extensions) {
                var serializedExtensions = void 0;
                try {
                    serializedExtensions = serializeFetchParameter(body.extensions, 'Extensions map');
                } catch (parseError) {
                    return { parseError: parseError };
                }
                addQueryParam('extensions', serializedExtensions);
            }
            var fragment = '',
                preFragment = chosenURI;
            var fragmentStart = chosenURI.indexOf('#');
            if (fragmentStart !== -1) {
                fragment = chosenURI.substr(fragmentStart);
                preFragment = chosenURI.substr(0, fragmentStart);
            }
            var queryParamsPrefix = preFragment.indexOf('?') === -1 ? '?' : '&';
            var newURI = preFragment + queryParamsPrefix + queryParams.join('&') + fragment;
            return { newURI: newURI };
        }

        export { rewriteURIForGET };
        //# sourceMappingURL=rewriteURIForGET.js.map
    }
});
//# sourceMappingURL=rewriteURIForGET.js.map