Liferay.Loader.define('@questions-web$apollo/client@3.0.0-beta.50/react/data/OperationData', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { invariant } from 'ts-invariant';
        import { equal } from '@wry/equality';
        import { parser, operationName } from '../parser/parser.js';

        var OperationData = function () {
            function OperationData(options, context) {
                this.isMounted = false;
                this.previousOptions = {};
                this.context = {};
                this.options = {};
                this.options = options || {};
                this.context = context || {};
            }
            OperationData.prototype.getOptions = function () {
                return this.options;
            };
            OperationData.prototype.setOptions = function (newOptions, storePrevious) {
                if (storePrevious === void 0) {
                    storePrevious = false;
                }
                if (storePrevious && !equal(this.options, newOptions)) {
                    this.previousOptions = this.options;
                }
                this.options = newOptions;
            };
            OperationData.prototype.unmount = function () {
                this.isMounted = false;
            };
            OperationData.prototype.refreshClient = function () {
                var client = this.options && this.options.client || this.context && this.context.client;
                invariant(!!client, 44);
                var isNew = false;
                if (client !== this.client) {
                    isNew = true;
                    this.client = client;
                    this.cleanup();
                }
                return {
                    client: this.client,
                    isNew: isNew
                };
            };
            OperationData.prototype.verifyDocumentType = function (document, type) {
                var operation = parser(document);
                var requiredOperationName = operationName(type);
                var usedOperationName = operationName(operation.type);
                invariant(operation.type === type, 45);
            };
            return OperationData;
        }();

        export { OperationData };
        //# sourceMappingURL=OperationData.js.map
    }
});
//# sourceMappingURL=OperationData.js.map