Liferay.Loader.define('@questions-web$apollo/client@3.0.0-beta.50/react/hooks/useSubscription', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { __assign } from 'tslib';
        import { requireReactLazily } from '../react.js';
        import { getApolloContext } from '../context/ApolloContext.js';
        import { SubscriptionData } from '../data/SubscriptionData.js';

        function useSubscription(subscription, options) {
            var React = requireReactLazily();
            var useContext = React.useContext,
                useState = React.useState,
                useRef = React.useRef,
                useEffect = React.useEffect;
            var context = useContext(getApolloContext());
            var updatedOptions = options ? __assign(__assign({}, options), { subscription: subscription }) : { subscription: subscription };
            var _a = useState({
                loading: !updatedOptions.skip,
                error: undefined,
                data: undefined
            }),
                result = _a[0],
                setResult = _a[1];
            var subscriptionDataRef = useRef();

            var subscriptionData = function getSubscriptionDataRef() {
                if (!subscriptionDataRef.current) {
                    subscriptionDataRef.current = new SubscriptionData({
                        options: updatedOptions,
                        context: context,
                        setResult: setResult
                    });
                }
                return subscriptionDataRef.current;
            }();
            subscriptionData.setOptions(updatedOptions, true);
            subscriptionData.context = context;
            useEffect(function () {
                return subscriptionData.afterExecute();
            });
            useEffect(function () {
                return subscriptionData.cleanup.bind(subscriptionData);
            }, []);
            return subscriptionData.execute(result);
        }

        export { useSubscription };
        //# sourceMappingURL=useSubscription.js.map
    }
});
//# sourceMappingURL=useSubscription.js.map