Liferay.Loader.define("@questions-web$apollo/client@3.0.0-beta.50/react/parser/parser", ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { invariant } from 'ts-invariant';

        var DocumentType;
        (function (DocumentType) {
            DocumentType[DocumentType["Query"] = 0] = "Query";
            DocumentType[DocumentType["Mutation"] = 1] = "Mutation";
            DocumentType[DocumentType["Subscription"] = 2] = "Subscription";
        })(DocumentType || (DocumentType = {}));
        var cache = new Map();
        function operationName(type) {
            var name;
            switch (type) {
                case DocumentType.Query:
                    name = 'Query';
                    break;
                case DocumentType.Mutation:
                    name = 'Mutation';
                    break;
                case DocumentType.Subscription:
                    name = 'Subscription';
                    break;
            }
            return name;
        }
        function parser(document) {
            var cached = cache.get(document);
            if (cached) return cached;
            var variables, type, name;
            invariant(!!document && !!document.kind, 7);
            var fragments = document.definitions.filter(function (x) {
                return x.kind === 'FragmentDefinition';
            });
            var queries = document.definitions.filter(function (x) {
                return x.kind === 'OperationDefinition' && x.operation === 'query';
            });
            var mutations = document.definitions.filter(function (x) {
                return x.kind === 'OperationDefinition' && x.operation === 'mutation';
            });
            var subscriptions = document.definitions.filter(function (x) {
                return x.kind === 'OperationDefinition' && x.operation === 'subscription';
            });
            invariant(!fragments.length || queries.length || mutations.length || subscriptions.length, 8);
            invariant(queries.length + mutations.length + subscriptions.length <= 1, 9);
            type = queries.length ? DocumentType.Query : DocumentType.Mutation;
            if (!queries.length && !mutations.length) type = DocumentType.Subscription;
            var definitions = queries.length ? queries : mutations.length ? mutations : subscriptions;
            invariant(definitions.length === 1, 10);
            var definition = definitions[0];
            variables = definition.variableDefinitions || [];
            if (definition.name && definition.name.kind === 'Name') {
                name = definition.name.value;
            } else {
                name = 'data';
            }
            var payload = { name: name, type: type, variables: variables };
            cache.set(document, payload);
            return payload;
        }

        export { DocumentType, operationName, parser };
        //# sourceMappingURL=parser.js.map
    }
});
//# sourceMappingURL=parser.js.map