'use strict';

Liferay.Loader.define('@questions-web$apollo/client@3.0.0-beta.50/testing', ['module', 'exports', 'require', 'questions-web$tslib', 'frontend-js-react-web$react', 'questions-web$ts-invariant', 'questions-web$zen-observable', 'questions-web$symbol-observable', 'questions-web$fast-json-stable-stringify', 'questions-web$graphql/language/visitor', '@questions-web$wry/equality', 'questions-web$graphql/language/printer', 'questions-web$optimism'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        Object.defineProperty(exports, '__esModule', { value: true });

        function _interopDefault(ex) {
            return ex && typeof ex === 'object' && 'default' in ex ? ex['default'] : ex;
        }

        var tslib = require('questions-web$tslib');
        var React$1 = _interopDefault(require('frontend-js-react-web$react'));
        var invariant = require('questions-web$ts-invariant');
        var invariant__default = _interopDefault(invariant);
        var Observable = _interopDefault(require('questions-web$zen-observable'));
        require('questions-web$symbol-observable');
        var stringify = _interopDefault(require('questions-web$fast-json-stable-stringify'));
        var visitor = require('questions-web$graphql/language/visitor');
        var equality = require('@questions-web$wry/equality');
        var printer = require('questions-web$graphql/language/printer');
        var optimism = require('questions-web$optimism');

        function validateOperation(operation) {
            var OPERATION_FIELDS = ['query', 'operationName', 'variables', 'extensions', 'context'];
            for (var _i = 0, _a = Object.keys(operation); _i < _a.length; _i++) {
                var key = _a[_i];
                if (OPERATION_FIELDS.indexOf(key) < 0) {
                    throw new invariant.InvariantError(32);
                }
            }
            return operation;
        }

        function createOperation(starting, operation) {
            var context = tslib.__assign({}, starting);
            var setContext = function (next) {
                if (typeof next === 'function') {
                    context = tslib.__assign(tslib.__assign({}, context), next(context));
                } else {
                    context = tslib.__assign(tslib.__assign({}, context), next);
                }
            };
            var getContext = function () {
                return tslib.__assign({}, context);
            };
            Object.defineProperty(operation, 'setContext', {
                enumerable: false,
                value: setContext
            });
            Object.defineProperty(operation, 'getContext', {
                enumerable: false,
                value: getContext
            });
            return operation;
        }

        function getFragmentQueryDocument(document, fragmentName) {
            var actualFragmentName = fragmentName;
            var fragments = [];
            document.definitions.forEach(function (definition) {
                if (definition.kind === 'OperationDefinition') {
                    throw new invariant.InvariantError(41);
                }
                if (definition.kind === 'FragmentDefinition') {
                    fragments.push(definition);
                }
            });
            if (typeof actualFragmentName === 'undefined') {
                invariant.invariant(fragments.length === 1, 42);
                actualFragmentName = fragments[0].name.value;
            }
            var query = tslib.__assign(tslib.__assign({}, document), { definitions: tslib.__spreadArrays([{
                    kind: 'OperationDefinition',
                    operation: 'query',
                    selectionSet: {
                        kind: 'SelectionSet',
                        selections: [{
                            kind: 'FragmentSpread',
                            name: {
                                kind: 'Name',
                                value: actualFragmentName
                            }
                        }]
                    }
                }], document.definitions) });
            return query;
        }
        function createFragmentMap(fragments) {
            if (fragments === void 0) {
                fragments = [];
            }
            var symTable = {};
            fragments.forEach(function (fragment) {
                symTable[fragment.name.value] = fragment;
            });
            return symTable;
        }
        function getFragmentFromSelection(selection, fragmentMap) {
            switch (selection.kind) {
                case 'InlineFragment':
                    return selection;
                case 'FragmentSpread':
                    {
                        var fragment = fragmentMap && fragmentMap[selection.name.value];
                        invariant.invariant(fragment, 43);
                        return fragment;
                    }
                default:
                    return null;
            }
        }

        function makeReference(id) {
            return { __ref: String(id) };
        }
        function isReference(obj) {
            return obj && typeof obj === 'object' && typeof obj.__ref === 'string';
        }
        function isStringValue(value) {
            return value.kind === 'StringValue';
        }
        function isBooleanValue(value) {
            return value.kind === 'BooleanValue';
        }
        function isIntValue(value) {
            return value.kind === 'IntValue';
        }
        function isFloatValue(value) {
            return value.kind === 'FloatValue';
        }
        function isVariable(value) {
            return value.kind === 'Variable';
        }
        function isObjectValue(value) {
            return value.kind === 'ObjectValue';
        }
        function isListValue(value) {
            return value.kind === 'ListValue';
        }
        function isEnumValue(value) {
            return value.kind === 'EnumValue';
        }
        function isNullValue(value) {
            return value.kind === 'NullValue';
        }
        function valueToObjectRepresentation(argObj, name, value, variables) {
            if (isIntValue(value) || isFloatValue(value)) {
                argObj[name.value] = Number(value.value);
            } else if (isBooleanValue(value) || isStringValue(value)) {
                argObj[name.value] = value.value;
            } else if (isObjectValue(value)) {
                var nestedArgObj_1 = {};
                value.fields.map(function (obj) {
                    return valueToObjectRepresentation(nestedArgObj_1, obj.name, obj.value, variables);
                });
                argObj[name.value] = nestedArgObj_1;
            } else if (isVariable(value)) {
                var variableValue = (variables || {})[value.name.value];
                argObj[name.value] = variableValue;
            } else if (isListValue(value)) {
                argObj[name.value] = value.values.map(function (listValue) {
                    var nestedArgArrayObj = {};
                    valueToObjectRepresentation(nestedArgArrayObj, name, listValue, variables);
                    return nestedArgArrayObj[name.value];
                });
            } else if (isEnumValue(value)) {
                argObj[name.value] = value.value;
            } else if (isNullValue(value)) {
                argObj[name.value] = null;
            } else {
                throw new invariant.InvariantError(33);
            }
        }
        function storeKeyNameFromField(field, variables) {
            var directivesObj = null;
            if (field.directives) {
                directivesObj = {};
                field.directives.forEach(function (directive) {
                    directivesObj[directive.name.value] = {};
                    if (directive.arguments) {
                        directive.arguments.forEach(function (_a) {
                            var name = _a.name,
                                value = _a.value;
                            return valueToObjectRepresentation(directivesObj[directive.name.value], name, value, variables);
                        });
                    }
                });
            }
            var argObj = null;
            if (field.arguments && field.arguments.length) {
                argObj = {};
                field.arguments.forEach(function (_a) {
                    var name = _a.name,
                        value = _a.value;
                    return valueToObjectRepresentation(argObj, name, value, variables);
                });
            }
            return getStoreKeyName(field.name.value, argObj, directivesObj);
        }
        var KNOWN_DIRECTIVES = ['connection', 'include', 'skip', 'client', 'rest', 'export'];
        function getStoreKeyName(fieldName, args, directives) {
            if (args && directives && directives['connection'] && directives['connection']['key']) {
                if (directives['connection']['filter'] && directives['connection']['filter'].length > 0) {
                    var filterKeys = directives['connection']['filter'] ? directives['connection']['filter'] : [];
                    filterKeys.sort();
                    var filteredArgs_1 = {};
                    filterKeys.forEach(function (key) {
                        filteredArgs_1[key] = args[key];
                    });
                    return directives['connection']['key'] + "(" + JSON.stringify(filteredArgs_1) + ")";
                } else {
                    return directives['connection']['key'];
                }
            }
            var completeFieldName = fieldName;
            if (args) {
                var stringifiedArgs = stringify(args);
                completeFieldName += "(" + stringifiedArgs + ")";
            }
            if (directives) {
                Object.keys(directives).forEach(function (key) {
                    if (KNOWN_DIRECTIVES.indexOf(key) !== -1) return;
                    if (directives[key] && Object.keys(directives[key]).length) {
                        completeFieldName += "@" + key + "(" + JSON.stringify(directives[key]) + ")";
                    } else {
                        completeFieldName += "@" + key;
                    }
                });
            }
            return completeFieldName;
        }
        function argumentsObjectFromField(field, variables) {
            if (field.arguments && field.arguments.length) {
                var argObj_1 = {};
                field.arguments.forEach(function (_a) {
                    var name = _a.name,
                        value = _a.value;
                    return valueToObjectRepresentation(argObj_1, name, value, variables);
                });
                return argObj_1;
            }
            return null;
        }
        function resultKeyNameFromField(field) {
            return field.alias ? field.alias.value : field.name.value;
        }
        function getTypenameFromResult(result, selectionSet, fragmentMap) {
            if (typeof result.__typename === 'string') {
                return result.__typename;
            }
            for (var _i = 0, _a = selectionSet.selections; _i < _a.length; _i++) {
                var selection = _a[_i];
                if (isField(selection)) {
                    if (selection.name.value === '__typename') {
                        return result[resultKeyNameFromField(selection)];
                    }
                } else {
                    var typename = getTypenameFromResult(result, getFragmentFromSelection(selection, fragmentMap).selectionSet, fragmentMap);
                    if (typeof typename === 'string') {
                        return typename;
                    }
                }
            }
        }
        function isField(selection) {
            return selection.kind === 'Field';
        }
        function isInlineFragment(selection) {
            return selection.kind === 'InlineFragment';
        }

        function checkDocument(doc) {
            invariant.invariant(doc && doc.kind === 'Document', 24);
            var operations = doc.definitions.filter(function (d) {
                return d.kind !== 'FragmentDefinition';
            }).map(function (definition) {
                if (definition.kind !== 'OperationDefinition') {
                    throw new invariant.InvariantError(25);
                }
                return definition;
            });
            invariant.invariant(operations.length <= 1, 26);
            return doc;
        }
        function getOperationDefinition(doc) {
            checkDocument(doc);
            return doc.definitions.filter(function (definition) {
                return definition.kind === 'OperationDefinition';
            })[0];
        }
        function getOperationName(doc) {
            return doc.definitions.filter(function (definition) {
                return definition.kind === 'OperationDefinition' && definition.name;
            }).map(function (x) {
                return x.name.value;
            })[0] || null;
        }
        function getFragmentDefinitions(doc) {
            return doc.definitions.filter(function (definition) {
                return definition.kind === 'FragmentDefinition';
            });
        }
        function getQueryDefinition(doc) {
            var queryDef = getOperationDefinition(doc);
            invariant.invariant(queryDef && queryDef.operation === 'query', 27);
            return queryDef;
        }
        function getFragmentDefinition(doc) {
            invariant.invariant(doc.kind === 'Document', 28);
            invariant.invariant(doc.definitions.length <= 1, 29);
            var fragmentDef = doc.definitions[0];
            invariant.invariant(fragmentDef.kind === 'FragmentDefinition', 30);
            return fragmentDef;
        }
        function getMainDefinition(queryDoc) {
            checkDocument(queryDoc);
            var fragmentDefinition;
            for (var _i = 0, _a = queryDoc.definitions; _i < _a.length; _i++) {
                var definition = _a[_i];
                if (definition.kind === 'OperationDefinition') {
                    var operation = definition.operation;
                    if (operation === 'query' || operation === 'mutation' || operation === 'subscription') {
                        return definition;
                    }
                }
                if (definition.kind === 'FragmentDefinition' && !fragmentDefinition) {
                    fragmentDefinition = definition;
                }
            }
            if (fragmentDefinition) {
                return fragmentDefinition;
            }
            throw new invariant.InvariantError(31);
        }
        function getDefaultValues(definition) {
            var defaultValues = Object.create(null);
            var defs = definition && definition.variableDefinitions;
            if (defs && defs.length) {
                defs.forEach(function (def) {
                    if (def.defaultValue) {
                        valueToObjectRepresentation(defaultValues, def.variable.name, def.defaultValue);
                    }
                });
            }
            return defaultValues;
        }

        function transformOperation(operation) {
            var transformedOperation = {
                variables: operation.variables || {},
                extensions: operation.extensions || {},
                operationName: operation.operationName,
                query: operation.query
            };
            if (!transformedOperation.operationName) {
                transformedOperation.operationName = typeof transformedOperation.query !== 'string' ? getOperationName(transformedOperation.query) || undefined : '';
            }
            return transformedOperation;
        }

        function passthrough(op, forward) {
            return forward ? forward(op) : Observable.of();
        }
        function toLink(handler) {
            return typeof handler === 'function' ? new ApolloLink(handler) : handler;
        }
        function isTerminating(link) {
            return link.request.length <= 1;
        }
        var LinkError = function (_super) {
            tslib.__extends(LinkError, _super);
            function LinkError(message, link) {
                var _this = _super.call(this, message) || this;
                _this.link = link;
                return _this;
            }
            return LinkError;
        }(Error);
        var ApolloLink = function () {
            function ApolloLink(request) {
                if (request) this.request = request;
            }
            ApolloLink.empty = function () {
                return new ApolloLink(function () {
                    return Observable.of();
                });
            };
            ApolloLink.from = function (links) {
                if (links.length === 0) return ApolloLink.empty();
                return links.map(toLink).reduce(function (x, y) {
                    return x.concat(y);
                });
            };
            ApolloLink.split = function (test, left, right) {
                var leftLink = toLink(left);
                var rightLink = toLink(right || new ApolloLink(passthrough));
                if (isTerminating(leftLink) && isTerminating(rightLink)) {
                    return new ApolloLink(function (operation) {
                        return test(operation) ? leftLink.request(operation) || Observable.of() : rightLink.request(operation) || Observable.of();
                    });
                } else {
                    return new ApolloLink(function (operation, forward) {
                        return test(operation) ? leftLink.request(operation, forward) || Observable.of() : rightLink.request(operation, forward) || Observable.of();
                    });
                }
            };
            ApolloLink.execute = function (link, operation) {
                return link.request(createOperation(operation.context, transformOperation(validateOperation(operation)))) || Observable.of();
            };
            ApolloLink.concat = function (first, second) {
                var firstLink = toLink(first);
                if (isTerminating(firstLink)) {
                    true || invariant.invariant.warn(new LinkError("You are calling concat on a terminating link, which will have no effect", firstLink));
                    return firstLink;
                }
                var nextLink = toLink(second);
                if (isTerminating(nextLink)) {
                    return new ApolloLink(function (operation) {
                        return firstLink.request(operation, function (op) {
                            return nextLink.request(op) || Observable.of();
                        }) || Observable.of();
                    });
                } else {
                    return new ApolloLink(function (operation, forward) {
                        return firstLink.request(operation, function (op) {
                            return nextLink.request(op, forward) || Observable.of();
                        }) || Observable.of();
                    });
                }
            };
            ApolloLink.prototype.split = function (test, left, right) {
                return this.concat(ApolloLink.split(test, left, right || new ApolloLink(passthrough)));
            };
            ApolloLink.prototype.concat = function (next) {
                return ApolloLink.concat(this, next);
            };
            ApolloLink.prototype.request = function (operation, forward) {
                throw new invariant.InvariantError(11);
            };
            ApolloLink.prototype.onError = function (reason) {
                throw reason;
            };
            ApolloLink.prototype.setOnError = function (fn) {
                this.onError = fn;
                return this;
            };
            return ApolloLink;
        }();

        var execute = ApolloLink.execute;

        function shouldInclude(_a, variables) {
            var directives = _a.directives;
            if (!directives || !directives.length) {
                return true;
            }
            return getInclusionDirectives(directives).every(function (_a) {
                var directive = _a.directive,
                    ifArgument = _a.ifArgument;
                var evaledValue = false;
                if (ifArgument.value.kind === 'Variable') {
                    evaledValue = variables && variables[ifArgument.value.name.value];
                    invariant.invariant(evaledValue !== void 0, 37);
                } else {
                    evaledValue = ifArgument.value.value;
                }
                return directive.name.value === 'skip' ? !evaledValue : evaledValue;
            });
        }
        function getDirectiveNames(root) {
            var names = [];
            visitor.visit(root, {
                Directive: function (node) {
                    names.push(node.name.value);
                }
            });
            return names;
        }
        function hasDirectives(names, root) {
            return getDirectiveNames(root).some(function (name) {
                return names.indexOf(name) > -1;
            });
        }
        function hasClientExports(document) {
            return document && hasDirectives(['client'], document) && hasDirectives(['export'], document);
        }
        function isInclusionDirective(_a) {
            var value = _a.name.value;
            return value === 'skip' || value === 'include';
        }
        function getInclusionDirectives(directives) {
            var result = [];
            if (directives && directives.length) {
                directives.forEach(function (directive) {
                    if (!isInclusionDirective(directive)) return;
                    var directiveArguments = directive.arguments;
                    var directiveName = directive.name.value;
                    invariant.invariant(directiveArguments && directiveArguments.length === 1, 38);
                    var ifArgument = directiveArguments[0];
                    invariant.invariant(ifArgument.name && ifArgument.name.value === 'if', 39);
                    var ifValue = ifArgument.value;
                    invariant.invariant(ifValue && (ifValue.kind === 'Variable' || ifValue.kind === 'BooleanValue'), 40);
                    result.push({ directive: directive, ifArgument: ifArgument });
                });
            }
            return result;
        }

        function filterInPlace(array, test, context) {
            var target = 0;
            array.forEach(function (elem, i) {
                if (test.call(this, elem, i, array)) {
                    array[target++] = elem;
                }
            }, context);
            array.length = target;
            return array;
        }

        var TYPENAME_FIELD = {
            kind: 'Field',
            name: {
                kind: 'Name',
                value: '__typename'
            }
        };
        function isEmpty(op, fragments) {
            return op.selectionSet.selections.every(function (selection) {
                return selection.kind === 'FragmentSpread' && isEmpty(fragments[selection.name.value], fragments);
            });
        }
        function nullIfDocIsEmpty(doc) {
            return isEmpty(getOperationDefinition(doc) || getFragmentDefinition(doc), createFragmentMap(getFragmentDefinitions(doc))) ? null : doc;
        }
        function getDirectiveMatcher(directives) {
            return function directiveMatcher(directive) {
                return directives.some(function (dir) {
                    return dir.name && dir.name === directive.name.value || dir.test && dir.test(directive);
                });
            };
        }
        function removeDirectivesFromDocument(directives, doc) {
            var variablesInUse = Object.create(null);
            var variablesToRemove = [];
            var fragmentSpreadsInUse = Object.create(null);
            var fragmentSpreadsToRemove = [];
            var modifiedDoc = nullIfDocIsEmpty(visitor.visit(doc, {
                Variable: {
                    enter: function (node, _key, parent) {
                        if (parent.kind !== 'VariableDefinition') {
                            variablesInUse[node.name.value] = true;
                        }
                    }
                },
                Field: {
                    enter: function (node) {
                        if (directives && node.directives) {
                            var shouldRemoveField = directives.some(function (directive) {
                                return directive.remove;
                            });
                            if (shouldRemoveField && node.directives && node.directives.some(getDirectiveMatcher(directives))) {
                                if (node.arguments) {
                                    node.arguments.forEach(function (arg) {
                                        if (arg.value.kind === 'Variable') {
                                            variablesToRemove.push({
                                                name: arg.value.name.value
                                            });
                                        }
                                    });
                                }
                                if (node.selectionSet) {
                                    getAllFragmentSpreadsFromSelectionSet(node.selectionSet).forEach(function (frag) {
                                        fragmentSpreadsToRemove.push({
                                            name: frag.name.value
                                        });
                                    });
                                }
                                return null;
                            }
                        }
                    }
                },
                FragmentSpread: {
                    enter: function (node) {
                        fragmentSpreadsInUse[node.name.value] = true;
                    }
                },
                Directive: {
                    enter: function (node) {
                        if (getDirectiveMatcher(directives)(node)) {
                            return null;
                        }
                    }
                }
            }));
            if (modifiedDoc && filterInPlace(variablesToRemove, function (v) {
                return !!v.name && !variablesInUse[v.name];
            }).length) {
                modifiedDoc = removeArgumentsFromDocument(variablesToRemove, modifiedDoc);
            }
            if (modifiedDoc && filterInPlace(fragmentSpreadsToRemove, function (fs) {
                return !!fs.name && !fragmentSpreadsInUse[fs.name];
            }).length) {
                modifiedDoc = removeFragmentSpreadFromDocument(fragmentSpreadsToRemove, modifiedDoc);
            }
            return modifiedDoc;
        }
        function addTypenameToDocument(doc) {
            return visitor.visit(checkDocument(doc), {
                SelectionSet: {
                    enter: function (node, _key, parent) {
                        if (parent && parent.kind === 'OperationDefinition') {
                            return;
                        }
                        var selections = node.selections;
                        if (!selections) {
                            return;
                        }
                        var skip = selections.some(function (selection) {
                            return isField(selection) && (selection.name.value === '__typename' || selection.name.value.lastIndexOf('__', 0) === 0);
                        });
                        if (skip) {
                            return;
                        }
                        var field = parent;
                        if (isField(field) && field.directives && field.directives.some(function (d) {
                            return d.name.value === 'export';
                        })) {
                            return;
                        }
                        return tslib.__assign(tslib.__assign({}, node), { selections: tslib.__spreadArrays(selections, [TYPENAME_FIELD]) });
                    }
                }
            });
        }
        addTypenameToDocument.added = function (field) {
            return field === TYPENAME_FIELD;
        };
        var connectionRemoveConfig = {
            test: function (directive) {
                var willRemove = directive.name.value === 'connection';
                if (willRemove) {
                    if (!directive.arguments || !directive.arguments.some(function (arg) {
                        return arg.name.value === 'key';
                    })) {
                        true || invariant.invariant.warn('Removing an @connection directive even though it does not have a key. ' + 'You may want to use the key parameter to specify a store key.');
                    }
                }
                return willRemove;
            }
        };
        function removeConnectionDirectiveFromDocument(doc) {
            return removeDirectivesFromDocument([connectionRemoveConfig], checkDocument(doc));
        }
        function getArgumentMatcher(config) {
            return function argumentMatcher(argument) {
                return config.some(function (aConfig) {
                    return argument.value && argument.value.kind === 'Variable' && argument.value.name && (aConfig.name === argument.value.name.value || aConfig.test && aConfig.test(argument));
                });
            };
        }
        function removeArgumentsFromDocument(config, doc) {
            var argMatcher = getArgumentMatcher(config);
            return nullIfDocIsEmpty(visitor.visit(doc, {
                OperationDefinition: {
                    enter: function (node) {
                        return tslib.__assign(tslib.__assign({}, node), { variableDefinitions: node.variableDefinitions ? node.variableDefinitions.filter(function (varDef) {
                                return !config.some(function (arg) {
                                    return arg.name === varDef.variable.name.value;
                                });
                            }) : [] });
                    }
                },
                Field: {
                    enter: function (node) {
                        var shouldRemoveField = config.some(function (argConfig) {
                            return argConfig.remove;
                        });
                        if (shouldRemoveField) {
                            var argMatchCount_1 = 0;
                            if (node.arguments) {
                                node.arguments.forEach(function (arg) {
                                    if (argMatcher(arg)) {
                                        argMatchCount_1 += 1;
                                    }
                                });
                            }
                            if (argMatchCount_1 === 1) {
                                return null;
                            }
                        }
                    }
                },
                Argument: {
                    enter: function (node) {
                        if (argMatcher(node)) {
                            return null;
                        }
                    }
                }
            }));
        }
        function removeFragmentSpreadFromDocument(config, doc) {
            function enter(node) {
                if (config.some(function (def) {
                    return def.name === node.name.value;
                })) {
                    return null;
                }
            }
            return nullIfDocIsEmpty(visitor.visit(doc, {
                FragmentSpread: { enter: enter },
                FragmentDefinition: { enter: enter }
            }));
        }
        function getAllFragmentSpreadsFromSelectionSet(selectionSet) {
            var allFragments = [];
            selectionSet.selections.forEach(function (selection) {
                if ((isField(selection) || isInlineFragment(selection)) && selection.selectionSet) {
                    getAllFragmentSpreadsFromSelectionSet(selection.selectionSet).forEach(function (frag) {
                        return allFragments.push(frag);
                    });
                } else if (selection.kind === 'FragmentSpread') {
                    allFragments.push(selection);
                }
            });
            return allFragments;
        }
        function buildQueryFromSelectionSet(document) {
            var definition = getMainDefinition(document);
            var definitionOperation = definition.operation;
            if (definitionOperation === 'query') {
                return document;
            }
            var modifiedDoc = visitor.visit(document, {
                OperationDefinition: {
                    enter: function (node) {
                        return tslib.__assign(tslib.__assign({}, node), { operation: 'query' });
                    }
                }
            });
            return modifiedDoc;
        }
        function removeClientSetsFromDocument(document) {
            checkDocument(document);
            var modifiedDoc = removeDirectivesFromDocument([{
                test: function (directive) {
                    return directive.name.value === 'client';
                },
                remove: true
            }], document);
            if (modifiedDoc) {
                modifiedDoc = visitor.visit(modifiedDoc, {
                    FragmentDefinition: {
                        enter: function (node) {
                            if (node.selectionSet) {
                                var isTypenameOnly = node.selectionSet.selections.every(function (selection) {
                                    return isField(selection) && selection.name.value === '__typename';
                                });
                                if (isTypenameOnly) {
                                    return null;
                                }
                            }
                        }
                    }
                });
            }
            return modifiedDoc;
        }

        var hasOwnProperty = Object.prototype.hasOwnProperty;
        function mergeDeep() {
            var sources = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                sources[_i] = arguments[_i];
            }
            return mergeDeepArray(sources);
        }
        function mergeDeepArray(sources) {
            var target = sources[0] || {};
            var count = sources.length;
            if (count > 1) {
                var merger = new DeepMerger();
                for (var i = 1; i < count; ++i) {
                    target = merger.merge(target, sources[i]);
                }
            }
            return target;
        }
        function isObject(obj) {
            return obj !== null && typeof obj === 'object';
        }
        var defaultReconciler = function (target, source, property) {
            return this.merge(target[property], source[property]);
        };
        var DeepMerger = function () {
            function DeepMerger(reconciler) {
                if (reconciler === void 0) {
                    reconciler = defaultReconciler;
                }
                this.reconciler = reconciler;
                this.isObject = isObject;
                this.pastCopies = new Set();
            }
            DeepMerger.prototype.merge = function (target, source) {
                var _this = this;
                var context = [];
                for (var _i = 2; _i < arguments.length; _i++) {
                    context[_i - 2] = arguments[_i];
                }
                if (isObject(source) && isObject(target)) {
                    Object.keys(source).forEach(function (sourceKey) {
                        if (hasOwnProperty.call(target, sourceKey)) {
                            var targetValue = target[sourceKey];
                            if (source[sourceKey] !== targetValue) {
                                var result = _this.reconciler.apply(_this, tslib.__spreadArrays([target, source, sourceKey], context));
                                if (result !== targetValue) {
                                    target = _this.shallowCopyForMerge(target);
                                    target[sourceKey] = result;
                                }
                            }
                        } else {
                            target = _this.shallowCopyForMerge(target);
                            target[sourceKey] = source[sourceKey];
                        }
                    });
                    return target;
                }
                return source;
            };
            DeepMerger.prototype.shallowCopyForMerge = function (value) {
                if (isObject(value) && !this.pastCopies.has(value)) {
                    if (Array.isArray(value)) {
                        value = value.slice(0);
                    } else {
                        value = tslib.__assign({ __proto__: Object.getPrototypeOf(value) }, value);
                    }
                    this.pastCopies.add(value);
                }
                return value;
            };
            return DeepMerger;
        }();

        var LocalState = function () {
            function LocalState(_a) {
                var cache = _a.cache,
                    client = _a.client,
                    resolvers = _a.resolvers,
                    fragmentMatcher = _a.fragmentMatcher;
                this.cache = cache;
                if (client) {
                    this.client = client;
                }
                if (resolvers) {
                    this.addResolvers(resolvers);
                }
                if (fragmentMatcher) {
                    this.setFragmentMatcher(fragmentMatcher);
                }
            }
            LocalState.prototype.addResolvers = function (resolvers) {
                var _this = this;
                this.resolvers = this.resolvers || {};
                if (Array.isArray(resolvers)) {
                    resolvers.forEach(function (resolverGroup) {
                        _this.resolvers = mergeDeep(_this.resolvers, resolverGroup);
                    });
                } else {
                    this.resolvers = mergeDeep(this.resolvers, resolvers);
                }
            };
            LocalState.prototype.setResolvers = function (resolvers) {
                this.resolvers = {};
                this.addResolvers(resolvers);
            };
            LocalState.prototype.getResolvers = function () {
                return this.resolvers || {};
            };
            LocalState.prototype.runResolvers = function (_a) {
                var document = _a.document,
                    remoteResult = _a.remoteResult,
                    context = _a.context,
                    variables = _a.variables,
                    _b = _a.onlyRunForcedResolvers,
                    onlyRunForcedResolvers = _b === void 0 ? false : _b;
                return tslib.__awaiter(this, void 0, void 0, function () {
                    return tslib.__generator(this, function (_c) {
                        if (document) {
                            return [2, this.resolveDocument(document, remoteResult.data, context, variables, this.fragmentMatcher, onlyRunForcedResolvers).then(function (localResult) {
                                return tslib.__assign(tslib.__assign({}, remoteResult), { data: localResult.result });
                            })];
                        }
                        return [2, remoteResult];
                    });
                });
            };
            LocalState.prototype.setFragmentMatcher = function (fragmentMatcher) {
                this.fragmentMatcher = fragmentMatcher;
            };
            LocalState.prototype.getFragmentMatcher = function () {
                return this.fragmentMatcher;
            };
            LocalState.prototype.clientQuery = function (document) {
                if (hasDirectives(['client'], document)) {
                    if (this.resolvers) {
                        return document;
                    }
                }
                return null;
            };
            LocalState.prototype.serverQuery = function (document) {
                return removeClientSetsFromDocument(document);
            };
            LocalState.prototype.prepareContext = function (context) {
                var cache = this.cache;
                return tslib.__assign(tslib.__assign({}, context), { cache: cache,
                    getCacheKey: function (obj) {
                        return cache.identify(obj);
                    } });
            };
            LocalState.prototype.addExportedVariables = function (document, variables, context) {
                if (variables === void 0) {
                    variables = {};
                }
                if (context === void 0) {
                    context = {};
                }
                return tslib.__awaiter(this, void 0, void 0, function () {
                    return tslib.__generator(this, function (_a) {
                        if (document) {
                            return [2, this.resolveDocument(document, this.buildRootValueFromCache(document, variables) || {}, this.prepareContext(context), variables).then(function (data) {
                                return tslib.__assign(tslib.__assign({}, variables), data.exportedVariables);
                            })];
                        }
                        return [2, tslib.__assign({}, variables)];
                    });
                });
            };
            LocalState.prototype.shouldForceResolvers = function (document) {
                var forceResolvers = false;
                visitor.visit(document, {
                    Directive: {
                        enter: function (node) {
                            if (node.name.value === 'client' && node.arguments) {
                                forceResolvers = node.arguments.some(function (arg) {
                                    return arg.name.value === 'always' && arg.value.kind === 'BooleanValue' && arg.value.value === true;
                                });
                                if (forceResolvers) {
                                    return visitor.BREAK;
                                }
                            }
                        }
                    }
                });
                return forceResolvers;
            };
            LocalState.prototype.buildRootValueFromCache = function (document, variables) {
                return this.cache.diff({
                    query: buildQueryFromSelectionSet(document),
                    variables: variables,
                    returnPartialData: true,
                    optimistic: false
                }).result;
            };
            LocalState.prototype.resolveDocument = function (document, rootValue, context, variables, fragmentMatcher, onlyRunForcedResolvers) {
                if (context === void 0) {
                    context = {};
                }
                if (variables === void 0) {
                    variables = {};
                }
                if (fragmentMatcher === void 0) {
                    fragmentMatcher = function () {
                        return true;
                    };
                }
                if (onlyRunForcedResolvers === void 0) {
                    onlyRunForcedResolvers = false;
                }
                return tslib.__awaiter(this, void 0, void 0, function () {
                    var mainDefinition, fragments, fragmentMap, definitionOperation, defaultOperationType, _a, cache, client, execContext;
                    return tslib.__generator(this, function (_b) {
                        mainDefinition = getMainDefinition(document);
                        fragments = getFragmentDefinitions(document);
                        fragmentMap = createFragmentMap(fragments);
                        definitionOperation = mainDefinition.operation;
                        defaultOperationType = definitionOperation ? definitionOperation.charAt(0).toUpperCase() + definitionOperation.slice(1) : 'Query';
                        _a = this, cache = _a.cache, client = _a.client;
                        execContext = {
                            fragmentMap: fragmentMap,
                            context: tslib.__assign(tslib.__assign({}, context), { cache: cache,
                                client: client }),
                            variables: variables,
                            fragmentMatcher: fragmentMatcher,
                            defaultOperationType: defaultOperationType,
                            exportedVariables: {},
                            onlyRunForcedResolvers: onlyRunForcedResolvers
                        };
                        return [2, this.resolveSelectionSet(mainDefinition.selectionSet, rootValue, execContext).then(function (result) {
                            return {
                                result: result,
                                exportedVariables: execContext.exportedVariables
                            };
                        })];
                    });
                });
            };
            LocalState.prototype.resolveSelectionSet = function (selectionSet, rootValue, execContext) {
                return tslib.__awaiter(this, void 0, void 0, function () {
                    var fragmentMap, context, variables, resultsToMerge, execute;
                    var _this = this;
                    return tslib.__generator(this, function (_a) {
                        fragmentMap = execContext.fragmentMap, context = execContext.context, variables = execContext.variables;
                        resultsToMerge = [rootValue];
                        execute = function (selection) {
                            return tslib.__awaiter(_this, void 0, void 0, function () {
                                var fragment, typeCondition;
                                return tslib.__generator(this, function (_a) {
                                    if (!shouldInclude(selection, variables)) {
                                        return [2];
                                    }
                                    if (isField(selection)) {
                                        return [2, this.resolveField(selection, rootValue, execContext).then(function (fieldResult) {
                                            var _a;
                                            if (typeof fieldResult !== 'undefined') {
                                                resultsToMerge.push((_a = {}, _a[resultKeyNameFromField(selection)] = fieldResult, _a));
                                            }
                                        })];
                                    }
                                    if (isInlineFragment(selection)) {
                                        fragment = selection;
                                    } else {
                                        fragment = fragmentMap[selection.name.value];
                                        invariant.invariant(fragment, 14);
                                    }
                                    if (fragment && fragment.typeCondition) {
                                        typeCondition = fragment.typeCondition.name.value;
                                        if (execContext.fragmentMatcher(rootValue, typeCondition, context)) {
                                            return [2, this.resolveSelectionSet(fragment.selectionSet, rootValue, execContext).then(function (fragmentResult) {
                                                resultsToMerge.push(fragmentResult);
                                            })];
                                        }
                                    }
                                    return [2];
                                });
                            });
                        };
                        return [2, Promise.all(selectionSet.selections.map(execute)).then(function () {
                            return mergeDeepArray(resultsToMerge);
                        })];
                    });
                });
            };
            LocalState.prototype.resolveField = function (field, rootValue, execContext) {
                return tslib.__awaiter(this, void 0, void 0, function () {
                    var variables, fieldName, aliasedFieldName, aliasUsed, defaultResult, resultPromise, resolverType, resolverMap, resolve;
                    var _this = this;
                    return tslib.__generator(this, function (_a) {
                        variables = execContext.variables;
                        fieldName = field.name.value;
                        aliasedFieldName = resultKeyNameFromField(field);
                        aliasUsed = fieldName !== aliasedFieldName;
                        defaultResult = rootValue[aliasedFieldName] || rootValue[fieldName];
                        resultPromise = Promise.resolve(defaultResult);
                        if (!execContext.onlyRunForcedResolvers || this.shouldForceResolvers(field)) {
                            resolverType = rootValue.__typename || execContext.defaultOperationType;
                            resolverMap = this.resolvers && this.resolvers[resolverType];
                            if (resolverMap) {
                                resolve = resolverMap[aliasUsed ? fieldName : aliasedFieldName];
                                if (resolve) {
                                    resultPromise = Promise.resolve(resolve(rootValue, argumentsObjectFromField(field, variables), execContext.context, { field: field, fragmentMap: execContext.fragmentMap }));
                                }
                            }
                        }
                        return [2, resultPromise.then(function (result) {
                            if (result === void 0) {
                                result = defaultResult;
                            }
                            if (field.directives) {
                                field.directives.forEach(function (directive) {
                                    if (directive.name.value === 'export' && directive.arguments) {
                                        directive.arguments.forEach(function (arg) {
                                            if (arg.name.value === 'as' && arg.value.kind === 'StringValue') {
                                                execContext.exportedVariables[arg.value.value] = result;
                                            }
                                        });
                                    }
                                });
                            }
                            if (!field.selectionSet) {
                                return result;
                            }
                            if (result == null) {
                                return result;
                            }
                            if (Array.isArray(result)) {
                                return _this.resolveSubSelectedArray(field, result, execContext);
                            }
                            if (field.selectionSet) {
                                return _this.resolveSelectionSet(field.selectionSet, result, execContext);
                            }
                        })];
                    });
                });
            };
            LocalState.prototype.resolveSubSelectedArray = function (field, result, execContext) {
                var _this = this;
                return Promise.all(result.map(function (item) {
                    if (item === null) {
                        return null;
                    }
                    if (Array.isArray(item)) {
                        return _this.resolveSubSelectedArray(field, item, execContext);
                    }
                    if (field.selectionSet) {
                        return _this.resolveSelectionSet(field.selectionSet, item, execContext);
                    }
                }));
            };
            return LocalState;
        }();

        function tryFunctionOrLogError(f) {
            try {
                return f();
            } catch (e) {
                if (console.error) {
                    console.error(e);
                }
            }
        }
        function graphQLResultHasError(result) {
            return result.errors && result.errors.length > 0 || false;
        }

        var canUseWeakMap = typeof WeakMap === 'function' && !(typeof navigator === 'object' && navigator.product === 'ReactNative');

        function isNonEmptyArray(value) {
            return Array.isArray(value) && value.length > 0;
        }

        function isApolloError(err) {
            return err.hasOwnProperty('graphQLErrors');
        }
        var generateErrorMessage = function (err) {
            var message = '';
            if (isNonEmptyArray(err.graphQLErrors)) {
                err.graphQLErrors.forEach(function (graphQLError) {
                    var errorMessage = graphQLError ? graphQLError.message : 'Error message not found.';
                    message += errorMessage + "\n";
                });
            }
            if (err.networkError) {
                message += err.networkError.message + "\n";
            }
            message = message.replace(/\n$/, '');
            return message;
        };
        var ApolloError = function (_super) {
            tslib.__extends(ApolloError, _super);
            function ApolloError(_a) {
                var graphQLErrors = _a.graphQLErrors,
                    networkError = _a.networkError,
                    errorMessage = _a.errorMessage,
                    extraInfo = _a.extraInfo;
                var _this = _super.call(this, errorMessage) || this;
                _this.graphQLErrors = graphQLErrors || [];
                _this.networkError = networkError || null;
                _this.message = errorMessage || generateErrorMessage(_this);
                _this.extraInfo = extraInfo;
                _this.__proto__ = ApolloError.prototype;
                return _this;
            }
            return ApolloError;
        }(Error);

        var MutationStore = function () {
            function MutationStore() {
                this.store = {};
            }
            MutationStore.prototype.getStore = function () {
                return this.store;
            };
            MutationStore.prototype.get = function (mutationId) {
                return this.store[mutationId];
            };
            MutationStore.prototype.initMutation = function (mutationId, mutation, variables) {
                this.store[mutationId] = {
                    mutation: mutation,
                    variables: variables || {},
                    loading: true,
                    error: null
                };
            };
            MutationStore.prototype.markMutationError = function (mutationId, error) {
                var mutation = this.store[mutationId];
                if (mutation) {
                    mutation.loading = false;
                    mutation.error = error;
                }
            };
            MutationStore.prototype.markMutationResult = function (mutationId) {
                var mutation = this.store[mutationId];
                if (mutation) {
                    mutation.loading = false;
                    mutation.error = null;
                }
            };
            MutationStore.prototype.reset = function () {
                this.store = {};
            };
            return MutationStore;
        }();

        var NetworkStatus;
        (function (NetworkStatus) {
            NetworkStatus[NetworkStatus["loading"] = 1] = "loading";
            NetworkStatus[NetworkStatus["setVariables"] = 2] = "setVariables";
            NetworkStatus[NetworkStatus["fetchMore"] = 3] = "fetchMore";
            NetworkStatus[NetworkStatus["refetch"] = 4] = "refetch";
            NetworkStatus[NetworkStatus["poll"] = 6] = "poll";
            NetworkStatus[NetworkStatus["ready"] = 7] = "ready";
            NetworkStatus[NetworkStatus["error"] = 8] = "error";
        })(NetworkStatus || (NetworkStatus = {}));
        function isNetworkRequestInFlight(networkStatus) {
            return networkStatus ? networkStatus < 7 : false;
        }

        var toString = Object.prototype.toString;
        function cloneDeep(value) {
            return cloneDeepHelper(value);
        }
        function cloneDeepHelper(val, seen) {
            switch (toString.call(val)) {
                case "[object Array]":
                    {
                        seen = seen || new Map();
                        if (seen.has(val)) return seen.get(val);
                        var copy_1 = val.slice(0);
                        seen.set(val, copy_1);
                        copy_1.forEach(function (child, i) {
                            copy_1[i] = cloneDeepHelper(child, seen);
                        });
                        return copy_1;
                    }
                case "[object Object]":
                    {
                        seen = seen || new Map();
                        if (seen.has(val)) return seen.get(val);
                        var copy_2 = Object.create(Object.getPrototypeOf(val));
                        seen.set(val, copy_2);
                        Object.keys(val).forEach(function (key) {
                            copy_2[key] = cloneDeepHelper(val[key], seen);
                        });
                        return copy_2;
                    }
                default:
                    return val;
            }
        }

        function iterateObserversSafely(observers, method, argument) {
            var observersWithMethod = [];
            observers.forEach(function (obs) {
                return obs[method] && observersWithMethod.push(obs);
            });
            observersWithMethod.forEach(function (obs) {
                return obs[method](argument);
            });
        }

        var Reobserver = function () {
            function Reobserver(observer, options, fetch, shouldFetch) {
                this.observer = observer;
                this.options = options;
                this.fetch = fetch;
                this.shouldFetch = shouldFetch;
            }
            Reobserver.prototype.reobserve = function (newOptions, newNetworkStatus) {
                if (newOptions) {
                    this.updateOptions(newOptions);
                } else {
                    this.updatePolling();
                }
                var concast = this.fetch(this.options, newNetworkStatus);
                if (this.concast) {
                    this.concast.removeObserver(this.observer, true);
                }
                concast.addObserver(this.observer);
                return (this.concast = concast).promise;
            };
            Reobserver.prototype.updateOptions = function (newOptions) {
                var _this = this;
                Object.keys(newOptions).forEach(function (key) {
                    var value = newOptions[key];
                    if (value !== void 0) {
                        _this.options[key] = value;
                    }
                });
                this.updatePolling();
                return this;
            };
            Reobserver.prototype.stop = function () {
                if (this.concast) {
                    this.concast.removeObserver(this.observer);
                    delete this.concast;
                }
                if (this.pollingInfo) {
                    clearTimeout(this.pollingInfo.timeout);
                    this.options.pollInterval = 0;
                    this.updatePolling();
                }
            };
            Reobserver.prototype.updatePolling = function () {
                var _this = this;
                var _a = this,
                    pollingInfo = _a.pollingInfo,
                    pollInterval = _a.options.pollInterval;
                if (!pollInterval) {
                    if (pollingInfo) {
                        clearTimeout(pollingInfo.timeout);
                        delete this.pollingInfo;
                    }
                    return;
                }
                if (pollingInfo && pollingInfo.interval === pollInterval) {
                    return;
                }
                invariant.invariant(pollInterval, 23);
                if (this.shouldFetch === false) {
                    return;
                }
                var info = pollingInfo || (this.pollingInfo = {});
                info.interval = pollInterval;
                var maybeFetch = function () {
                    if (_this.pollingInfo) {
                        if (_this.shouldFetch && _this.shouldFetch()) {
                            _this.reobserve({
                                fetchPolicy: "network-only"
                            }, NetworkStatus.poll).then(poll, poll);
                        } else {
                            poll();
                        }
                    }
                };
                var poll = function () {
                    var info = _this.pollingInfo;
                    if (info) {
                        clearTimeout(info.timeout);
                        info.timeout = setTimeout(maybeFetch, info.interval);
                    }
                };
                poll();
            };
            return Reobserver;
        }();

        var hasError = function (storeValue, policy) {
            if (policy === void 0) {
                policy = 'none';
            }
            return storeValue && (storeValue.networkError || policy === 'none' && isNonEmptyArray(storeValue.graphQLErrors));
        };
        var ObservableQuery = function (_super) {
            tslib.__extends(ObservableQuery, _super);
            function ObservableQuery(_a) {
                var queryManager = _a.queryManager,
                    options = _a.options;
                var _this = _super.call(this, function (observer) {
                    return _this.onSubscribe(observer);
                }) || this;
                _this.observers = new Set();
                _this.subscriptions = new Set();
                _this.observer = {
                    next: function (result) {
                        if (_this.lastError || _this.isDifferentFromLastResult(result)) {
                            _this.updateLastResult(result);
                            iterateObserversSafely(_this.observers, 'next', result);
                        }
                    },
                    error: function (error) {
                        _this.updateLastResult(tslib.__assign(tslib.__assign({}, _this.lastResult), { errors: error.graphQLErrors, networkStatus: NetworkStatus.error, loading: false }));
                        iterateObserversSafely(_this.observers, 'error', _this.lastError = error);
                    }
                };
                _this.isTornDown = false;
                _this.options = options;
                _this.queryId = queryManager.generateQueryId();
                var opDef = getOperationDefinition(options.query);
                _this.queryName = opDef && opDef.name && opDef.name.value;
                _this.queryManager = queryManager;
                return _this;
            }
            Object.defineProperty(ObservableQuery.prototype, "variables", {
                get: function () {
                    return this.options.variables;
                },
                enumerable: false,
                configurable: true
            });
            ObservableQuery.prototype.result = function () {
                var _this = this;
                return new Promise(function (resolve, reject) {
                    var observer = {
                        next: function (result) {
                            resolve(result);
                            _this.observers.delete(observer);
                            if (!_this.observers.size) {
                                _this.queryManager.removeQuery(_this.queryId);
                            }
                            setTimeout(function () {
                                subscription.unsubscribe();
                            }, 0);
                        },
                        error: reject
                    };
                    var subscription = _this.subscribe(observer);
                });
            };
            ObservableQuery.prototype.getCurrentResult = function () {
                var _a = this,
                    lastResult = _a.lastResult,
                    lastError = _a.lastError,
                    fetchPolicy = _a.options.fetchPolicy;

                var networkStatus = lastError ? NetworkStatus.error : lastResult ? lastResult.networkStatus : fetchPolicy === 'network-only' || fetchPolicy === 'no-cache' ? NetworkStatus.loading : NetworkStatus.ready;
                var result = {
                    data: !lastError && lastResult && lastResult.data || void 0,
                    error: lastError,
                    loading: isNetworkRequestInFlight(networkStatus),
                    networkStatus: networkStatus
                };
                if (this.isTornDown) {
                    return result;
                }
                var _b = this.getCurrentQueryResult(),
                    data = _b.data,
                    partial = _b.partial;
                Object.assign(result, { data: data, partial: partial });
                var queryStoreValue = this.queryManager.getQueryStoreValue(this.queryId);
                if (queryStoreValue) {
                    var networkStatus_1 = queryStoreValue.networkStatus;
                    if (hasError(queryStoreValue, this.options.errorPolicy)) {
                        return Object.assign(result, {
                            data: void 0,
                            networkStatus: networkStatus_1,
                            error: new ApolloError({
                                graphQLErrors: queryStoreValue.graphQLErrors,
                                networkError: queryStoreValue.networkError
                            })
                        });
                    }
                    if (queryStoreValue.variables) {
                        this.options.variables = tslib.__assign(tslib.__assign({}, this.options.variables), queryStoreValue.variables);
                    }
                    Object.assign(result, {
                        loading: isNetworkRequestInFlight(networkStatus_1),
                        networkStatus: networkStatus_1
                    });
                    if (queryStoreValue.graphQLErrors && this.options.errorPolicy === 'all') {
                        result.errors = queryStoreValue.graphQLErrors;
                    }
                }
                if (!partial) {
                    this.updateLastResult(result);
                }
                return result;
            };
            ObservableQuery.prototype.isDifferentFromLastResult = function (newResult) {
                return !equality.equal(this.lastResultSnapshot, newResult);
            };
            ObservableQuery.prototype.getLastResult = function () {
                return this.lastResult;
            };
            ObservableQuery.prototype.getLastError = function () {
                return this.lastError;
            };
            ObservableQuery.prototype.resetLastResults = function () {
                delete this.lastResult;
                delete this.lastResultSnapshot;
                delete this.lastError;
                this.isTornDown = false;
            };
            ObservableQuery.prototype.resetQueryStoreErrors = function () {
                var queryStore = this.queryManager.getQueryStoreValue(this.queryId);
                if (queryStore) {
                    queryStore.networkError = undefined;
                    queryStore.graphQLErrors = [];
                }
            };
            ObservableQuery.prototype.refetch = function (variables) {
                var fetchPolicy = this.options.fetchPolicy;
                if (fetchPolicy === 'cache-only') {
                    return Promise.reject(new invariant.InvariantError(3));
                }
                if (fetchPolicy !== 'no-cache' && fetchPolicy !== 'cache-and-network') {
                    fetchPolicy = 'network-only';
                }
                if (variables && !equality.equal(this.options.variables, variables)) {
                    this.options.variables = tslib.__assign(tslib.__assign({}, this.options.variables), variables);
                }
                return this.newReobserver(false).reobserve({
                    fetchPolicy: fetchPolicy,
                    variables: this.options.variables,
                    pollInterval: 0
                }, NetworkStatus.refetch);
            };
            ObservableQuery.prototype.fetchMore = function (fetchMoreOptions) {
                var _this = this;
                var combinedOptions = tslib.__assign(tslib.__assign({}, fetchMoreOptions.query ? fetchMoreOptions : tslib.__assign(tslib.__assign(tslib.__assign({}, this.options), fetchMoreOptions), { variables: tslib.__assign(tslib.__assign({}, this.options.variables), fetchMoreOptions.variables) })), { fetchPolicy: "no-cache" });
                var qid = this.queryManager.generateQueryId();
                return this.queryManager.fetchQuery(qid, combinedOptions, NetworkStatus.fetchMore).then(function (fetchMoreResult) {
                    _this.updateQuery(function (previousResult) {
                        var data = fetchMoreResult.data;
                        var updateQuery = fetchMoreOptions.updateQuery;
                        return updateQuery ? updateQuery(previousResult, {
                            fetchMoreResult: data,
                            variables: combinedOptions.variables
                        }) : data;
                    });
                    return fetchMoreResult;
                }).finally(function () {
                    _this.queryManager.stopQuery(qid);
                    _this.reobserve();
                });
            };
            ObservableQuery.prototype.subscribeToMore = function (options) {
                var _this = this;
                var subscription = this.queryManager.startGraphQLSubscription({
                    query: options.document,
                    variables: options.variables
                }).subscribe({
                    next: function (subscriptionData) {
                        var updateQuery = options.updateQuery;
                        if (updateQuery) {
                            _this.updateQuery(function (previous, _a) {
                                var variables = _a.variables;
                                return updateQuery(previous, {
                                    subscriptionData: subscriptionData,
                                    variables: variables
                                });
                            });
                        }
                    },
                    error: function (err) {
                        if (options.onError) {
                            options.onError(err);
                            return;
                        }
                        true || invariant.invariant.error('Unhandled GraphQL subscription error', err);
                    }
                });
                this.subscriptions.add(subscription);
                return function () {
                    if (_this.subscriptions.delete(subscription)) {
                        subscription.unsubscribe();
                    }
                };
            };
            ObservableQuery.prototype.setOptions = function (newOptions) {
                return this.reobserve(newOptions);
            };
            ObservableQuery.prototype.setVariables = function (variables) {
                if (equality.equal(this.variables, variables)) {
                    return this.observers.size ? this.result() : Promise.resolve();
                }
                this.options.variables = variables;
                if (!this.observers.size) {
                    return Promise.resolve();
                }
                var fetchPolicy = this.options.fetchPolicy;
                if (fetchPolicy !== 'cache-first' && fetchPolicy !== 'no-cache' && fetchPolicy !== 'network-only') {
                    fetchPolicy = 'cache-and-network';
                }
                return this.reobserve({
                    fetchPolicy: fetchPolicy,
                    variables: variables
                }, NetworkStatus.setVariables);
            };
            ObservableQuery.prototype.updateQuery = function (mapFn) {
                var _this = this;
                var queryManager = this.queryManager;
                var previousResult = this.getCurrentQueryResult(false).data;
                var newResult = tryFunctionOrLogError(function () {
                    return mapFn(previousResult, {
                        variables: _this.variables
                    });
                });
                if (newResult) {
                    queryManager.cache.writeQuery({
                        query: this.options.query,
                        data: newResult,
                        variables: this.variables
                    });
                    queryManager.broadcastQueries();
                }
            };
            ObservableQuery.prototype.getCurrentQueryResult = function (optimistic) {
                var _a, _b;
                if (optimistic === void 0) {
                    optimistic = true;
                }
                var fetchPolicy = this.options.fetchPolicy;
                if (fetchPolicy === 'no-cache' || fetchPolicy === 'network-only') {
                    return {
                        data: (_a = this.lastResult) === null || _a === void 0 ? void 0 : _a.data,
                        partial: false
                    };
                }
                var _c = this.queryManager.cache.diff({
                    query: this.options.query,
                    variables: this.variables,
                    previousResult: (_b = this.lastResult) === null || _b === void 0 ? void 0 : _b.data,
                    returnPartialData: true,
                    optimistic: optimistic
                }),
                    result = _c.result,
                    complete = _c.complete;
                return {
                    data: complete || this.options.returnPartialData ? result : void 0,
                    partial: !complete
                };
            };
            ObservableQuery.prototype.startPolling = function (pollInterval) {
                this.getReobserver().updateOptions({ pollInterval: pollInterval });
            };
            ObservableQuery.prototype.stopPolling = function () {
                if (this.reobserver) {
                    this.reobserver.updateOptions({ pollInterval: 0 });
                }
            };
            ObservableQuery.prototype.updateLastResult = function (newResult) {
                var previousResult = this.lastResult;
                this.lastResult = newResult;
                this.lastResultSnapshot = this.queryManager.assumeImmutableResults ? newResult : cloneDeep(newResult);
                if (!isNonEmptyArray(newResult.errors)) {
                    delete this.lastError;
                }
                return previousResult;
            };
            ObservableQuery.prototype.onSubscribe = function (observer) {
                var _this = this;
                if (observer === this.observer) {
                    return function () {};
                }
                try {
                    var subObserver = observer._subscription._observer;
                    if (subObserver && !subObserver.error) {
                        subObserver.error = defaultSubscriptionObserverErrorCallback;
                    }
                } catch (_a) {}
                var first = !this.observers.size;
                this.observers.add(observer);
                if (observer.next && this.lastResult) observer.next(this.lastResult);
                if (observer.error && this.lastError) observer.error(this.lastError);
                if (first) {
                    this.reobserve().catch(function (_) {});
                }
                return function () {
                    if (_this.observers.delete(observer) && !_this.observers.size) {
                        _this.tearDownQuery();
                    }
                };
            };
            ObservableQuery.prototype.getReobserver = function () {
                return this.reobserver || (this.reobserver = this.newReobserver(true));
            };
            ObservableQuery.prototype.newReobserver = function (shareOptions) {
                var _this = this;
                var _a = this,
                    queryManager = _a.queryManager,
                    queryId = _a.queryId;
                queryManager.setObservableQuery(this);
                return new Reobserver(this.observer, shareOptions ? this.options : tslib.__assign({}, this.options), function (currentOptions, newNetworkStatus) {
                    queryManager.setObservableQuery(_this);
                    return queryManager.fetchQueryObservable(queryId, currentOptions, newNetworkStatus);
                }, !queryManager.ssrMode && function () {
                    return !queryManager.checkInFlight(queryId);
                });
            };
            ObservableQuery.prototype.reobserve = function (newOptions, newNetworkStatus) {
                this.isTornDown = false;
                return this.getReobserver().reobserve(newOptions, newNetworkStatus);
            };
            ObservableQuery.prototype.tearDownQuery = function () {
                var queryManager = this.queryManager;
                if (this.reobserver) {
                    this.reobserver.stop();
                    delete this.reobserver;
                }
                this.isTornDown = true;
                this.subscriptions.forEach(function (sub) {
                    return sub.unsubscribe();
                });
                this.subscriptions.clear();
                queryManager.stopQuery(this.queryId);
                this.observers.clear();
            };
            return ObservableQuery;
        }(Observable);
        function defaultSubscriptionObserverErrorCallback(error) {
            true || invariant.invariant.error('Unhandled error', error.message, error.stack);
        }

        function asyncMap(observable, mapFn, catchFn) {
            return new Observable(function (observer) {
                var next = observer.next,
                    error = observer.error,
                    complete = observer.complete;
                var activeCallbackCount = 0;
                var completed = false;
                function makeCallback(examiner, delegate) {
                    if (examiner) {
                        return function (arg) {
                            ++activeCallbackCount;
                            new Promise(function (resolve) {
                                return resolve(examiner(arg));
                            }).then(function (result) {
                                --activeCallbackCount;
                                next && next.call(observer, result);
                                if (completed) {
                                    handler.complete();
                                }
                            }, function (e) {
                                --activeCallbackCount;
                                error && error.call(observer, e);
                            });
                        };
                    } else {
                        return function (arg) {
                            return delegate && delegate.call(observer, arg);
                        };
                    }
                }
                var handler = {
                    next: makeCallback(mapFn, next),
                    error: makeCallback(catchFn, error),
                    complete: function () {
                        completed = true;
                        if (!activeCallbackCount) {
                            complete && complete.call(observer);
                        }
                    }
                };
                var sub = observable.subscribe(handler);
                return function () {
                    return sub.unsubscribe();
                };
            });
        }

        function isPromiseLike(value) {
            return value && typeof value.then === "function";
        }
        var Concast = function (_super) {
            tslib.__extends(Concast, _super);
            function Concast(sources) {
                var _this = _super.call(this, function (observer) {
                    _this.addObserver(observer);
                    return function () {
                        return _this.removeObserver(observer);
                    };
                }) || this;
                _this.observers = new Set();
                _this.promise = new Promise(function (resolve, reject) {
                    _this.resolve = resolve;
                    _this.reject = reject;
                });
                _this.handlers = {
                    next: function (result) {
                        if (_this.sub !== null) {
                            _this.latest = ["next", result];
                            iterateObserversSafely(_this.observers, "next", result);
                        }
                    },
                    error: function (error) {
                        if (_this.sub !== null) {
                            if (_this.sub) _this.sub.unsubscribe();
                            _this.sub = null;
                            _this.latest = ["error", error];
                            _this.reject(error);
                            iterateObserversSafely(_this.observers, "error", error);
                        }
                    },
                    complete: function () {
                        if (_this.sub !== null) {
                            var value = _this.sources.shift();
                            if (!value) {
                                _this.sub = null;
                                if (_this.latest && _this.latest[0] === "next") {
                                    _this.resolve(_this.latest[1]);
                                } else {
                                    _this.resolve();
                                }
                                iterateObserversSafely(_this.observers, "complete");
                            } else if (isPromiseLike(value)) {
                                value.then(function (obs) {
                                    return _this.sub = obs.subscribe(_this.handlers);
                                });
                            } else {
                                _this.sub = value.subscribe(_this.handlers);
                            }
                        }
                    }
                };
                _this.cancel = function (reason) {
                    _this.reject(reason);
                    _this.sources = [];
                    _this.handlers.complete();
                };
                _this.promise.catch(function (_) {});
                if (isPromiseLike(sources)) {
                    sources.then(function (iterable) {
                        return _this.start(iterable);
                    }, _this.handlers.error);
                } else {
                    _this.start(sources);
                }
                return _this;
            }
            Concast.prototype.start = function (sources) {
                if (this.sub !== void 0) return;
                this.sources = Array.from(sources);
                this.handlers.complete();
            };
            Concast.prototype.addObserver = function (observer) {
                if (!this.observers.has(observer)) {
                    if (this.latest) {
                        var nextOrError = this.latest[0];
                        var method = observer[nextOrError];
                        if (method) {
                            method.call(observer, this.latest[1]);
                        }
                        if (this.sub === null && nextOrError === "next" && observer.complete) {
                            observer.complete();
                        }
                    }
                    this.observers.add(observer);
                }
            };
            Concast.prototype.removeObserver = function (observer, quietly) {
                if (this.observers.delete(observer) && this.observers.size < 1) {
                    if (quietly) return;
                    if (this.sub) {
                        this.sub.unsubscribe();
                        this.reject(new Error("Observable cancelled prematurely"));
                    }
                    this.sub = null;
                }
            };
            Concast.prototype.cleanup = function (callback) {
                var _this = this;
                var called = false;
                var once = function () {
                    if (!called) {
                        called = true;
                        _this.observers.delete(observer);
                        callback();
                    }
                };
                var observer = {
                    next: once,
                    error: once,
                    complete: once
                };
                this.addObserver(observer);
            };
            return Concast;
        }(Observable);
        if (typeof Symbol === "function" && Symbol.species) {
            Object.defineProperty(Concast, Symbol.species, {
                value: Observable
            });
        }

        var QueryInfo = function () {
            function QueryInfo(cache) {
                this.cache = cache;
                this.listeners = new Set();
                this.document = null;
                this.lastRequestId = 1;
                this.subscriptions = new Set();
                this.dirty = false;
                this.diff = null;
                this.observableQuery = null;
            }
            QueryInfo.prototype.init = function (query) {
                var networkStatus = query.networkStatus || NetworkStatus.loading;
                if (this.variables && this.networkStatus !== NetworkStatus.loading && !equality.equal(this.variables, query.variables)) {
                    networkStatus = NetworkStatus.setVariables;
                }
                Object.assign(this, {
                    document: query.document,
                    variables: query.variables,
                    networkError: null,
                    graphQLErrors: this.graphQLErrors || [],
                    networkStatus: networkStatus
                });
                if (query.observableQuery) {
                    this.setObservableQuery(query.observableQuery);
                }
                if (query.lastRequestId) {
                    this.lastRequestId = query.lastRequestId;
                }
                return this;
            };
            QueryInfo.prototype.setDirty = function () {
                var _this = this;
                if (!this.dirty) {
                    this.dirty = true;
                    if (!this.notifyTimeout) {
                        this.notifyTimeout = setTimeout(function () {
                            return _this.notify();
                        }, 0);
                    }
                }
                return this;
            };
            QueryInfo.prototype.setDiff = function (diff) {
                var oldDiff = this.diff;
                this.diff = diff;
                if (!this.dirty && (diff === null || diff === void 0 ? void 0 : diff.result) !== (oldDiff === null || oldDiff === void 0 ? void 0 : oldDiff.result)) {
                    this.setDirty();
                }
            };
            QueryInfo.prototype.setObservableQuery = function (oq) {
                if (oq === this.observableQuery) return;
                if (this.oqListener) {
                    this.listeners.delete(this.oqListener);
                }
                this.observableQuery = oq;
                if (oq) {
                    this.listeners.add(this.oqListener = function () {
                        return oq.reobserve();
                    });
                } else {
                    delete this.oqListener;
                }
            };
            QueryInfo.prototype.notify = function () {
                var _this = this;
                if (this.notifyTimeout) {
                    clearTimeout(this.notifyTimeout);
                    this.notifyTimeout = void 0;
                }
                if (this.shouldNotify()) {
                    this.listeners.forEach(function (listener) {
                        return listener(_this);
                    });
                }
                this.dirty = false;
            };
            QueryInfo.prototype.shouldNotify = function () {
                if (!this.dirty || !this.listeners.size) {
                    return false;
                }
                if (isNetworkRequestInFlight(this.networkStatus) && this.observableQuery) {
                    var fetchPolicy = this.observableQuery.options.fetchPolicy;
                    if (fetchPolicy !== "cache-only" && fetchPolicy !== "cache-and-network") {
                        return false;
                    }
                }
                return true;
            };
            QueryInfo.prototype.stop = function () {
                this.cancel();
                delete this.cancel;
                this.variables = this.networkStatus = this.networkError = this.graphQLErrors = void 0;
                var oq = this.observableQuery;
                if (oq) oq.stopPolling();
            };
            QueryInfo.prototype.cancel = function () {};
            QueryInfo.prototype.updateWatch = function (variables) {
                var _this = this;
                if (!this.lastWatch || this.lastWatch.query !== this.document || !equality.equal(variables, this.lastWatch.variables)) {
                    this.cancel();
                    this.cancel = this.cache.watch(this.lastWatch = {
                        query: this.document,
                        variables: variables,
                        optimistic: true,
                        callback: function (diff) {
                            return _this.setDiff(diff);
                        }
                    });
                }
                return this;
            };
            QueryInfo.prototype.markResult = function (result, options, allowCacheWrite) {
                var _this = this;
                if (options.fetchPolicy === 'no-cache') {
                    this.diff = { result: result.data, complete: true };
                } else if (allowCacheWrite) {
                    var ignoreErrors = options.errorPolicy === 'ignore' || options.errorPolicy === 'all';
                    var writeWithErrors = !graphQLResultHasError(result);
                    if (!writeWithErrors && ignoreErrors && result.data) {
                        writeWithErrors = true;
                    }
                    if (writeWithErrors) {
                        this.cache.performTransaction(function (cache) {
                            cache.writeQuery({
                                query: _this.document,
                                data: result.data,
                                variables: options.variables
                            });
                            var diff = cache.diff({
                                query: _this.document,
                                variables: options.variables,
                                returnPartialData: true,
                                optimistic: true
                            });
                            _this.diff = diff;
                            if (diff.complete) {
                                result.data = diff.result;
                            }
                        });
                    }
                }
                this.graphQLErrors = isNonEmptyArray(result.errors) ? result.errors : [];
            };
            QueryInfo.prototype.markReady = function () {
                this.networkError = null;
                return this.networkStatus = NetworkStatus.ready;
            };
            QueryInfo.prototype.markError = function (error) {
                this.networkStatus = NetworkStatus.error;
                if (error.graphQLErrors) {
                    this.graphQLErrors = error.graphQLErrors;
                }
                if (error.networkError) {
                    this.networkError = error.networkError;
                }
                return error;
            };
            return QueryInfo;
        }();

        var hasOwnProperty$1 = Object.prototype.hasOwnProperty;
        var QueryManager = function () {
            function QueryManager(_a) {
                var cache = _a.cache,
                    link = _a.link,
                    _b = _a.queryDeduplication,
                    queryDeduplication = _b === void 0 ? false : _b,
                    _c = _a.onBroadcast,
                    onBroadcast = _c === void 0 ? function () {
                    return undefined;
                } : _c,
                    _d = _a.ssrMode,
                    ssrMode = _d === void 0 ? false : _d,
                    _e = _a.clientAwareness,
                    clientAwareness = _e === void 0 ? {} : _e,
                    localState = _a.localState,
                    assumeImmutableResults = _a.assumeImmutableResults;
                this.mutationStore = new MutationStore();
                this.clientAwareness = {};
                this.queries = new Map();
                this.fetchCancelFns = new Map();
                this.transformCache = new (canUseWeakMap ? WeakMap : Map)();
                this.queryIdCounter = 1;
                this.requestIdCounter = 1;
                this.mutationIdCounter = 1;
                this.inFlightLinkObservables = new Map();
                this.cache = cache;
                this.link = link;
                this.queryDeduplication = queryDeduplication;
                this.onBroadcast = onBroadcast;
                this.clientAwareness = clientAwareness;
                this.localState = localState || new LocalState({ cache: cache });
                this.ssrMode = ssrMode;
                this.assumeImmutableResults = !!assumeImmutableResults;
            }
            QueryManager.prototype.stop = function () {
                var _this = this;
                this.queries.forEach(function (_info, queryId) {
                    _this.stopQueryNoBroadcast(queryId);
                });
                this.cancelPendingFetches(new invariant.InvariantError(15));
            };
            QueryManager.prototype.cancelPendingFetches = function (error) {
                this.fetchCancelFns.forEach(function (cancel) {
                    return cancel(error);
                });
                this.fetchCancelFns.clear();
            };
            QueryManager.prototype.mutate = function (_a) {
                var mutation = _a.mutation,
                    variables = _a.variables,
                    optimisticResponse = _a.optimisticResponse,
                    updateQueriesByName = _a.updateQueries,
                    _b = _a.refetchQueries,
                    refetchQueries = _b === void 0 ? [] : _b,
                    _c = _a.awaitRefetchQueries,
                    awaitRefetchQueries = _c === void 0 ? false : _c,
                    updateWithProxyFn = _a.update,
                    _d = _a.errorPolicy,
                    errorPolicy = _d === void 0 ? 'none' : _d,
                    fetchPolicy = _a.fetchPolicy,
                    _e = _a.context,
                    context = _e === void 0 ? {} : _e;
                return tslib.__awaiter(this, void 0, void 0, function () {
                    var mutationId, generateUpdateQueriesInfo, optimistic_1, self;
                    var _this = this;
                    return tslib.__generator(this, function (_f) {
                        switch (_f.label) {
                            case 0:
                                invariant.invariant(mutation, 16);
                                invariant.invariant(!fetchPolicy || fetchPolicy === 'no-cache', 17);
                                mutationId = this.generateMutationId();
                                mutation = this.transform(mutation).document;
                                variables = this.getVariables(mutation, variables);
                                if (!this.transform(mutation).hasClientExports) return [3, 2];
                                return [4, this.localState.addExportedVariables(mutation, variables, context)];
                            case 1:
                                variables = _f.sent();
                                _f.label = 2;
                            case 2:
                                generateUpdateQueriesInfo = function () {
                                    var ret = {};
                                    if (updateQueriesByName) {
                                        _this.queries.forEach(function (_a, queryId) {
                                            var observableQuery = _a.observableQuery;
                                            if (observableQuery) {
                                                var queryName = observableQuery.queryName;
                                                if (queryName && hasOwnProperty$1.call(updateQueriesByName, queryName)) {
                                                    ret[queryId] = {
                                                        updater: updateQueriesByName[queryName],
                                                        queryInfo: _this.queries.get(queryId)
                                                    };
                                                }
                                            }
                                        });
                                    }
                                    return ret;
                                };
                                this.mutationStore.initMutation(mutationId, mutation, variables);
                                if (optimisticResponse) {
                                    optimistic_1 = typeof optimisticResponse === 'function' ? optimisticResponse(variables) : optimisticResponse;
                                    this.cache.recordOptimisticTransaction(function (cache) {
                                        markMutationResult({
                                            mutationId: mutationId,
                                            result: { data: optimistic_1 },
                                            document: mutation,
                                            variables: variables,
                                            queryUpdatersById: generateUpdateQueriesInfo(),
                                            update: updateWithProxyFn
                                        }, cache);
                                    }, mutationId);
                                }
                                this.broadcastQueries();
                                self = this;
                                return [2, new Promise(function (resolve, reject) {
                                    var storeResult;
                                    var error;
                                    self.getObservableFromLink(mutation, tslib.__assign(tslib.__assign({}, context), { optimisticResponse: optimisticResponse }), variables, false).subscribe({
                                        next: function (result) {
                                            if (graphQLResultHasError(result) && errorPolicy === 'none') {
                                                error = new ApolloError({
                                                    graphQLErrors: result.errors
                                                });
                                                return;
                                            }
                                            self.mutationStore.markMutationResult(mutationId);
                                            if (fetchPolicy !== 'no-cache') {
                                                try {
                                                    markMutationResult({
                                                        mutationId: mutationId,
                                                        result: result,
                                                        document: mutation,
                                                        variables: variables,
                                                        queryUpdatersById: generateUpdateQueriesInfo(),
                                                        update: updateWithProxyFn
                                                    }, self.cache);
                                                } catch (e) {
                                                    error = new ApolloError({
                                                        networkError: e
                                                    });
                                                    return;
                                                }
                                            }
                                            storeResult = result;
                                        },
                                        error: function (err) {
                                            self.mutationStore.markMutationError(mutationId, err);
                                            if (optimisticResponse) {
                                                self.cache.removeOptimistic(mutationId);
                                            }
                                            self.broadcastQueries();
                                            reject(new ApolloError({
                                                networkError: err
                                            }));
                                        },
                                        complete: function () {
                                            if (error) {
                                                self.mutationStore.markMutationError(mutationId, error);
                                            }
                                            if (optimisticResponse) {
                                                self.cache.removeOptimistic(mutationId);
                                            }
                                            self.broadcastQueries();
                                            if (error) {
                                                reject(error);
                                                return;
                                            }
                                            if (typeof refetchQueries === 'function') {
                                                refetchQueries = refetchQueries(storeResult);
                                            }
                                            var refetchQueryPromises = [];
                                            if (isNonEmptyArray(refetchQueries)) {
                                                refetchQueries.forEach(function (refetchQuery) {
                                                    if (typeof refetchQuery === 'string') {
                                                        self.queries.forEach(function (_a) {
                                                            var observableQuery = _a.observableQuery;
                                                            if (observableQuery && observableQuery.queryName === refetchQuery) {
                                                                refetchQueryPromises.push(observableQuery.refetch());
                                                            }
                                                        });
                                                    } else {
                                                        var queryOptions = {
                                                            query: refetchQuery.query,
                                                            variables: refetchQuery.variables,
                                                            fetchPolicy: 'network-only'
                                                        };
                                                        if (refetchQuery.context) {
                                                            queryOptions.context = refetchQuery.context;
                                                        }
                                                        refetchQueryPromises.push(self.query(queryOptions));
                                                    }
                                                });
                                            }
                                            Promise.all(awaitRefetchQueries ? refetchQueryPromises : []).then(function () {
                                                if (errorPolicy === 'ignore' && storeResult && graphQLResultHasError(storeResult)) {
                                                    delete storeResult.errors;
                                                }
                                                resolve(storeResult);
                                            });
                                        }
                                    });
                                })];
                        }
                    });
                });
            };
            QueryManager.prototype.fetchQuery = function (queryId, options, networkStatus) {
                return this.fetchQueryObservable(queryId, options, networkStatus).promise;
            };
            QueryManager.prototype.getQueryStore = function () {
                var store = Object.create(null);
                this.queries.forEach(function (info, queryId) {
                    store[queryId] = {
                        variables: info.variables,
                        networkStatus: info.networkStatus,
                        networkError: info.networkError,
                        graphQLErrors: info.graphQLErrors
                    };
                });
                return store;
            };
            QueryManager.prototype.getQueryStoreValue = function (queryId) {
                return queryId ? this.queries.get(queryId) : undefined;
            };
            QueryManager.prototype.transform = function (document) {
                var transformCache = this.transformCache;
                if (!transformCache.has(document)) {
                    var transformed = this.cache.transformDocument(document);
                    var forLink = removeConnectionDirectiveFromDocument(this.cache.transformForLink(transformed));
                    var clientQuery = this.localState.clientQuery(transformed);
                    var serverQuery = forLink && this.localState.serverQuery(forLink);
                    var cacheEntry_1 = {
                        document: transformed,
                        hasClientExports: hasClientExports(transformed),
                        hasForcedResolvers: this.localState.shouldForceResolvers(transformed),
                        clientQuery: clientQuery,
                        serverQuery: serverQuery,
                        defaultVars: getDefaultValues(getOperationDefinition(transformed))
                    };
                    var add = function (doc) {
                        if (doc && !transformCache.has(doc)) {
                            transformCache.set(doc, cacheEntry_1);
                        }
                    };
                    add(document);
                    add(transformed);
                    add(clientQuery);
                    add(serverQuery);
                }
                return transformCache.get(document);
            };
            QueryManager.prototype.getVariables = function (document, variables) {
                return tslib.__assign(tslib.__assign({}, this.transform(document).defaultVars), variables);
            };
            QueryManager.prototype.watchQuery = function (options) {
                options = tslib.__assign(tslib.__assign({}, options), { variables: this.getVariables(options.query, options.variables) });
                if (typeof options.notifyOnNetworkStatusChange === 'undefined') {
                    options.notifyOnNetworkStatusChange = false;
                }
                var observable = new ObservableQuery({
                    queryManager: this,
                    options: options
                });
                this.getQuery(observable.queryId).init({
                    document: options.query,
                    observableQuery: observable,
                    variables: options.variables
                });
                return observable;
            };
            QueryManager.prototype.query = function (options) {
                var _this = this;
                invariant.invariant(options.query, 18);
                invariant.invariant(options.query.kind === 'Document', 19);
                invariant.invariant(!options.returnPartialData, 20);
                invariant.invariant(!options.pollInterval, 21);
                var queryId = this.generateQueryId();
                return this.fetchQuery(queryId, options).finally(function () {
                    return _this.stopQuery(queryId);
                });
            };
            QueryManager.prototype.generateQueryId = function () {
                return String(this.queryIdCounter++);
            };
            QueryManager.prototype.generateRequestId = function () {
                return this.requestIdCounter++;
            };
            QueryManager.prototype.generateMutationId = function () {
                return String(this.mutationIdCounter++);
            };
            QueryManager.prototype.stopQueryInStore = function (queryId) {
                this.stopQueryInStoreNoBroadcast(queryId);
                this.broadcastQueries();
            };
            QueryManager.prototype.stopQueryInStoreNoBroadcast = function (queryId) {
                var queryInfo = this.queries.get(queryId);
                if (queryInfo) queryInfo.stop();
            };
            QueryManager.prototype.addQueryListener = function (queryId, listener) {
                this.getQuery(queryId).listeners.add(listener);
            };
            QueryManager.prototype.clearStore = function () {
                this.cancelPendingFetches(new invariant.InvariantError(22));
                this.queries.forEach(function (queryInfo) {
                    if (queryInfo.observableQuery) {
                        queryInfo.networkStatus = NetworkStatus.loading;
                    } else {
                        queryInfo.stop();
                    }
                });
                this.mutationStore.reset();
                return this.cache.reset();
            };
            QueryManager.prototype.resetStore = function () {
                var _this = this;
                return this.clearStore().then(function () {
                    return _this.reFetchObservableQueries();
                });
            };
            QueryManager.prototype.reFetchObservableQueries = function (includeStandby) {
                var _this = this;
                if (includeStandby === void 0) {
                    includeStandby = false;
                }
                var observableQueryPromises = [];
                this.queries.forEach(function (_a, queryId) {
                    var observableQuery = _a.observableQuery;
                    if (observableQuery) {
                        var fetchPolicy = observableQuery.options.fetchPolicy;
                        observableQuery.resetLastResults();
                        if (fetchPolicy !== 'cache-only' && (includeStandby || fetchPolicy !== 'standby')) {
                            observableQueryPromises.push(observableQuery.refetch());
                        }
                        _this.getQuery(queryId).setDiff(null);
                    }
                });
                this.broadcastQueries();
                return Promise.all(observableQueryPromises);
            };
            QueryManager.prototype.setObservableQuery = function (observableQuery) {
                this.getQuery(observableQuery.queryId).setObservableQuery(observableQuery);
            };
            QueryManager.prototype.startGraphQLSubscription = function (_a) {
                var _this = this;
                var query = _a.query,
                    fetchPolicy = _a.fetchPolicy,
                    variables = _a.variables;
                query = this.transform(query).document;
                variables = this.getVariables(query, variables);
                var makeObservable = function (variables) {
                    return _this.getObservableFromLink(query, {}, variables, false).map(function (result) {
                        if (!fetchPolicy || fetchPolicy !== 'no-cache') {
                            if (!graphQLResultHasError(result)) {
                                _this.cache.write({
                                    query: query,
                                    result: result.data,
                                    dataId: 'ROOT_SUBSCRIPTION',
                                    variables: variables
                                });
                            }
                            _this.broadcastQueries();
                        }
                        if (graphQLResultHasError(result)) {
                            throw new ApolloError({
                                graphQLErrors: result.errors
                            });
                        }
                        return result;
                    });
                };
                if (this.transform(query).hasClientExports) {
                    var observablePromise_1 = this.localState.addExportedVariables(query, variables).then(makeObservable);
                    return new Observable(function (observer) {
                        var sub = null;
                        observablePromise_1.then(function (observable) {
                            return sub = observable.subscribe(observer);
                        }, observer.error);
                        return function () {
                            return sub && sub.unsubscribe();
                        };
                    });
                }
                return makeObservable(variables);
            };
            QueryManager.prototype.stopQuery = function (queryId) {
                this.stopQueryNoBroadcast(queryId);
                this.broadcastQueries();
            };
            QueryManager.prototype.stopQueryNoBroadcast = function (queryId) {
                this.stopQueryInStoreNoBroadcast(queryId);
                this.removeQuery(queryId);
            };
            QueryManager.prototype.removeQuery = function (queryId) {
                this.fetchCancelFns.delete(queryId);
                this.getQuery(queryId).subscriptions.forEach(function (x) {
                    return x.unsubscribe();
                });
                this.queries.delete(queryId);
            };
            QueryManager.prototype.broadcastQueries = function () {
                this.onBroadcast();
                this.queries.forEach(function (info) {
                    return info.notify();
                });
            };
            QueryManager.prototype.getLocalState = function () {
                return this.localState;
            };
            QueryManager.prototype.getObservableFromLink = function (query, context, variables, deduplication) {
                var _this = this;
                if (deduplication === void 0) {
                    deduplication = this.queryDeduplication;
                }
                var observable;
                var serverQuery = this.transform(query).serverQuery;
                if (serverQuery) {
                    var _a = this,
                        inFlightLinkObservables_1 = _a.inFlightLinkObservables,
                        link = _a.link;
                    var operation = {
                        query: serverQuery,
                        variables: variables,
                        operationName: getOperationName(serverQuery) || void 0,
                        context: this.prepareContext(tslib.__assign(tslib.__assign({}, context), { forceFetch: !deduplication }))
                    };
                    context = operation.context;
                    if (deduplication) {
                        var byVariables_1 = inFlightLinkObservables_1.get(serverQuery) || new Map();
                        inFlightLinkObservables_1.set(serverQuery, byVariables_1);
                        var varJson_1 = JSON.stringify(variables);
                        observable = byVariables_1.get(varJson_1);
                        if (!observable) {
                            var concast = new Concast([execute(link, operation)]);
                            byVariables_1.set(varJson_1, observable = concast);
                            concast.cleanup(function () {
                                if (byVariables_1.delete(varJson_1) && byVariables_1.size < 1) {
                                    inFlightLinkObservables_1.delete(serverQuery);
                                }
                            });
                        }
                    } else {
                        observable = new Concast([execute(link, operation)]);
                    }
                } else {
                    observable = new Concast([Observable.of({ data: {} })]);
                    context = this.prepareContext(context);
                }
                var clientQuery = this.transform(query).clientQuery;
                if (clientQuery) {
                    observable = asyncMap(observable, function (result) {
                        return _this.localState.runResolvers({
                            document: clientQuery,
                            remoteResult: result,
                            context: context,
                            variables: variables
                        });
                    });
                }
                return observable;
            };
            QueryManager.prototype.getResultsFromLink = function (queryInfo, allowCacheWrite, options) {
                var lastRequestId = queryInfo.lastRequestId;
                return asyncMap(this.getObservableFromLink(queryInfo.document, options.context, options.variables), function (result) {
                    var hasErrors = isNonEmptyArray(result.errors);
                    if (lastRequestId >= queryInfo.lastRequestId) {
                        if (hasErrors && options.errorPolicy === "none") {
                            throw queryInfo.markError(new ApolloError({
                                graphQLErrors: result.errors
                            }));
                        }
                        queryInfo.markResult(result, options, allowCacheWrite);
                        queryInfo.markReady();
                    }
                    var aqr = {
                        data: result.data,
                        loading: false,
                        networkStatus: queryInfo.networkStatus || NetworkStatus.ready
                    };
                    if (hasErrors && options.errorPolicy !== "ignore") {
                        aqr.errors = result.errors;
                    }
                    return aqr;
                }, function (networkError) {
                    var error = isApolloError(networkError) ? networkError : new ApolloError({ networkError: networkError });
                    if (lastRequestId >= queryInfo.lastRequestId) {
                        queryInfo.markError(error);
                    }
                    throw error;
                });
            };
            QueryManager.prototype.fetchQueryObservable = function (queryId, options, networkStatus) {
                var _this = this;
                if (networkStatus === void 0) {
                    networkStatus = NetworkStatus.loading;
                }
                var query = this.transform(options.query).document;
                var variables = this.getVariables(query, options.variables);
                var queryInfo = this.getQuery(queryId);
                var oldNetworkStatus = queryInfo.networkStatus;
                var _a = options.fetchPolicy,
                    fetchPolicy = _a === void 0 ? "cache-first" : _a,
                    _b = options.errorPolicy,
                    errorPolicy = _b === void 0 ? "none" : _b,
                    _c = options.returnPartialData,
                    returnPartialData = _c === void 0 ? false : _c,
                    _d = options.notifyOnNetworkStatusChange,
                    notifyOnNetworkStatusChange = _d === void 0 ? false : _d,
                    _e = options.context,
                    context = _e === void 0 ? {} : _e;
                var mightUseNetwork = fetchPolicy === "cache-first" || fetchPolicy === "cache-and-network" || fetchPolicy === "network-only" || fetchPolicy === "no-cache";
                if (mightUseNetwork && notifyOnNetworkStatusChange && typeof oldNetworkStatus === "number" && oldNetworkStatus !== networkStatus && isNetworkRequestInFlight(networkStatus)) {
                    if (fetchPolicy !== "cache-first") {
                        fetchPolicy = "cache-and-network";
                    }
                    returnPartialData = true;
                }
                var normalized = Object.assign({}, options, {
                    query: query,
                    variables: variables,
                    fetchPolicy: fetchPolicy,
                    errorPolicy: errorPolicy,
                    returnPartialData: returnPartialData,
                    notifyOnNetworkStatusChange: notifyOnNetworkStatusChange,
                    context: context
                });
                var fromVariables = function (variables) {
                    normalized.variables = variables;
                    return _this.fetchQueryByPolicy(queryInfo, normalized, networkStatus);
                };
                this.fetchCancelFns.set(queryId, function (reason) {
                    Promise.resolve().then(function () {
                        return concast.cancel(reason);
                    });
                });
                var concast = new Concast(this.transform(normalized.query).hasClientExports ? this.localState.addExportedVariables(normalized.query, normalized.variables, normalized.context).then(fromVariables) : fromVariables(normalized.variables));
                concast.cleanup(function () {
                    return _this.fetchCancelFns.delete(queryId);
                });
                return concast;
            };
            QueryManager.prototype.fetchQueryByPolicy = function (queryInfo, options, networkStatus) {
                var _this = this;
                var query = options.query,
                    variables = options.variables,
                    fetchPolicy = options.fetchPolicy,
                    errorPolicy = options.errorPolicy,
                    returnPartialData = options.returnPartialData,
                    context = options.context;
                queryInfo.init({
                    document: query,
                    variables: variables,
                    lastRequestId: this.generateRequestId(),
                    networkStatus: networkStatus
                }).updateWatch(variables);
                var readCache = function () {
                    return _this.cache.diff({
                        query: query,
                        variables: variables,
                        returnPartialData: true,
                        optimistic: true
                    });
                };
                var resultsFromCache = function (diff, networkStatus) {
                    if (networkStatus === void 0) {
                        networkStatus = queryInfo.networkStatus || NetworkStatus.loading;
                    }
                    var data = diff.result;

                    var fromData = function (data) {
                        return Observable.of({
                            data: data,
                            loading: isNetworkRequestInFlight(networkStatus),
                            networkStatus: networkStatus
                        });
                    };
                    if (_this.transform(query).hasForcedResolvers) {
                        return _this.localState.runResolvers({
                            document: query,
                            remoteResult: { data: data },
                            context: context,
                            variables: variables,
                            onlyRunForcedResolvers: true
                        }).then(function (resolved) {
                            return fromData(resolved.data);
                        });
                    }
                    return fromData(data);
                };
                var resultsFromLink = function (allowCacheWrite) {
                    return _this.getResultsFromLink(queryInfo, allowCacheWrite, {
                        variables: variables,
                        context: context,
                        fetchPolicy: fetchPolicy,
                        errorPolicy: errorPolicy
                    });
                };
                switch (fetchPolicy) {
                    default:
                    case "cache-first":
                        {
                            var diff = readCache();
                            if (diff.complete) {
                                return [resultsFromCache(diff, queryInfo.markReady())];
                            }
                            if (returnPartialData) {
                                return [resultsFromCache(diff), resultsFromLink(true)];
                            }
                            return [resultsFromLink(true)];
                        }
                    case "cache-and-network":
                        {
                            var diff = readCache();
                            if (diff.complete || returnPartialData) {
                                return [resultsFromCache(diff), resultsFromLink(true)];
                            }
                            return [resultsFromLink(true)];
                        }
                    case "cache-only":
                        return [resultsFromCache(readCache(), queryInfo.markReady())];
                    case "network-only":
                        return [resultsFromLink(true)];
                    case "no-cache":
                        return [resultsFromLink(false)];
                    case "standby":
                        return [];
                }
            };
            QueryManager.prototype.getQuery = function (queryId) {
                if (queryId && !this.queries.has(queryId)) {
                    this.queries.set(queryId, new QueryInfo(this.cache));
                }
                return this.queries.get(queryId);
            };
            QueryManager.prototype.prepareContext = function (context) {
                if (context === void 0) {
                    context = {};
                }
                var newContext = this.localState.prepareContext(context);
                return tslib.__assign(tslib.__assign({}, newContext), { clientAwareness: this.clientAwareness });
            };
            QueryManager.prototype.checkInFlight = function (queryId) {
                var query = this.getQueryStoreValue(queryId);
                return !!query && !!query.networkStatus && query.networkStatus !== NetworkStatus.ready && query.networkStatus !== NetworkStatus.error;
            };
            return QueryManager;
        }();
        function markMutationResult(mutation, cache) {
            if (!graphQLResultHasError(mutation.result)) {
                var cacheWrites_1 = [{
                    result: mutation.result.data,
                    dataId: 'ROOT_MUTATION',
                    query: mutation.document,
                    variables: mutation.variables
                }];
                var queryUpdatersById_1 = mutation.queryUpdatersById;
                if (queryUpdatersById_1) {
                    Object.keys(queryUpdatersById_1).forEach(function (id) {
                        var _a = queryUpdatersById_1[id],
                            updater = _a.updater,
                            _b = _a.queryInfo,
                            document = _b.document,
                            variables = _b.variables;
                        var _c = cache.diff({
                            query: document,
                            variables: variables,
                            returnPartialData: true,
                            optimistic: false
                        }),
                            currentQueryResult = _c.result,
                            complete = _c.complete;
                        if (complete && currentQueryResult) {
                            var nextQueryResult = tryFunctionOrLogError(function () {
                                return updater(currentQueryResult, {
                                    mutationResult: mutation.result,
                                    queryName: getOperationName(document) || undefined,
                                    queryVariables: variables
                                });
                            });
                            if (nextQueryResult) {
                                cacheWrites_1.push({
                                    result: nextQueryResult,
                                    dataId: 'ROOT_QUERY',
                                    query: document,
                                    variables: variables
                                });
                            }
                        }
                    });
                }
                cache.performTransaction(function (c) {
                    cacheWrites_1.forEach(function (write) {
                        return c.write(write);
                    });
                    var update = mutation.update;
                    if (update) {
                        tryFunctionOrLogError(function () {
                            return update(c, mutation.result);
                        });
                    }
                });
            }
        }

        var version = 'local';

        var serializeFetchParameter = function (p, label) {
            var serialized;
            try {
                serialized = JSON.stringify(p);
            } catch (e) {
                var parseError = new invariant.InvariantError(12);
                parseError.parseError = e;
                throw parseError;
            }
            return serialized;
        };

        var selectURI = function (operation, fallbackURI) {
            var context = operation.getContext();
            var contextURI = context.uri;
            if (contextURI) {
                return contextURI;
            } else if (typeof fallbackURI === 'function') {
                return fallbackURI(operation);
            } else {
                return fallbackURI || '/graphql';
            }
        };

        var throwServerError = function (response, result, message) {
            var error = new Error(message);
            error.name = 'ServerError';
            error.response = response;
            error.statusCode = response.status;
            error.result = result;
            throw error;
        };

        var hasOwnProperty$2 = Object.prototype.hasOwnProperty;
        function parseAndCheckHttpResponse(operations) {
            return function (response) {
                return response.text().then(function (bodyText) {
                    try {
                        return JSON.parse(bodyText);
                    } catch (err) {
                        var parseError = err;
                        parseError.name = 'ServerParseError';
                        parseError.response = response;
                        parseError.statusCode = response.status;
                        parseError.bodyText = bodyText;
                        throw parseError;
                    }
                }).then(function (result) {
                    if (response.status >= 300) {
                        throwServerError(response, result, "Response not successful: Received status code " + response.status);
                    }
                    if (!Array.isArray(result) && !hasOwnProperty$2.call(result, 'data') && !hasOwnProperty$2.call(result, 'errors')) {
                        throwServerError(response, result, "Server response was missing for query '" + (Array.isArray(operations) ? operations.map(function (op) {
                            return op.operationName;
                        }) : operations.operationName) + "'.");
                    }
                    return result;
                });
            };
        }

        var checkFetcher = function (fetcher) {
            if (!fetcher && typeof fetch === 'undefined') {
                throw new invariant.InvariantError(13);
            }
        };

        var defaultHttpOptions = {
            includeQuery: true,
            includeExtensions: false
        };
        var defaultHeaders = {
            accept: '*/*',
            'content-type': 'application/json'
        };
        var defaultOptions = {
            method: 'POST'
        };
        var fallbackHttpConfig = {
            http: defaultHttpOptions,
            headers: defaultHeaders,
            options: defaultOptions
        };
        var selectHttpOptionsAndBody = function (operation, fallbackConfig) {
            var configs = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                configs[_i - 2] = arguments[_i];
            }
            var options = tslib.__assign(tslib.__assign({}, fallbackConfig.options), { headers: fallbackConfig.headers, credentials: fallbackConfig.credentials });
            var http = fallbackConfig.http || {};
            configs.forEach(function (config) {
                options = tslib.__assign(tslib.__assign(tslib.__assign({}, options), config.options), { headers: tslib.__assign(tslib.__assign({}, options.headers), config.headers) });
                if (config.credentials) options.credentials = config.credentials;
                http = tslib.__assign(tslib.__assign({}, http), config.http);
            });
            var operationName = operation.operationName,
                extensions = operation.extensions,
                variables = operation.variables,
                query = operation.query;
            var body = { operationName: operationName, variables: variables };
            if (http.includeExtensions) body.extensions = extensions;
            if (http.includeQuery) body.query = printer.print(query);
            return {
                options: options,
                body: body
            };
        };

        var createSignalIfSupported = function () {
            if (typeof AbortController === 'undefined') return { controller: false, signal: false };
            var controller = new AbortController();
            var signal = controller.signal;
            return { controller: controller, signal: signal };
        };

        function rewriteURIForGET(chosenURI, body) {
            var queryParams = [];
            var addQueryParam = function (key, value) {
                queryParams.push(key + "=" + encodeURIComponent(value));
            };
            if ('query' in body) {
                addQueryParam('query', body.query);
            }
            if (body.operationName) {
                addQueryParam('operationName', body.operationName);
            }
            if (body.variables) {
                var serializedVariables = void 0;
                try {
                    serializedVariables = serializeFetchParameter(body.variables, 'Variables map');
                } catch (parseError) {
                    return { parseError: parseError };
                }
                addQueryParam('variables', serializedVariables);
            }
            if (body.extensions) {
                var serializedExtensions = void 0;
                try {
                    serializedExtensions = serializeFetchParameter(body.extensions, 'Extensions map');
                } catch (parseError) {
                    return { parseError: parseError };
                }
                addQueryParam('extensions', serializedExtensions);
            }
            var fragment = '',
                preFragment = chosenURI;
            var fragmentStart = chosenURI.indexOf('#');
            if (fragmentStart !== -1) {
                fragment = chosenURI.substr(fragmentStart);
                preFragment = chosenURI.substr(0, fragmentStart);
            }
            var queryParamsPrefix = preFragment.indexOf('?') === -1 ? '?' : '&';
            var newURI = preFragment + queryParamsPrefix + queryParams.join('&') + fragment;
            return { newURI: newURI };
        }

        function fromError(errorValue) {
            return new Observable(function (observer) {
                observer.error(errorValue);
            });
        }

        var createHttpLink = function (linkOptions) {
            if (linkOptions === void 0) {
                linkOptions = {};
            }
            var _a = linkOptions.uri,
                uri = _a === void 0 ? '/graphql' : _a,
                fetcher = linkOptions.fetch,
                includeExtensions = linkOptions.includeExtensions,
                useGETForQueries = linkOptions.useGETForQueries,
                requestOptions = tslib.__rest(linkOptions, ["uri", "fetch", "includeExtensions", "useGETForQueries"]);
            checkFetcher(fetcher);
            if (!fetcher) {
                fetcher = fetch;
            }
            var linkConfig = {
                http: { includeExtensions: includeExtensions },
                options: requestOptions.fetchOptions,
                credentials: requestOptions.credentials,
                headers: requestOptions.headers
            };
            return new ApolloLink(function (operation) {
                var chosenURI = selectURI(operation, uri);
                var context = operation.getContext();
                var clientAwarenessHeaders = {};
                if (context.clientAwareness) {
                    var _a = context.clientAwareness,
                        name_1 = _a.name,
                        version = _a.version;
                    if (name_1) {
                        clientAwarenessHeaders['apollographql-client-name'] = name_1;
                    }
                    if (version) {
                        clientAwarenessHeaders['apollographql-client-version'] = version;
                    }
                }
                var contextHeaders = tslib.__assign(tslib.__assign({}, clientAwarenessHeaders), context.headers);
                var contextConfig = {
                    http: context.http,
                    options: context.fetchOptions,
                    credentials: context.credentials,
                    headers: contextHeaders
                };
                var _b = selectHttpOptionsAndBody(operation, fallbackHttpConfig, linkConfig, contextConfig),
                    options = _b.options,
                    body = _b.body;
                var controller;
                if (!options.signal) {
                    var _c = createSignalIfSupported(),
                        _controller = _c.controller,
                        signal = _c.signal;
                    controller = _controller;
                    if (controller) options.signal = signal;
                }

                if (useGETForQueries && !operation.query.definitions.some(function (d) {
                    return d.kind === 'OperationDefinition' && d.operation === 'mutation';
                })) {
                    options.method = 'GET';
                }
                if (options.method === 'GET') {
                    var _d = rewriteURIForGET(chosenURI, body),
                        newURI = _d.newURI,
                        parseError = _d.parseError;
                    if (parseError) {
                        return fromError(parseError);
                    }
                    chosenURI = newURI;
                } else {
                    try {
                        options.body = serializeFetchParameter(body, 'Payload');
                    } catch (parseError) {
                        return fromError(parseError);
                    }
                }
                return new Observable(function (observer) {
                    fetcher(chosenURI, options).then(function (response) {
                        operation.setContext({ response: response });
                        return response;
                    }).then(parseAndCheckHttpResponse(operation)).then(function (result) {
                        observer.next(result);
                        observer.complete();
                        return result;
                    }).catch(function (err) {
                        if (err.name === 'AbortError') return;
                        if (err.result && err.result.errors && err.result.data) {
                            observer.next(err.result);
                        }
                        observer.error(err);
                    });
                    return function () {
                        if (controller) controller.abort();
                    };
                });
            });
        };

        var HttpLink = function (_super) {
            tslib.__extends(HttpLink, _super);
            function HttpLink(options) {
                if (options === void 0) {
                    options = {};
                }
                var _this = _super.call(this, createHttpLink(options).request) || this;
                _this.options = options;
                return _this;
            }
            return HttpLink;
        }(ApolloLink);

        var hasSuggestedDevtools = false;
        var ApolloClient = function () {
            function ApolloClient(options) {
                var _this = this;
                this.defaultOptions = {};
                this.resetStoreCallbacks = [];
                this.clearStoreCallbacks = [];
                var uri = options.uri,
                    credentials = options.credentials,
                    headers = options.headers,
                    cache = options.cache,
                    _a = options.ssrMode,
                    ssrMode = _a === void 0 ? false : _a,
                    _b = options.ssrForceFetchDelay,
                    ssrForceFetchDelay = _b === void 0 ? 0 : _b,
                    connectToDevTools = options.connectToDevTools,
                    _c = options.queryDeduplication,
                    queryDeduplication = _c === void 0 ? true : _c,
                    defaultOptions = options.defaultOptions,
                    _d = options.assumeImmutableResults,
                    assumeImmutableResults = _d === void 0 ? false : _d,
                    resolvers = options.resolvers,
                    typeDefs = options.typeDefs,
                    fragmentMatcher = options.fragmentMatcher,
                    clientAwarenessName = options.name,
                    clientAwarenessVersion = options.version;
                var link = options.link;
                if (!link) {
                    link = uri ? new HttpLink({ uri: uri, credentials: credentials, headers: headers }) : ApolloLink.empty();
                }
                if (!cache) {
                    throw new invariant.InvariantError(1);
                }
                this.link = link;
                this.cache = cache;
                this.disableNetworkFetches = ssrMode || ssrForceFetchDelay > 0;
                this.queryDeduplication = queryDeduplication;
                this.defaultOptions = defaultOptions || {};
                this.typeDefs = typeDefs;
                if (ssrForceFetchDelay) {
                    setTimeout(function () {
                        return _this.disableNetworkFetches = false;
                    }, ssrForceFetchDelay);
                }
                this.watchQuery = this.watchQuery.bind(this);
                this.query = this.query.bind(this);
                this.mutate = this.mutate.bind(this);
                this.resetStore = this.resetStore.bind(this);
                this.reFetchObservableQueries = this.reFetchObservableQueries.bind(this);
                var defaultConnectToDevTools = false && typeof window !== 'undefined' && !window.__APOLLO_CLIENT__;
                if (typeof connectToDevTools === 'undefined' ? defaultConnectToDevTools : connectToDevTools && typeof window !== 'undefined') {
                    window.__APOLLO_CLIENT__ = this;
                }

                this.version = version;
                this.localState = new LocalState({
                    cache: cache,
                    client: this,
                    resolvers: resolvers,
                    fragmentMatcher: fragmentMatcher
                });
                this.queryManager = new QueryManager({
                    cache: this.cache,
                    link: this.link,
                    queryDeduplication: queryDeduplication,
                    ssrMode: ssrMode,
                    clientAwareness: {
                        name: clientAwarenessName,
                        version: clientAwarenessVersion
                    },
                    localState: this.localState,
                    assumeImmutableResults: assumeImmutableResults,
                    onBroadcast: function () {
                        if (_this.devToolsHookCb) {
                            _this.devToolsHookCb({
                                action: {},
                                state: {
                                    queries: _this.queryManager.getQueryStore(),
                                    mutations: _this.queryManager.mutationStore.getStore()
                                },
                                dataWithOptimisticResults: _this.cache.extract(true)
                            });
                        }
                    }
                });
            }
            ApolloClient.prototype.stop = function () {
                this.queryManager.stop();
            };
            ApolloClient.prototype.watchQuery = function (options) {
                if (this.defaultOptions.watchQuery) {
                    options = tslib.__assign(tslib.__assign({}, this.defaultOptions.watchQuery), options);
                }
                if (this.disableNetworkFetches && (options.fetchPolicy === 'network-only' || options.fetchPolicy === 'cache-and-network')) {
                    options = tslib.__assign(tslib.__assign({}, options), { fetchPolicy: 'cache-first' });
                }
                return this.queryManager.watchQuery(options);
            };
            ApolloClient.prototype.query = function (options) {
                if (this.defaultOptions.query) {
                    options = tslib.__assign(tslib.__assign({}, this.defaultOptions.query), options);
                }
                invariant.invariant(options.fetchPolicy !== 'cache-and-network', 2);
                if (this.disableNetworkFetches && options.fetchPolicy === 'network-only') {
                    options = tslib.__assign(tslib.__assign({}, options), { fetchPolicy: 'cache-first' });
                }
                return this.queryManager.query(options);
            };
            ApolloClient.prototype.mutate = function (options) {
                if (this.defaultOptions.mutate) {
                    options = tslib.__assign(tslib.__assign({}, this.defaultOptions.mutate), options);
                }
                return this.queryManager.mutate(options);
            };
            ApolloClient.prototype.subscribe = function (options) {
                return this.queryManager.startGraphQLSubscription(options);
            };
            ApolloClient.prototype.readQuery = function (options, optimistic) {
                if (optimistic === void 0) {
                    optimistic = false;
                }
                return this.cache.readQuery(options, optimistic);
            };
            ApolloClient.prototype.readFragment = function (options, optimistic) {
                if (optimistic === void 0) {
                    optimistic = false;
                }
                return this.cache.readFragment(options, optimistic);
            };
            ApolloClient.prototype.writeQuery = function (options) {
                var result = this.cache.writeQuery(options);
                this.queryManager.broadcastQueries();
                return result;
            };
            ApolloClient.prototype.writeFragment = function (options) {
                var result = this.cache.writeFragment(options);
                this.queryManager.broadcastQueries();
                return result;
            };
            ApolloClient.prototype.__actionHookForDevTools = function (cb) {
                this.devToolsHookCb = cb;
            };
            ApolloClient.prototype.__requestRaw = function (payload) {
                return execute(this.link, payload);
            };
            ApolloClient.prototype.resetStore = function () {
                var _this = this;
                return Promise.resolve().then(function () {
                    return _this.queryManager.clearStore();
                }).then(function () {
                    return Promise.all(_this.resetStoreCallbacks.map(function (fn) {
                        return fn();
                    }));
                }).then(function () {
                    return _this.reFetchObservableQueries();
                });
            };
            ApolloClient.prototype.clearStore = function () {
                var _this = this;
                return Promise.resolve().then(function () {
                    return _this.queryManager.clearStore();
                }).then(function () {
                    return Promise.all(_this.clearStoreCallbacks.map(function (fn) {
                        return fn();
                    }));
                });
            };
            ApolloClient.prototype.onResetStore = function (cb) {
                var _this = this;
                this.resetStoreCallbacks.push(cb);
                return function () {
                    _this.resetStoreCallbacks = _this.resetStoreCallbacks.filter(function (c) {
                        return c !== cb;
                    });
                };
            };
            ApolloClient.prototype.onClearStore = function (cb) {
                var _this = this;
                this.clearStoreCallbacks.push(cb);
                return function () {
                    _this.clearStoreCallbacks = _this.clearStoreCallbacks.filter(function (c) {
                        return c !== cb;
                    });
                };
            };
            ApolloClient.prototype.reFetchObservableQueries = function (includeStandby) {
                return this.queryManager.reFetchObservableQueries(includeStandby);
            };
            ApolloClient.prototype.extract = function (optimistic) {
                return this.cache.extract(optimistic);
            };
            ApolloClient.prototype.restore = function (serializedState) {
                return this.cache.restore(serializedState);
            };
            ApolloClient.prototype.addResolvers = function (resolvers) {
                this.localState.addResolvers(resolvers);
            };
            ApolloClient.prototype.setResolvers = function (resolvers) {
                this.localState.setResolvers(resolvers);
            };
            ApolloClient.prototype.getResolvers = function () {
                return this.localState.getResolvers();
            };
            ApolloClient.prototype.setLocalStateFragmentMatcher = function (fragmentMatcher) {
                this.localState.setFragmentMatcher(fragmentMatcher);
            };
            return ApolloClient;
        }();

        var ApolloCache = function () {
            function ApolloCache() {
                this.getFragmentDoc = optimism.wrap(getFragmentQueryDocument);
            }
            ApolloCache.prototype.transformDocument = function (document) {
                return document;
            };
            ApolloCache.prototype.identify = function (object) {};
            ApolloCache.prototype.gc = function () {
                return [];
            };
            ApolloCache.prototype.transformForLink = function (document) {
                return document;
            };
            ApolloCache.prototype.readQuery = function (options, optimistic) {
                if (optimistic === void 0) {
                    optimistic = false;
                }
                return this.read({
                    rootId: options.id || 'ROOT_QUERY',
                    query: options.query,
                    variables: options.variables,
                    optimistic: optimistic
                });
            };
            ApolloCache.prototype.readFragment = function (options, optimistic) {
                if (optimistic === void 0) {
                    optimistic = false;
                }
                return this.read({
                    query: this.getFragmentDoc(options.fragment, options.fragmentName),
                    variables: options.variables,
                    rootId: options.id,
                    optimistic: optimistic
                });
            };
            ApolloCache.prototype.writeQuery = function (options) {
                this.write({
                    dataId: options.id || 'ROOT_QUERY',
                    result: options.data,
                    query: options.query,
                    variables: options.variables,
                    broadcast: options.broadcast
                });
            };
            ApolloCache.prototype.writeFragment = function (options) {
                this.write({
                    dataId: options.id,
                    result: options.data,
                    variables: options.variables,
                    query: this.getFragmentDoc(options.fragment, options.fragmentName),
                    broadcast: options.broadcast
                });
            };
            return ApolloCache;
        }();

        var hasOwn = Object.prototype.hasOwnProperty;
        function getTypenameFromStoreObject(store, objectOrReference) {
            return isReference(objectOrReference) ? store.get(objectOrReference.__ref, "__typename") : objectOrReference && objectOrReference.__typename;
        }
        var FieldNamePattern = /^[_A-Za-z0-9]+/;
        function fieldNameFromStoreName(storeFieldName) {
            var match = storeFieldName.match(FieldNamePattern);
            return match ? match[0] : storeFieldName;
        }
        function storeValueIsStoreObject(value) {
            return value !== null && typeof value === "object" && !isReference(value) && !Array.isArray(value);
        }
        function isFieldValueToBeMerged(value) {
            var field = value && value.__field;
            return field && isField(field);
        }
        function makeProcessedFieldsMerger() {
            return new DeepMerger(reconcileProcessedFields);
        }
        var reconcileProcessedFields = function (existingObject, incomingObject, property) {
            var existing = existingObject[property];
            var incoming = incomingObject[property];
            if (isFieldValueToBeMerged(existing)) {
                existing.__value = this.merge(existing.__value, isFieldValueToBeMerged(incoming) ? incoming.__value : incoming);
                return existing;
            }
            if (isFieldValueToBeMerged(incoming)) {
                incoming.__value = this.merge(existing, incoming.__value);
                return incoming;
            }
            return this.merge(existing, incoming);
        };

        var hasOwn$1 = Object.prototype.hasOwnProperty;
        function argsFromFieldSpecifier(spec) {
            return spec.args !== void 0 ? spec.args : spec.field ? argumentsObjectFromField(spec.field, spec.variables) : null;
        }
        var defaultDataIdFromObject = function (_a, context) {
            var __typename = _a.__typename,
                id = _a.id,
                _id = _a._id;
            if (typeof __typename === "string") {
                if (context) {
                    context.keyObject = id !== void 0 ? { id: id } : _id !== void 0 ? { _id: _id } : void 0;
                }
                var idValue = id || _id;
                if (idValue !== void 0) {
                    return __typename + ":" + (typeof idValue === "number" || typeof idValue === "string" ? idValue : JSON.stringify(idValue));
                }
            }
        };
        var nullKeyFieldsFn = function () {
            return void 0;
        };
        var simpleKeyArgsFn = function (_args, context) {
            return context.fieldName;
        };
        var Policies = function () {
            function Policies(config) {
                if (config === void 0) {
                    config = {};
                }
                this.config = config;
                this.typePolicies = Object.create(null);
                this.rootIdsByTypename = Object.create(null);
                this.rootTypenamesById = Object.create(null);
                this.usingPossibleTypes = false;
                this.storageTrie = new optimism.KeyTrie(true);
                this.config = tslib.__assign({ dataIdFromObject: defaultDataIdFromObject }, config);
                this.setRootTypename("Query");
                this.setRootTypename("Mutation");
                this.setRootTypename("Subscription");
                if (config.possibleTypes) {
                    this.addPossibleTypes(config.possibleTypes);
                }
                if (config.typePolicies) {
                    this.addTypePolicies(config.typePolicies);
                }
            }
            Policies.prototype.identify = function (object, selectionSet, fragmentMap) {
                var typename = selectionSet && fragmentMap ? getTypenameFromResult(object, selectionSet, fragmentMap) : object.__typename;
                var context = {
                    typename: typename,
                    selectionSet: selectionSet,
                    fragmentMap: fragmentMap
                };
                var id;
                var policy = this.getTypePolicy(typename, false);
                var keyFn = policy && policy.keyFn || this.config.dataIdFromObject;
                while (keyFn) {
                    var specifierOrId = keyFn(object, context);
                    if (Array.isArray(specifierOrId)) {
                        keyFn = keyFieldsFnFromSpecifier(specifierOrId);
                    } else {
                        id = specifierOrId;
                        break;
                    }
                }
                id = id && String(id);
                return context.keyObject ? [id, context.keyObject] : [id];
            };
            Policies.prototype.addTypePolicies = function (typePolicies) {
                var _this = this;
                Object.keys(typePolicies).forEach(function (typename) {
                    var existing = _this.getTypePolicy(typename, true);
                    var incoming = typePolicies[typename];
                    var keyFields = incoming.keyFields,
                        fields = incoming.fields;
                    if (incoming.queryType) _this.setRootTypename("Query", typename);
                    if (incoming.mutationType) _this.setRootTypename("Mutation", typename);
                    if (incoming.subscriptionType) _this.setRootTypename("Subscription", typename);
                    existing.keyFn = keyFields === false ? nullKeyFieldsFn : Array.isArray(keyFields) ? keyFieldsFnFromSpecifier(keyFields) : typeof keyFields === "function" ? keyFields : existing.keyFn;
                    if (fields) {
                        Object.keys(fields).forEach(function (fieldName) {
                            var existing = _this.getFieldPolicy(typename, fieldName, true);
                            var incoming = fields[fieldName];
                            if (typeof incoming === "function") {
                                existing.read = incoming;
                            } else {
                                var keyArgs = incoming.keyArgs,
                                    read = incoming.read,
                                    merge = incoming.merge;
                                existing.keyFn = keyArgs === false ? simpleKeyArgsFn : Array.isArray(keyArgs) ? keyArgsFnFromSpecifier(keyArgs) : typeof keyArgs === "function" ? keyArgs : existing.keyFn;
                                if (typeof read === "function") existing.read = read;
                                if (typeof merge === "function") existing.merge = merge;
                            }
                            if (existing.read && existing.merge) {
                                existing.keyFn = existing.keyFn || simpleKeyArgsFn;
                            }
                        });
                    }
                });
            };
            Policies.prototype.setRootTypename = function (which, typename) {
                if (typename === void 0) {
                    typename = which;
                }
                var rootId = "ROOT_" + which.toUpperCase();
                var old = this.rootTypenamesById[rootId];
                if (typename !== old) {
                    invariant.invariant(!old || old === which, 34);
                    this.rootIdsByTypename[typename] = rootId;
                    this.rootTypenamesById[rootId] = typename;
                }
            };
            Policies.prototype.addPossibleTypes = function (possibleTypes) {
                var _this = this;
                this.usingPossibleTypes = true;
                Object.keys(possibleTypes).forEach(function (supertype) {
                    var subtypeSet = _this.getSubtypeSet(supertype, true);
                    possibleTypes[supertype].forEach(subtypeSet.add, subtypeSet);
                });
            };
            Policies.prototype.getTypePolicy = function (typename, createIfMissing) {
                if (typename) {
                    return this.typePolicies[typename] || createIfMissing && (this.typePolicies[typename] = Object.create(null));
                }
            };
            Policies.prototype.getSubtypeSet = function (supertype, createIfMissing) {
                var policy = this.getTypePolicy(supertype, createIfMissing);
                if (policy) {
                    return policy.subtypes || (createIfMissing ? policy.subtypes = new Set() : void 0);
                }
            };
            Policies.prototype.getFieldPolicy = function (typename, fieldName, createIfMissing) {
                var typePolicy = this.getTypePolicy(typename, createIfMissing);
                if (typePolicy) {
                    var fieldPolicies = typePolicy.fields || createIfMissing && (typePolicy.fields = Object.create(null));
                    if (fieldPolicies) {
                        return fieldPolicies[fieldName] || createIfMissing && (fieldPolicies[fieldName] = Object.create(null));
                    }
                }
            };
            Policies.prototype.fragmentMatches = function (fragment, typename) {
                var _this = this;
                if (!fragment.typeCondition) return true;
                if (!typename) return false;
                var supertype = fragment.typeCondition.name.value;
                if (typename === supertype) return true;
                if (this.usingPossibleTypes) {
                    var workQueue_1 = [this.getSubtypeSet(supertype, false)];
                    for (var i = 0; i < workQueue_1.length; ++i) {
                        var subtypes = workQueue_1[i];
                        if (subtypes) {
                            if (subtypes.has(typename)) return true;
                            subtypes.forEach(function (subtype) {
                                var subsubtypes = _this.getSubtypeSet(subtype, false);
                                if (subsubtypes && workQueue_1.indexOf(subsubtypes) < 0) {
                                    workQueue_1.push(subsubtypes);
                                }
                            });
                        }
                    }
                }
                return false;
            };
            Policies.prototype.getStoreFieldName = function (fieldSpec) {
                var typename = fieldSpec.typename,
                    fieldName = fieldSpec.fieldName;
                var policy = this.getFieldPolicy(typename, fieldName, false);
                var storeFieldName;
                var keyFn = policy && policy.keyFn;
                if (keyFn && typename) {
                    var context = {
                        typename: typename,
                        fieldName: fieldName,
                        field: fieldSpec.field || null
                    };
                    var args = argsFromFieldSpecifier(fieldSpec);
                    while (keyFn) {
                        var specifierOrString = keyFn(args, context);
                        if (Array.isArray(specifierOrString)) {
                            keyFn = keyArgsFnFromSpecifier(specifierOrString);
                        } else {
                            storeFieldName = specifierOrString || fieldName;
                            break;
                        }
                    }
                }
                if (storeFieldName === void 0) {
                    storeFieldName = fieldSpec.field ? storeKeyNameFromField(fieldSpec.field, fieldSpec.variables) : getStoreKeyName(fieldName, argsFromFieldSpecifier(fieldSpec));
                }
                return fieldName === fieldNameFromStoreName(storeFieldName) ? storeFieldName : fieldName + ":" + storeFieldName;
            };
            Policies.prototype.readField = function (options, context) {
                var objectOrReference = options.from;
                if (!objectOrReference) return;
                var nameOrField = options.field || options.fieldName;
                if (!nameOrField) return;
                if (options.typename === void 0) {
                    var typename = context.getFieldValue(objectOrReference, "__typename");
                    if (typename) options.typename = typename;
                }
                var storeFieldName = this.getStoreFieldName(options);
                var fieldName = fieldNameFromStoreName(storeFieldName);
                var existing = context.getFieldValue(objectOrReference, storeFieldName);
                var policy = this.getFieldPolicy(options.typename, fieldName, false);
                var read = policy && policy.read;
                if (read) {
                    var storage = this.storageTrie.lookup(isReference(objectOrReference) ? objectOrReference.__ref : objectOrReference, storeFieldName);
                    return read(existing, makeFieldFunctionOptions(this, objectOrReference, options, storage, context));
                }
                return existing;
            };
            Policies.prototype.hasMergeFunction = function (typename, fieldName) {
                var policy = this.getFieldPolicy(typename, fieldName, false);
                return !!(policy && policy.merge);
            };
            Policies.prototype.applyMerges = function (existing, incoming, context, storageKeys) {
                var _this = this;
                if (isFieldValueToBeMerged(incoming)) {
                    var field = incoming.__field;
                    var fieldName = field.name.value;
                    var merge = this.getFieldPolicy(incoming.__typename, fieldName, false).merge;
                    var storage = storageKeys ? this.storageTrie.lookupArray(storageKeys) : null;
                    incoming = merge(existing, incoming.__value, makeFieldFunctionOptions(this, void 0, { typename: incoming.__typename, fieldName: fieldName,
                        field: field, variables: context.variables }, storage, context));
                }
                if (Array.isArray(incoming)) {
                    return incoming.map(function (item) {
                        return _this.applyMerges(void 0, item, context);
                    });
                }
                if (storeValueIsStoreObject(incoming)) {
                    var e_1 = existing;
                    var i_1 = incoming;
                    var firstStorageKey_1 = isReference(e_1) ? e_1.__ref : typeof e_1 === "object" && e_1;
                    var newFields_1;
                    Object.keys(i_1).forEach(function (storeFieldName) {
                        var incomingValue = i_1[storeFieldName];
                        var appliedValue = _this.applyMerges(context.getFieldValue(e_1, storeFieldName), incomingValue, context, firstStorageKey_1 ? [firstStorageKey_1, storeFieldName] : void 0);
                        if (appliedValue !== incomingValue) {
                            newFields_1 = newFields_1 || Object.create(null);
                            newFields_1[storeFieldName] = appliedValue;
                        }
                    });
                    if (newFields_1) {
                        return tslib.__assign(tslib.__assign({}, i_1), newFields_1);
                    }
                }
                return incoming;
            };
            return Policies;
        }();
        function makeFieldFunctionOptions(policies, objectOrReference, fieldSpec, storage, context) {
            var toReference = context.toReference,
                getFieldValue = context.getFieldValue,
                variables = context.variables;
            var storeFieldName = policies.getStoreFieldName(fieldSpec);
            var fieldName = fieldNameFromStoreName(storeFieldName);
            return {
                args: argsFromFieldSpecifier(fieldSpec),
                field: fieldSpec.field || null,
                fieldName: fieldName,
                storeFieldName: storeFieldName,
                variables: variables,
                isReference: isReference,
                toReference: toReference,
                storage: storage,
                readField: function (fieldNameOrOptions, from) {
                    var options = typeof fieldNameOrOptions === "string" ? {
                        fieldName: fieldNameOrOptions,
                        from: from
                    } : fieldNameOrOptions;
                    return policies.readField(options.from ? options : tslib.__assign(tslib.__assign({}, options), { from: objectOrReference }), context);
                },
                mergeObjects: function (existing, incoming) {
                    if (Array.isArray(existing) || Array.isArray(incoming)) {
                        throw new invariant.InvariantError(35);
                    }
                    if (existing && typeof existing === "object" && incoming && typeof incoming === "object") {
                        var eType = getFieldValue(existing, "__typename");
                        var iType = getFieldValue(incoming, "__typename");
                        var typesDiffer = eType && iType && eType !== iType;
                        var applied = policies.applyMerges(typesDiffer ? void 0 : existing, incoming, context);
                        if (typesDiffer || !storeValueIsStoreObject(existing) || !storeValueIsStoreObject(applied)) {
                            return applied;
                        }
                        return tslib.__assign(tslib.__assign({}, existing), applied);
                    }
                    return incoming;
                }
            };
        }
        function keyArgsFnFromSpecifier(specifier) {
            return function (args, context) {
                return args ? context.fieldName + ":" + JSON.stringify(computeKeyObject(args, specifier)) : context.fieldName;
            };
        }
        function keyFieldsFnFromSpecifier(specifier) {
            var trie = new optimism.KeyTrie(canUseWeakMap);
            return function (object, context) {
                var aliasMap;
                if (context.selectionSet && context.fragmentMap) {
                    var info = trie.lookupArray([context.selectionSet, context.fragmentMap]);
                    aliasMap = info.aliasMap || (info.aliasMap = makeAliasMap(context.selectionSet, context.fragmentMap));
                }
                var keyObject = context.keyObject = computeKeyObject(object, specifier, aliasMap);
                return context.typename + ":" + JSON.stringify(keyObject);
            };
        }
        function makeAliasMap(selectionSet, fragmentMap) {
            var map = Object.create(null);
            var workQueue = new Set([selectionSet]);
            workQueue.forEach(function (selectionSet) {
                selectionSet.selections.forEach(function (selection) {
                    if (isField(selection)) {
                        if (selection.alias) {
                            var responseKey = selection.alias.value;
                            var storeKey = selection.name.value;
                            if (storeKey !== responseKey) {
                                var aliases = map.aliases || (map.aliases = Object.create(null));
                                aliases[storeKey] = responseKey;
                            }
                        }
                        if (selection.selectionSet) {
                            var subsets = map.subsets || (map.subsets = Object.create(null));
                            subsets[selection.name.value] = makeAliasMap(selection.selectionSet, fragmentMap);
                        }
                    } else {
                        var fragment = getFragmentFromSelection(selection, fragmentMap);
                        if (fragment) {
                            workQueue.add(fragment.selectionSet);
                        }
                    }
                });
            });
            return map;
        }
        function computeKeyObject(response, specifier, aliasMap) {
            var keyObj = Object.create(null);
            var prevKey;
            specifier.forEach(function (s) {
                if (Array.isArray(s)) {
                    if (typeof prevKey === "string") {
                        var subsets = aliasMap && aliasMap.subsets;
                        var subset = subsets && subsets[prevKey];
                        keyObj[prevKey] = computeKeyObject(response[prevKey], s, subset);
                    }
                } else {
                    var aliases = aliasMap && aliasMap.aliases;
                    var responseName = aliases && aliases[s] || s;
                    invariant.invariant(hasOwn$1.call(response, responseName), 36);
                    keyObj[prevKey = s] = response[responseName];
                }
            });
            return keyObj;
        }

        function getEnv() {
            if (typeof process !== 'undefined' && 'production') {
                return 'production';
            }
            return 'development';
        }
        function isEnv(env) {
            return getEnv() === env;
        }
        function isDevelopment() {
            return isEnv('development') === true;
        }
        function isTest() {
            return isEnv('test') === true;
        }

        function isObject$1(value) {
            return value !== null && typeof value === "object";
        }
        function deepFreeze(value) {
            var workSet = new Set([value]);
            workSet.forEach(function (obj) {
                if (isObject$1(obj)) {
                    if (!Object.isFrozen(obj)) Object.freeze(obj);
                    Object.getOwnPropertyNames(obj).forEach(function (name) {
                        if (isObject$1(obj[name])) workSet.add(obj[name]);
                    });
                }
            });
            return value;
        }
        function maybeDeepFreeze(obj) {
            return obj;
        }

        var EntityStore = function () {
            function EntityStore(policies, group) {
                var _this = this;
                this.policies = policies;
                this.group = group;
                this.data = Object.create(null);
                this.rootIds = Object.create(null);
                this.refs = Object.create(null);
                this.getFieldValue = function (objectOrReference, storeFieldName) {
                    return maybeDeepFreeze(isReference(objectOrReference) ? _this.get(objectOrReference.__ref, storeFieldName) : objectOrReference && objectOrReference[storeFieldName]);
                };
                this.toReference = function (object, mergeIntoStore) {
                    var id = _this.policies.identify(object)[0];
                    var ref = id && makeReference(id);
                    if (ref && mergeIntoStore) {
                        _this.merge(id, object);
                    }
                    return ref;
                };
            }
            EntityStore.prototype.toObject = function () {
                return tslib.__assign({}, this.data);
            };
            EntityStore.prototype.has = function (dataId) {
                return this.lookup(dataId, true) !== void 0;
            };
            EntityStore.prototype.get = function (dataId, fieldName) {
                this.group.depend(dataId, fieldName);
                if (hasOwn.call(this.data, dataId)) {
                    var storeObject = this.data[dataId];
                    if (storeObject && hasOwn.call(storeObject, fieldName)) {
                        return storeObject[fieldName];
                    }
                }
                if (fieldName === "__typename" && hasOwn.call(this.policies.rootTypenamesById, dataId)) {
                    return this.policies.rootTypenamesById[dataId];
                }
                if (this instanceof Layer) {
                    return this.parent.get(dataId, fieldName);
                }
            };
            EntityStore.prototype.lookup = function (dataId, dependOnExistence) {
                if (dependOnExistence) this.group.depend(dataId, "__exists");
                return hasOwn.call(this.data, dataId) ? this.data[dataId] : this instanceof Layer ? this.parent.lookup(dataId, dependOnExistence) : void 0;
            };
            EntityStore.prototype.merge = function (dataId, incoming) {
                var _this = this;
                var existing = this.lookup(dataId);
                var merged = new DeepMerger(storeObjectReconciler).merge(existing, incoming);
                this.data[dataId] = merged;
                if (merged !== existing) {
                    delete this.refs[dataId];
                    var fieldsToDirty_1 = Object.create(null);
                    if (!existing) fieldsToDirty_1.__exists = 1;
                    Object.keys(incoming).forEach(function (storeFieldName) {
                        if (!existing || existing[storeFieldName] !== merged[storeFieldName]) {
                            fieldsToDirty_1[fieldNameFromStoreName(storeFieldName)] = 1;
                            if (merged[storeFieldName] === void 0 && !(_this instanceof Layer)) {
                                delete merged[storeFieldName];
                            }
                        }
                    });
                    Object.keys(fieldsToDirty_1).forEach(function (fieldName) {
                        return _this.group.dirty(dataId, fieldName);
                    });
                }
                return merged;
            };
            EntityStore.prototype.delete = function (dataId, fieldName, args) {
                var storeObject = this.lookup(dataId);
                if (!storeObject) return false;
                var changedFields = Object.create(null);
                if (fieldName && args) {
                    var storeFieldName = this.policies.getStoreFieldName({
                        typename: this.getFieldValue(storeObject, "__typename"),
                        fieldName: fieldName,
                        args: args
                    });
                    if (storeObject[storeFieldName] !== void 0) {
                        changedFields[storeFieldName] = void 0;
                    }
                } else {
                    Object.keys(storeObject).forEach(function (storeFieldName) {
                        if (storeObject[storeFieldName] !== void 0 && (!fieldName || fieldName === fieldNameFromStoreName(storeFieldName))) {
                            changedFields[storeFieldName] = void 0;
                        }
                    });
                }
                if (Object.keys(changedFields).length) {
                    var merged_1 = this.merge(dataId, changedFields);
                    if (Object.keys(merged_1).every(function (key) {
                        return merged_1[key] === void 0;
                    })) {
                        if (this instanceof Layer) {
                            this.data[dataId] = void 0;
                        } else {
                            delete this.data[dataId];
                        }
                        this.group.dirty(dataId, "__exists");
                    }
                    return true;
                }
                return false;
            };
            EntityStore.prototype.evict = function (options) {
                var evicted = false;
                if (hasOwn.call(this.data, options.id)) {
                    evicted = this.delete(options.id, options.fieldName, options.args);
                }
                if (this instanceof Layer) {
                    evicted = this.parent.evict(options) || evicted;
                }
                this.group.dirty(options.id, options.fieldName || "__exists");
                return evicted;
            };
            EntityStore.prototype.clear = function () {
                this.replace(null);
            };
            EntityStore.prototype.replace = function (newData) {
                var _this = this;
                Object.keys(this.data).forEach(function (dataId) {
                    if (!(newData && hasOwn.call(newData, dataId))) {
                        _this.delete(dataId);
                    }
                });
                if (newData) {
                    Object.keys(newData).forEach(function (dataId) {
                        _this.merge(dataId, newData[dataId]);
                    });
                }
            };
            EntityStore.prototype.retain = function (rootId) {
                return this.rootIds[rootId] = (this.rootIds[rootId] || 0) + 1;
            };
            EntityStore.prototype.release = function (rootId) {
                if (this.rootIds[rootId] > 0) {
                    var count = --this.rootIds[rootId];
                    if (!count) delete this.rootIds[rootId];
                    return count;
                }
                return 0;
            };
            EntityStore.prototype.getRootIdSet = function (ids) {
                if (ids === void 0) {
                    ids = new Set();
                }
                Object.keys(this.rootIds).forEach(ids.add, ids);
                if (this instanceof Layer) {
                    this.parent.getRootIdSet(ids);
                }
                return ids;
            };
            EntityStore.prototype.gc = function () {
                var _this = this;
                var ids = this.getRootIdSet();
                var snapshot = this.toObject();
                ids.forEach(function (id) {
                    if (hasOwn.call(snapshot, id)) {
                        Object.keys(_this.findChildRefIds(id)).forEach(ids.add, ids);
                        delete snapshot[id];
                    }
                });
                var idsToRemove = Object.keys(snapshot);
                if (idsToRemove.length) {
                    var root_1 = this;
                    while (root_1 instanceof Layer) root_1 = root_1.parent;
                    idsToRemove.forEach(function (id) {
                        return root_1.delete(id);
                    });
                }
                return idsToRemove;
            };
            EntityStore.prototype.findChildRefIds = function (dataId) {
                if (!hasOwn.call(this.refs, dataId)) {
                    var found_1 = this.refs[dataId] = Object.create(null);
                    var workSet_1 = new Set([this.data[dataId]]);
                    var canTraverse_1 = function (obj) {
                        return obj !== null && typeof obj === 'object';
                    };
                    workSet_1.forEach(function (obj) {
                        if (isReference(obj)) {
                            found_1[obj.__ref] = true;
                        } else if (canTraverse_1(obj)) {
                            Object.values(obj).filter(canTraverse_1).forEach(workSet_1.add, workSet_1);
                        }
                    });
                }
                return this.refs[dataId];
            };
            EntityStore.prototype.makeCacheKey = function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                return this.group.keyMaker.lookupArray(args);
            };
            return EntityStore;
        }();
        var CacheGroup = function () {
            function CacheGroup(caching) {
                this.caching = caching;
                this.d = null;
                this.keyMaker = new optimism.KeyTrie(canUseWeakMap);
                this.d = caching ? optimism.dep() : null;
            }
            CacheGroup.prototype.depend = function (dataId, storeFieldName) {
                if (this.d) {
                    this.d(makeDepKey(dataId, storeFieldName));
                }
            };
            CacheGroup.prototype.dirty = function (dataId, storeFieldName) {
                if (this.d) {
                    this.d.dirty(makeDepKey(dataId, storeFieldName));
                }
            };
            return CacheGroup;
        }();
        function makeDepKey(dataId, storeFieldName) {
            return fieldNameFromStoreName(storeFieldName) + '#' + dataId;
        }
        (function (EntityStore) {
            var Root = function (_super) {
                tslib.__extends(Root, _super);
                function Root(_a) {
                    var policies = _a.policies,
                        _b = _a.resultCaching,
                        resultCaching = _b === void 0 ? true : _b,
                        seed = _a.seed;
                    var _this = _super.call(this, policies, new CacheGroup(resultCaching)) || this;
                    _this.sharedLayerGroup = new CacheGroup(resultCaching);
                    if (seed) _this.replace(seed);
                    return _this;
                }
                Root.prototype.addLayer = function (layerId, replay) {
                    return new Layer(layerId, this, replay, this.sharedLayerGroup);
                };
                Root.prototype.removeLayer = function (layerId) {
                    return this;
                };
                return Root;
            }(EntityStore);
            EntityStore.Root = Root;
        })(EntityStore || (EntityStore = {}));
        var Layer = function (_super) {
            tslib.__extends(Layer, _super);
            function Layer(id, parent, replay, group) {
                var _this = _super.call(this, parent.policies, group) || this;
                _this.id = id;
                _this.parent = parent;
                _this.replay = replay;
                _this.group = group;
                replay(_this);
                return _this;
            }
            Layer.prototype.addLayer = function (layerId, replay) {
                return new Layer(layerId, this, replay, this.group);
            };
            Layer.prototype.removeLayer = function (layerId) {
                var _this = this;
                var parent = this.parent.removeLayer(layerId);
                if (layerId === this.id) {
                    if (this.group.caching) {
                        Object.keys(this.data).forEach(function (dataId) {
                            if (_this.data[dataId] !== parent.lookup(dataId)) {
                                _this.delete(dataId);
                            }
                        });
                    }
                    return parent;
                }
                if (parent === this.parent) return this;
                return parent.addLayer(this.id, this.replay);
            };
            Layer.prototype.toObject = function () {
                return tslib.__assign(tslib.__assign({}, this.parent.toObject()), this.data);
            };
            Layer.prototype.findChildRefIds = function (dataId) {
                var fromParent = this.parent.findChildRefIds(dataId);
                return hasOwn.call(this.data, dataId) ? tslib.__assign(tslib.__assign({}, fromParent), _super.prototype.findChildRefIds.call(this, dataId)) : fromParent;
            };
            return Layer;
        }(EntityStore);
        function storeObjectReconciler(existingObject, incomingObject, property) {
            var existingValue = existingObject[property];
            var incomingValue = incomingObject[property];
            return equality.equal(existingValue, incomingValue) ? existingValue : incomingValue;
        }
        function supportsResultCaching(store) {
            return !!(store instanceof EntityStore && store.group.caching);
        }

        var MissingFieldError = function () {
            return function MissingFieldError(message, path, query, variables) {
                this.message = message;
                this.path = path;
                this.query = query;
                this.variables = variables;
            };
        }();

        function missingFromInvariant(err, context) {
            return new MissingFieldError(err.message, context.path.slice(), context.query, context.variables);
        }
        var StoreReader = function () {
            function StoreReader(config) {
                var _this = this;
                this.config = config;
                this.executeSelectionSet = optimism.wrap(function (options) {
                    return _this.execSelectionSetImpl(options);
                }, {
                    keyArgs: function (options) {
                        return [options.context.store, options.selectionSet, options.objectOrReference, options.context.varString];
                    },
                    makeCacheKey: function (store, selectionSet, parent, varString) {
                        if (supportsResultCaching(store)) {
                            return store.makeCacheKey(selectionSet, isReference(parent) ? parent.__ref : parent, varString);
                        }
                    }
                });
                this.knownResults = new WeakMap();
                this.executeSubSelectedArray = optimism.wrap(function (options) {
                    return _this.execSubSelectedArrayImpl(options);
                }, {
                    makeCacheKey: function (_a) {
                        var field = _a.field,
                            array = _a.array,
                            context = _a.context;
                        if (supportsResultCaching(context.store)) {
                            return context.store.makeCacheKey(field, array, context.varString);
                        }
                    }
                });
                this.config = tslib.__assign({ addTypename: true }, config);
            }
            StoreReader.prototype.readQueryFromStore = function (options) {
                return this.diffQueryAgainstStore(tslib.__assign(tslib.__assign({}, options), { returnPartialData: false })).result;
            };
            StoreReader.prototype.diffQueryAgainstStore = function (_a) {
                var store = _a.store,
                    query = _a.query,
                    _b = _a.rootId,
                    rootId = _b === void 0 ? 'ROOT_QUERY' : _b,
                    variables = _a.variables,
                    _c = _a.returnPartialData,
                    returnPartialData = _c === void 0 ? true : _c;
                var policies = this.config.policies;
                variables = tslib.__assign(tslib.__assign({}, getDefaultValues(getQueryDefinition(query))), variables);
                var execResult = this.executeSelectionSet({
                    selectionSet: getMainDefinition(query).selectionSet,
                    objectOrReference: makeReference(rootId),
                    context: {
                        store: store,
                        query: query,
                        policies: policies,
                        variables: variables,
                        varString: JSON.stringify(variables),
                        fragmentMap: createFragmentMap(getFragmentDefinitions(query)),
                        toReference: store.toReference,
                        getFieldValue: store.getFieldValue,
                        path: []
                    }
                });
                var hasMissingFields = execResult.missing && execResult.missing.length > 0;
                if (hasMissingFields && !returnPartialData) {
                    throw execResult.missing[0];
                }
                return {
                    result: execResult.result,
                    missing: execResult.missing,
                    complete: !hasMissingFields
                };
            };
            StoreReader.prototype.isFresh = function (result, store, parent, selectionSet, varString) {
                if (supportsResultCaching(store) && this.knownResults.get(result) === selectionSet) {
                    var latest = this.executeSelectionSet.peek(store, selectionSet, parent, varString);
                    if (latest && result === latest.result) {
                        return true;
                    }
                }
                return false;
            };
            StoreReader.prototype.execSelectionSetImpl = function (_a) {
                var _this = this;
                var selectionSet = _a.selectionSet,
                    objectOrReference = _a.objectOrReference,
                    context = _a.context;
                if (isReference(objectOrReference) && !context.policies.rootTypenamesById[objectOrReference.__ref] && !context.store.has(objectOrReference.__ref)) {
                    return {
                        result: {},
                        missing: [missingFromInvariant(new invariant.InvariantError(46), context)]
                    };
                }
                var fragmentMap = context.fragmentMap,
                    variables = context.variables,
                    policies = context.policies,
                    store = context.store;
                var objectsToMerge = [];
                var finalResult = { result: null };
                var typename = store.getFieldValue(objectOrReference, "__typename");
                if (this.config.addTypename && typeof typename === "string" && !policies.rootIdsByTypename[typename]) {
                    objectsToMerge.push({ __typename: typename });
                }
                function getMissing() {
                    return finalResult.missing || (finalResult.missing = []);
                }
                function handleMissing(result) {
                    var _a;
                    if (result.missing) (_a = getMissing()).push.apply(_a, result.missing);
                    return result.result;
                }
                var workSet = new Set(selectionSet.selections);
                workSet.forEach(function (selection) {
                    var _a;
                    if (!shouldInclude(selection, variables)) return;
                    if (isField(selection)) {
                        var fieldValue = policies.readField({
                            fieldName: selection.name.value,
                            field: selection,
                            variables: context.variables,
                            from: objectOrReference
                        }, context);
                        var resultName = resultKeyNameFromField(selection);
                        context.path.push(resultName);
                        if (fieldValue === void 0) {
                            if (!addTypenameToDocument.added(selection)) {
                                getMissing().push(missingFromInvariant(new invariant.InvariantError(47), context));
                            }
                        } else if (Array.isArray(fieldValue)) {
                            fieldValue = handleMissing(_this.executeSubSelectedArray({
                                field: selection,
                                array: fieldValue,
                                context: context
                            }));
                        } else if (!selection.selectionSet) {} else if (fieldValue != null) {
                            fieldValue = handleMissing(_this.executeSelectionSet({
                                selectionSet: selection.selectionSet,
                                objectOrReference: fieldValue,
                                context: context
                            }));
                        }
                        if (fieldValue !== void 0) {
                            objectsToMerge.push((_a = {}, _a[resultName] = fieldValue, _a));
                        }
                        invariant.invariant(context.path.pop() === resultName);
                    } else {
                        var fragment = void 0;
                        if (isInlineFragment(selection)) {
                            fragment = selection;
                        } else {
                            invariant.invariant(fragment = fragmentMap[selection.name.value], 48);
                        }
                        if (policies.fragmentMatches(fragment, typename)) {
                            fragment.selectionSet.selections.forEach(workSet.add, workSet);
                        }
                    }
                });
                finalResult.result = mergeDeepArray(objectsToMerge);

                this.knownResults.set(finalResult.result, selectionSet);
                return finalResult;
            };
            StoreReader.prototype.execSubSelectedArrayImpl = function (_a) {
                var _this = this;
                var field = _a.field,
                    array = _a.array,
                    context = _a.context;
                var missing;
                function handleMissing(childResult, i) {
                    if (childResult.missing) {
                        missing = missing || [];
                        missing.push.apply(missing, childResult.missing);
                    }
                    invariant.invariant(context.path.pop() === i);
                    return childResult.result;
                }
                array = array.map(function (item, i) {
                    if (item === null) {
                        return null;
                    }
                    context.path.push(i);
                    if (Array.isArray(item)) {
                        return handleMissing(_this.executeSubSelectedArray({
                            field: field,
                            array: item,
                            context: context
                        }), i);
                    }
                    if (field.selectionSet) {
                        return handleMissing(_this.executeSelectionSet({
                            selectionSet: field.selectionSet,
                            objectOrReference: item,
                            context: context
                        }), i);
                    }

                    invariant.invariant(context.path.pop() === i);
                    return item;
                });

                return { result: array, missing: missing };
            };
            return StoreReader;
        }();
        function assertSelectionSetForIdValue(store, field, fieldValue) {
            if (!field.selectionSet) {
                var workSet_1 = new Set([fieldValue]);
                workSet_1.forEach(function (value) {
                    if (value && typeof value === "object") {
                        invariant.invariant(!isReference(value), 49);
                        Object.values(value).forEach(workSet_1.add, workSet_1);
                    }
                });
            }
        }

        var StoreWriter = function () {
            function StoreWriter(config) {
                this.config = config;
            }
            StoreWriter.prototype.writeQueryToStore = function (_a) {
                var query = _a.query,
                    result = _a.result,
                    _b = _a.dataId,
                    dataId = _b === void 0 ? 'ROOT_QUERY' : _b,
                    _c = _a.store,
                    store = _c === void 0 ? new EntityStore.Root({
                    policies: this.config.policies
                }) : _c,
                    variables = _a.variables;
                var operationDefinition = getOperationDefinition(query);
                store.retain(dataId);
                var merger = makeProcessedFieldsMerger();
                variables = tslib.__assign(tslib.__assign({}, getDefaultValues(operationDefinition)), variables);
                this.processSelectionSet({
                    result: result || Object.create(null),
                    dataId: dataId,
                    selectionSet: operationDefinition.selectionSet,
                    typename: this.config.policies.rootTypenamesById[dataId],
                    context: {
                        store: store,
                        written: Object.create(null),
                        merge: function (existing, incoming) {
                            return merger.merge(existing, incoming);
                        },
                        variables: variables,
                        varString: JSON.stringify(variables),
                        fragmentMap: createFragmentMap(getFragmentDefinitions(query)),
                        toReference: store.toReference,
                        getFieldValue: store.getFieldValue
                    }
                });
                return store;
            };
            StoreWriter.prototype.processSelectionSet = function (_a) {
                var _this = this;
                var dataId = _a.dataId,
                    result = _a.result,
                    selectionSet = _a.selectionSet,
                    context = _a.context,
                    typename = _a.typename,
                    _b = _a.out,
                    out = _b === void 0 ? {
                    shouldApplyMerges: false
                } : _b;
                var _c = this.config,
                    policies = _c.policies,
                    reader = _c.reader;
                var mergedFields = Object.create(null);
                var _d = policies.identify(result, selectionSet, context.fragmentMap),
                    id = _d[0],
                    keyObject = _d[1];
                dataId = dataId || id;
                if (keyObject) {
                    mergedFields = context.merge(mergedFields, keyObject);
                }
                if ("string" === typeof dataId) {
                    var sets = context.written[dataId] || (context.written[dataId] = []);
                    var ref = makeReference(dataId);
                    if (sets.indexOf(selectionSet) >= 0) return ref;
                    sets.push(selectionSet);
                    if (reader && reader.isFresh(result, context.store, ref, selectionSet, context.varString)) {
                        return ref;
                    }
                }
                typename = typename || getTypenameFromResult(result, selectionSet, context.fragmentMap) || dataId && context.store.get(dataId, "__typename");
                if ("string" === typeof typename) {
                    mergedFields.__typename = typename;
                }
                var workSet = new Set(selectionSet.selections);
                workSet.forEach(function (selection) {
                    var _a;
                    if (!shouldInclude(selection, context.variables)) return;
                    if (isField(selection)) {
                        var resultFieldKey = resultKeyNameFromField(selection);
                        var value = result[resultFieldKey];
                        if (typeof value !== 'undefined') {
                            var storeFieldName = policies.getStoreFieldName({
                                typename: typename,
                                fieldName: selection.name.value,
                                field: selection,
                                variables: context.variables
                            });
                            var incomingValue = _this.processFieldValue(value, selection, context, out);
                            if (policies.hasMergeFunction(typename, selection.name.value)) {
                                incomingValue = {
                                    __field: selection,
                                    __typename: typename,
                                    __value: incomingValue
                                };
                                out.shouldApplyMerges = true;
                            }
                            mergedFields = context.merge(mergedFields, (_a = {}, _a[storeFieldName] = incomingValue, _a));
                        } else if (policies.usingPossibleTypes && !hasDirectives(["defer", "client"], selection)) {
                            throw new invariant.InvariantError(50);
                        }
                    } else {
                        var fragment = getFragmentFromSelection(selection, context.fragmentMap);
                        if (fragment && policies.fragmentMatches(fragment, typename)) {
                            fragment.selectionSet.selections.forEach(workSet.add, workSet);
                        }
                    }
                });
                if ("string" === typeof dataId) {
                    var entityRef = makeReference(dataId);
                    if (out.shouldApplyMerges) {
                        mergedFields = policies.applyMerges(entityRef, mergedFields, context);
                    }
                    context.store.merge(dataId, mergedFields);
                    return entityRef;
                }
                return mergedFields;
            };
            StoreWriter.prototype.processFieldValue = function (value, field, context, out) {
                var _this = this;
                if (!field.selectionSet || value === null) {
                    return value;
                }
                if (Array.isArray(value)) {
                    return value.map(function (item) {
                        return _this.processFieldValue(item, field, context, out);
                    });
                }
                return this.processSelectionSet({
                    result: value,
                    selectionSet: field.selectionSet,
                    context: context,
                    out: out
                });
            };
            return StoreWriter;
        }();

        var defaultConfig = {
            dataIdFromObject: defaultDataIdFromObject,
            addTypename: true,
            resultCaching: true,
            typePolicies: {}
        };
        var InMemoryCache = function (_super) {
            tslib.__extends(InMemoryCache, _super);
            function InMemoryCache(config) {
                if (config === void 0) {
                    config = {};
                }
                var _this = _super.call(this) || this;
                _this.watches = new Set();
                _this.typenameDocumentCache = new Map();
                _this.txCount = 0;
                _this.varDep = optimism.dep();
                _this.config = tslib.__assign(tslib.__assign({}, defaultConfig), config);
                _this.addTypename = !!_this.config.addTypename;
                _this.policies = new Policies({
                    dataIdFromObject: _this.config.dataIdFromObject,
                    possibleTypes: _this.config.possibleTypes,
                    typePolicies: _this.config.typePolicies
                });
                _this.data = new EntityStore.Root({
                    policies: _this.policies,
                    resultCaching: _this.config.resultCaching
                });
                _this.optimisticData = _this.data;
                _this.storeWriter = new StoreWriter({
                    policies: _this.policies,
                    reader: _this.storeReader = new StoreReader({
                        addTypename: _this.addTypename,
                        policies: _this.policies
                    })
                });
                var cache = _this;
                var maybeBroadcastWatch = cache.maybeBroadcastWatch;
                _this.maybeBroadcastWatch = optimism.wrap(function (c) {
                    return maybeBroadcastWatch.call(_this, c);
                }, {
                    makeCacheKey: function (c) {
                        var store = c.optimistic ? cache.optimisticData : cache.data;
                        if (supportsResultCaching(store)) {
                            var optimistic = c.optimistic,
                                rootId = c.rootId,
                                variables = c.variables;
                            return store.makeCacheKey(c.query, c.callback, JSON.stringify({ optimistic: optimistic, rootId: rootId, variables: variables }));
                        }
                    }
                });
                return _this;
            }
            InMemoryCache.prototype.restore = function (data) {
                if (data) this.data.replace(data);
                return this;
            };
            InMemoryCache.prototype.extract = function (optimistic) {
                if (optimistic === void 0) {
                    optimistic = false;
                }
                return (optimistic ? this.optimisticData : this.data).toObject();
            };
            InMemoryCache.prototype.read = function (options) {
                var store = options.optimistic ? this.optimisticData : this.data;
                if (typeof options.rootId === 'string' && !store.has(options.rootId)) {
                    return null;
                }
                return this.storeReader.readQueryFromStore({
                    store: store,
                    query: options.query,
                    variables: options.variables,
                    rootId: options.rootId,
                    config: this.config
                }) || null;
            };
            InMemoryCache.prototype.write = function (options) {
                this.storeWriter.writeQueryToStore({
                    store: this.data,
                    query: options.query,
                    result: options.result,
                    dataId: options.dataId,
                    variables: options.variables
                });
                if (options.broadcast !== false) {
                    this.broadcastWatches();
                }
            };
            InMemoryCache.prototype.diff = function (options) {
                return this.storeReader.diffQueryAgainstStore({
                    store: options.optimistic ? this.optimisticData : this.data,
                    rootId: options.id || "ROOT_QUERY",
                    query: options.query,
                    variables: options.variables,
                    returnPartialData: options.returnPartialData,
                    config: this.config
                });
            };
            InMemoryCache.prototype.watch = function (watch) {
                var _this = this;
                this.watches.add(watch);
                if (watch.immediate) {
                    this.maybeBroadcastWatch(watch);
                }
                return function () {
                    _this.watches.delete(watch);
                };
            };
            InMemoryCache.prototype.gc = function () {
                return this.optimisticData.gc();
            };
            InMemoryCache.prototype.retain = function (rootId, optimistic) {
                return (optimistic ? this.optimisticData : this.data).retain(rootId);
            };
            InMemoryCache.prototype.release = function (rootId, optimistic) {
                return (optimistic ? this.optimisticData : this.data).release(rootId);
            };
            InMemoryCache.prototype.identify = function (object) {
                return this.policies.identify(object)[0];
            };
            InMemoryCache.prototype.evict = function (idOrOptions, fieldName, args) {
                var evicted = this.optimisticData.evict(typeof idOrOptions === "string" ? {
                    id: idOrOptions,
                    fieldName: fieldName,
                    args: args
                } : idOrOptions);
                if (typeof idOrOptions === "string" || idOrOptions.broadcast !== false) {
                    this.broadcastWatches();
                }
                return evicted;
            };
            InMemoryCache.prototype.reset = function () {
                this.data.clear();
                this.optimisticData = this.data;
                this.broadcastWatches();
                return Promise.resolve();
            };
            InMemoryCache.prototype.removeOptimistic = function (idToRemove) {
                var newOptimisticData = this.optimisticData.removeLayer(idToRemove);
                if (newOptimisticData !== this.optimisticData) {
                    this.optimisticData = newOptimisticData;
                    this.broadcastWatches();
                }
            };
            InMemoryCache.prototype.performTransaction = function (transaction, optimisticId) {
                var _this = this;
                var perform = function (layer) {
                    var _a = _this,
                        data = _a.data,
                        optimisticData = _a.optimisticData;
                    ++_this.txCount;
                    if (layer) {
                        _this.data = _this.optimisticData = layer;
                    }
                    try {
                        transaction(_this);
                    } finally {
                        --_this.txCount;
                        _this.data = data;
                        _this.optimisticData = optimisticData;
                    }
                };
                if (typeof optimisticId === 'string') {
                    this.optimisticData = this.optimisticData.addLayer(optimisticId, perform);
                } else {
                    perform();
                }
                this.broadcastWatches();
            };
            InMemoryCache.prototype.recordOptimisticTransaction = function (transaction, id) {
                return this.performTransaction(transaction, id);
            };
            InMemoryCache.prototype.transformDocument = function (document) {
                if (this.addTypename) {
                    var result = this.typenameDocumentCache.get(document);
                    if (!result) {
                        result = addTypenameToDocument(document);
                        this.typenameDocumentCache.set(document, result);
                        this.typenameDocumentCache.set(result, result);
                    }
                    return result;
                }
                return document;
            };
            InMemoryCache.prototype.broadcastWatches = function () {
                var _this = this;
                if (!this.txCount) {
                    this.watches.forEach(function (c) {
                        return _this.maybeBroadcastWatch(c);
                    });
                }
            };
            InMemoryCache.prototype.maybeBroadcastWatch = function (c) {
                c.callback(this.diff({
                    query: c.query,
                    variables: c.variables,
                    optimistic: c.optimistic
                }));
            };
            InMemoryCache.prototype.makeVar = function (value) {
                var cache = this;
                return function rv(newValue) {
                    if (arguments.length > 0) {
                        if (value !== newValue) {
                            value = newValue;
                            cache.varDep.dirty(rv);
                            cache.broadcastWatches();
                        }
                    } else {
                        cache.varDep(rv);
                    }
                    return value;
                };
            };
            return InMemoryCache;
        }(ApolloCache);

        var React;
        function requireReactLazily() {
            return React || (React = require('frontend-js-react-web$react'));
        }

        var contextSymbol = typeof Symbol === 'function' && Symbol.for ? Symbol.for('__APOLLO_CONTEXT__') : '__APOLLO_CONTEXT__';
        function resetApolloContext() {
            var React = requireReactLazily();
            Object.defineProperty(React, contextSymbol, {
                value: React.createContext({}),
                enumerable: false,
                configurable: true,
                writable: false
            });
        }
        function getApolloContext() {
            var React = requireReactLazily();
            if (!React[contextSymbol]) {
                resetApolloContext();
            }
            return React[contextSymbol];
        }

        var ApolloProvider = function (_a) {
            var client = _a.client,
                children = _a.children;
            var React = requireReactLazily();
            var ApolloContext = getApolloContext();
            return React.createElement(ApolloContext.Consumer, null, function (context) {
                if (context === void 0) {
                    context = {};
                }
                if (client && context.client !== client) {
                    context = Object.assign({}, context, { client: client });
                }
                invariant.invariant(context.client, 5);
                return React.createElement(ApolloContext.Provider, { value: context }, children);
            });
        };

        function requestToKey(request, addTypename) {
            var queryString = request.query && printer.print(addTypename ? addTypenameToDocument(request.query) : request.query);

            return JSON.stringify({ query: queryString });
        }
        var MockLink = function (_super) {
            tslib.__extends(MockLink, _super);
            function MockLink(mockedResponses, addTypename) {
                if (addTypename === void 0) {
                    addTypename = true;
                }
                var _this = _super.call(this) || this;
                _this.addTypename = true;
                _this.mockedResponsesByKey = {};
                _this.addTypename = addTypename;
                if (mockedResponses) {
                    mockedResponses.forEach(function (mockedResponse) {
                        _this.addMockedResponse(mockedResponse);
                    });
                }
                return _this;
            }
            MockLink.prototype.addMockedResponse = function (mockedResponse) {
                var normalizedMockedResponse = this.normalizeMockedResponse(mockedResponse);
                var key = requestToKey(normalizedMockedResponse.request, this.addTypename);
                var mockedResponses = this.mockedResponsesByKey[key];
                if (!mockedResponses) {
                    mockedResponses = [];
                    this.mockedResponsesByKey[key] = mockedResponses;
                }
                mockedResponses.push(normalizedMockedResponse);
            };
            MockLink.prototype.request = function (operation) {
                this.operation = operation;
                var key = requestToKey(operation, this.addTypename);
                var responseIndex = 0;
                var response = (this.mockedResponsesByKey[key] || []).find(function (res, index) {
                    var requestVariables = operation.variables || {};
                    var mockedResponseVariables = res.request.variables || {};
                    if (equality.equal(requestVariables, mockedResponseVariables)) {
                        responseIndex = index;
                        return true;
                    }
                    return false;
                });
                if (!response || typeof responseIndex === 'undefined') {
                    this.onError(new Error("No more mocked responses for the query: " + printer.print(operation.query) + ", variables: " + JSON.stringify(operation.variables)));
                    return null;
                }
                this.mockedResponsesByKey[key].splice(responseIndex, 1);
                var newData = response.newData;
                if (newData) {
                    response.result = newData();
                    this.mockedResponsesByKey[key].push(response);
                }
                var _a = response,
                    result = _a.result,
                    error = _a.error,
                    delay = _a.delay;
                if (!result && !error) {
                    this.onError(new Error("Mocked response should contain either result or error: " + key));
                }
                return new Observable(function (observer) {
                    var timer = setTimeout(function () {
                        if (error) {
                            observer.error(error);
                        } else {
                            if (result) {
                                observer.next(typeof result === 'function' ? result() : result);
                            }
                            observer.complete();
                        }
                    }, delay ? delay : 0);
                    return function () {
                        clearTimeout(timer);
                    };
                });
            };
            MockLink.prototype.normalizeMockedResponse = function (mockedResponse) {
                var newMockedResponse = cloneDeep(mockedResponse);
                var queryWithoutConnection = removeConnectionDirectiveFromDocument(newMockedResponse.request.query);
                invariant__default(queryWithoutConnection, "query is required");
                newMockedResponse.request.query = queryWithoutConnection;
                var query = removeClientSetsFromDocument(newMockedResponse.request.query);
                if (query) {
                    newMockedResponse.request.query = query;
                }
                return newMockedResponse;
            };
            return MockLink;
        }(ApolloLink);
        function mockSingleLink() {
            var mockedResponses = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                mockedResponses[_i] = arguments[_i];
            }
            var maybeTypename = mockedResponses[mockedResponses.length - 1];
            var mocks = mockedResponses.slice(0, mockedResponses.length - 1);
            if (typeof maybeTypename !== 'boolean') {
                mocks = mockedResponses;
                maybeTypename = true;
            }
            return new MockLink(mocks, maybeTypename);
        }

        var MockedProvider = function (_super) {
            tslib.__extends(MockedProvider, _super);
            function MockedProvider(props) {
                var _this = _super.call(this, props) || this;
                var _a = _this.props,
                    mocks = _a.mocks,
                    addTypename = _a.addTypename,
                    defaultOptions = _a.defaultOptions,
                    cache = _a.cache,
                    resolvers = _a.resolvers,
                    link = _a.link;
                var client = new ApolloClient({
                    cache: cache || new InMemoryCache({ addTypename: addTypename }),
                    defaultOptions: defaultOptions,
                    link: link || new MockLink(mocks || [], addTypename),
                    resolvers: resolvers
                });
                _this.state = { client: client };
                return _this;
            }
            MockedProvider.prototype.render = function () {
                var _a = this.props,
                    children = _a.children,
                    childProps = _a.childProps;
                return children ? React$1.createElement(ApolloProvider, { client: this.state.client }, React$1.cloneElement(React$1.Children.only(children), tslib.__assign({}, childProps))) : null;
            };
            MockedProvider.prototype.componentWillUnmount = function () {
                this.state.client.stop();
            };
            MockedProvider.defaultProps = {
                addTypename: true
            };
            return MockedProvider;
        }(React$1.Component);

        var MockSubscriptionLink = function (_super) {
            tslib.__extends(MockSubscriptionLink, _super);
            function MockSubscriptionLink() {
                var _this = _super.call(this) || this;
                _this.unsubscribers = [];
                _this.setups = [];
                return _this;
            }
            MockSubscriptionLink.prototype.request = function (_req) {
                var _this = this;
                return new Observable(function (observer) {
                    _this.setups.forEach(function (x) {
                        return x();
                    });
                    _this.observer = observer;
                    return function () {
                        _this.unsubscribers.forEach(function (x) {
                            return x();
                        });
                    };
                });
            };
            MockSubscriptionLink.prototype.simulateResult = function (result, complete) {
                var _this = this;
                if (complete === void 0) {
                    complete = false;
                }
                setTimeout(function () {
                    var observer = _this.observer;
                    if (!observer) throw new Error('subscription torn down');
                    if (complete && observer.complete) observer.complete();
                    if (result.result && observer.next) observer.next(result.result);
                    if (result.error && observer.error) observer.error(result.error);
                }, result.delay || 0);
            };
            MockSubscriptionLink.prototype.simulateComplete = function () {
                var observer = this.observer;
                if (!observer) throw new Error('subscription torn down');
                if (observer.complete) observer.complete();
            };
            MockSubscriptionLink.prototype.onSetup = function (listener) {
                this.setups = this.setups.concat([listener]);
            };
            MockSubscriptionLink.prototype.onUnsubscribe = function (listener) {
                this.unsubscribers = this.unsubscribers.concat([listener]);
            };
            return MockSubscriptionLink;
        }(ApolloLink);
        function mockObservableLink() {
            return new MockSubscriptionLink();
        }

        function createMockClient(data, query, variables) {
            if (variables === void 0) {
                variables = {};
            }
            return new ApolloClient({
                link: mockSingleLink({
                    request: { query: query, variables: variables },
                    result: { data: data }
                }).setOnError(function (error) {
                    throw error;
                }),
                cache: new InMemoryCache({ addTypename: false })
            });
        }

        function stripSymbols(data) {
            return JSON.parse(JSON.stringify(data));
        }

        exports.MockLink = MockLink;
        exports.MockSubscriptionLink = MockSubscriptionLink;
        exports.MockedProvider = MockedProvider;
        exports.createMockClient = createMockClient;
        exports.mockObservableLink = mockObservableLink;
        exports.mockSingleLink = mockSingleLink;
        exports.stripSymbols = stripSymbols;
    }
});
//# sourceMappingURL=testing.js.map