Liferay.Loader.define('@questions-web$apollo/client@3.0.0-beta.50/utilities/graphql/directives', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { invariant } from 'ts-invariant';
        import { visit } from 'graphql/language/visitor';

        function shouldInclude(_a, variables) {
            var directives = _a.directives;
            if (!directives || !directives.length) {
                return true;
            }
            return getInclusionDirectives(directives).every(function (_a) {
                var directive = _a.directive,
                    ifArgument = _a.ifArgument;
                var evaledValue = false;
                if (ifArgument.value.kind === 'Variable') {
                    evaledValue = variables && variables[ifArgument.value.name.value];
                    invariant(evaledValue !== void 0, 37);
                } else {
                    evaledValue = ifArgument.value.value;
                }
                return directive.name.value === 'skip' ? !evaledValue : evaledValue;
            });
        }
        function getDirectiveNames(root) {
            var names = [];
            visit(root, {
                Directive: function (node) {
                    names.push(node.name.value);
                }
            });
            return names;
        }
        function hasDirectives(names, root) {
            return getDirectiveNames(root).some(function (name) {
                return names.indexOf(name) > -1;
            });
        }
        function hasClientExports(document) {
            return document && hasDirectives(['client'], document) && hasDirectives(['export'], document);
        }
        function isInclusionDirective(_a) {
            var value = _a.name.value;
            return value === 'skip' || value === 'include';
        }
        function getInclusionDirectives(directives) {
            var result = [];
            if (directives && directives.length) {
                directives.forEach(function (directive) {
                    if (!isInclusionDirective(directive)) return;
                    var directiveArguments = directive.arguments;
                    var directiveName = directive.name.value;
                    invariant(directiveArguments && directiveArguments.length === 1, 38);
                    var ifArgument = directiveArguments[0];
                    invariant(ifArgument.name && ifArgument.name.value === 'if', 39);
                    var ifValue = ifArgument.value;
                    invariant(ifValue && (ifValue.kind === 'Variable' || ifValue.kind === 'BooleanValue'), 40);
                    result.push({ directive: directive, ifArgument: ifArgument });
                });
            }
            return result;
        }

        export { getDirectiveNames, getInclusionDirectives, hasClientExports, hasDirectives, shouldInclude };
        //# sourceMappingURL=directives.js.map
    }
});
//# sourceMappingURL=directives.js.map