Liferay.Loader.define('@questions-web$apollo/client@3.0.0-beta.50/utilities/graphql/fragments', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { __assign, __spreadArrays } from 'tslib';
        import { InvariantError, invariant } from 'ts-invariant';

        function getFragmentQueryDocument(document, fragmentName) {
            var actualFragmentName = fragmentName;
            var fragments = [];
            document.definitions.forEach(function (definition) {
                if (definition.kind === 'OperationDefinition') {
                    throw new InvariantError(41);
                }
                if (definition.kind === 'FragmentDefinition') {
                    fragments.push(definition);
                }
            });
            if (typeof actualFragmentName === 'undefined') {
                invariant(fragments.length === 1, 42);
                actualFragmentName = fragments[0].name.value;
            }
            var query = __assign(__assign({}, document), { definitions: __spreadArrays([{
                    kind: 'OperationDefinition',
                    operation: 'query',
                    selectionSet: {
                        kind: 'SelectionSet',
                        selections: [{
                            kind: 'FragmentSpread',
                            name: {
                                kind: 'Name',
                                value: actualFragmentName
                            }
                        }]
                    }
                }], document.definitions) });
            return query;
        }
        function createFragmentMap(fragments) {
            if (fragments === void 0) {
                fragments = [];
            }
            var symTable = {};
            fragments.forEach(function (fragment) {
                symTable[fragment.name.value] = fragment;
            });
            return symTable;
        }
        function getFragmentFromSelection(selection, fragmentMap) {
            switch (selection.kind) {
                case 'InlineFragment':
                    return selection;
                case 'FragmentSpread':
                    {
                        var fragment = fragmentMap && fragmentMap[selection.name.value];
                        invariant(fragment, 43);
                        return fragment;
                    }
                default:
                    return null;
            }
        }

        export { createFragmentMap, getFragmentFromSelection, getFragmentQueryDocument };
        //# sourceMappingURL=fragments.js.map
    }
});
//# sourceMappingURL=fragments.js.map