Liferay.Loader.define('@questions-web$apollo/client@3.0.0-beta.50/utilities/graphql/getFromAST', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { invariant, InvariantError } from 'ts-invariant';
        import { valueToObjectRepresentation } from './storeUtils.js';

        function checkDocument(doc) {
            invariant(doc && doc.kind === 'Document', 24);
            var operations = doc.definitions.filter(function (d) {
                return d.kind !== 'FragmentDefinition';
            }).map(function (definition) {
                if (definition.kind !== 'OperationDefinition') {
                    throw new InvariantError(25);
                }
                return definition;
            });
            invariant(operations.length <= 1, 26);
            return doc;
        }
        function getOperationDefinition(doc) {
            checkDocument(doc);
            return doc.definitions.filter(function (definition) {
                return definition.kind === 'OperationDefinition';
            })[0];
        }
        function getOperationName(doc) {
            return doc.definitions.filter(function (definition) {
                return definition.kind === 'OperationDefinition' && definition.name;
            }).map(function (x) {
                return x.name.value;
            })[0] || null;
        }
        function getFragmentDefinitions(doc) {
            return doc.definitions.filter(function (definition) {
                return definition.kind === 'FragmentDefinition';
            });
        }
        function getQueryDefinition(doc) {
            var queryDef = getOperationDefinition(doc);
            invariant(queryDef && queryDef.operation === 'query', 27);
            return queryDef;
        }
        function getFragmentDefinition(doc) {
            invariant(doc.kind === 'Document', 28);
            invariant(doc.definitions.length <= 1, 29);
            var fragmentDef = doc.definitions[0];
            invariant(fragmentDef.kind === 'FragmentDefinition', 30);
            return fragmentDef;
        }
        function getMainDefinition(queryDoc) {
            checkDocument(queryDoc);
            var fragmentDefinition;
            for (var _i = 0, _a = queryDoc.definitions; _i < _a.length; _i++) {
                var definition = _a[_i];
                if (definition.kind === 'OperationDefinition') {
                    var operation = definition.operation;
                    if (operation === 'query' || operation === 'mutation' || operation === 'subscription') {
                        return definition;
                    }
                }
                if (definition.kind === 'FragmentDefinition' && !fragmentDefinition) {
                    fragmentDefinition = definition;
                }
            }
            if (fragmentDefinition) {
                return fragmentDefinition;
            }
            throw new InvariantError(31);
        }
        function getDefaultValues(definition) {
            var defaultValues = Object.create(null);
            var defs = definition && definition.variableDefinitions;
            if (defs && defs.length) {
                defs.forEach(function (def) {
                    if (def.defaultValue) {
                        valueToObjectRepresentation(defaultValues, def.variable.name, def.defaultValue);
                    }
                });
            }
            return defaultValues;
        }

        export { checkDocument, getDefaultValues, getFragmentDefinition, getFragmentDefinitions, getMainDefinition, getOperationDefinition, getOperationName, getQueryDefinition };
        //# sourceMappingURL=getFromAST.js.map
    }
});
//# sourceMappingURL=getFromAST.js.map