Liferay.Loader.define('@questions-web$apollo/client@3.0.0-beta.50/utilities/testing/mocking/mockSubscriptionLink', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { __extends } from "tslib";
        import { Observable } from '../../../utilities/observables/Observable';
        import { ApolloLink } from '../../../link/core/ApolloLink';
        var MockSubscriptionLink = function (_super) {
            __extends(MockSubscriptionLink, _super);
            function MockSubscriptionLink() {
                var _this = _super.call(this) || this;
                _this.unsubscribers = [];
                _this.setups = [];
                return _this;
            }
            MockSubscriptionLink.prototype.request = function (_req) {
                var _this = this;
                return new Observable(function (observer) {
                    _this.setups.forEach(function (x) {
                        return x();
                    });
                    _this.observer = observer;
                    return function () {
                        _this.unsubscribers.forEach(function (x) {
                            return x();
                        });
                    };
                });
            };
            MockSubscriptionLink.prototype.simulateResult = function (result, complete) {
                var _this = this;
                if (complete === void 0) {
                    complete = false;
                }
                setTimeout(function () {
                    var observer = _this.observer;
                    if (!observer) throw new Error('subscription torn down');
                    if (complete && observer.complete) observer.complete();
                    if (result.result && observer.next) observer.next(result.result);
                    if (result.error && observer.error) observer.error(result.error);
                }, result.delay || 0);
            };
            MockSubscriptionLink.prototype.simulateComplete = function () {
                var observer = this.observer;
                if (!observer) throw new Error('subscription torn down');
                if (observer.complete) observer.complete();
            };
            MockSubscriptionLink.prototype.onSetup = function (listener) {
                this.setups = this.setups.concat([listener]);
            };
            MockSubscriptionLink.prototype.onUnsubscribe = function (listener) {
                this.unsubscribers = this.unsubscribers.concat([listener]);
            };
            return MockSubscriptionLink;
        }(ApolloLink);
        export { MockSubscriptionLink };
        export function mockObservableLink() {
            return new MockSubscriptionLink();
        }
        //# sourceMappingURL=mockSubscriptionLink.js.map
    }
});
//# sourceMappingURL=mockSubscriptionLink.js.map