'use strict';

Liferay.Loader.define('@questions-web$apollo/client@3.0.0-beta.50/utilities/utilities.cjs', ['module', 'exports', 'require', 'questions-web$ts-invariant', 'questions-web$graphql/language/visitor', 'questions-web$tslib', 'questions-web$fast-json-stable-stringify'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        Object.defineProperty(exports, '__esModule', { value: true });

        function _interopDefault(ex) {
            return ex && typeof ex === 'object' && 'default' in ex ? ex['default'] : ex;
        }

        var tsInvariant = require('questions-web$ts-invariant');
        var visitor = require('questions-web$graphql/language/visitor');
        var tslib = require('questions-web$tslib');
        var stringify = _interopDefault(require('questions-web$fast-json-stable-stringify'));

        function shouldInclude(_a, variables) {
            var directives = _a.directives;
            if (!directives || !directives.length) {
                return true;
            }
            return getInclusionDirectives(directives).every(function (_a) {
                var directive = _a.directive,
                    ifArgument = _a.ifArgument;
                var evaledValue = false;
                if (ifArgument.value.kind === 'Variable') {
                    evaledValue = variables && variables[ifArgument.value.name.value];
                    tsInvariant.invariant(evaledValue !== void 0, 37);
                } else {
                    evaledValue = ifArgument.value.value;
                }
                return directive.name.value === 'skip' ? !evaledValue : evaledValue;
            });
        }
        function getDirectiveNames(root) {
            var names = [];
            visitor.visit(root, {
                Directive: function (node) {
                    names.push(node.name.value);
                }
            });
            return names;
        }
        function hasDirectives(names, root) {
            return getDirectiveNames(root).some(function (name) {
                return names.indexOf(name) > -1;
            });
        }
        function hasClientExports(document) {
            return document && hasDirectives(['client'], document) && hasDirectives(['export'], document);
        }
        function isInclusionDirective(_a) {
            var value = _a.name.value;
            return value === 'skip' || value === 'include';
        }
        function getInclusionDirectives(directives) {
            var result = [];
            if (directives && directives.length) {
                directives.forEach(function (directive) {
                    if (!isInclusionDirective(directive)) return;
                    var directiveArguments = directive.arguments;
                    var directiveName = directive.name.value;
                    tsInvariant.invariant(directiveArguments && directiveArguments.length === 1, 38);
                    var ifArgument = directiveArguments[0];
                    tsInvariant.invariant(ifArgument.name && ifArgument.name.value === 'if', 39);
                    var ifValue = ifArgument.value;
                    tsInvariant.invariant(ifValue && (ifValue.kind === 'Variable' || ifValue.kind === 'BooleanValue'), 40);
                    result.push({ directive: directive, ifArgument: ifArgument });
                });
            }
            return result;
        }

        function getFragmentQueryDocument(document, fragmentName) {
            var actualFragmentName = fragmentName;
            var fragments = [];
            document.definitions.forEach(function (definition) {
                if (definition.kind === 'OperationDefinition') {
                    throw new tsInvariant.InvariantError(41);
                }
                if (definition.kind === 'FragmentDefinition') {
                    fragments.push(definition);
                }
            });
            if (typeof actualFragmentName === 'undefined') {
                tsInvariant.invariant(fragments.length === 1, 42);
                actualFragmentName = fragments[0].name.value;
            }
            var query = tslib.__assign(tslib.__assign({}, document), { definitions: tslib.__spreadArrays([{
                    kind: 'OperationDefinition',
                    operation: 'query',
                    selectionSet: {
                        kind: 'SelectionSet',
                        selections: [{
                            kind: 'FragmentSpread',
                            name: {
                                kind: 'Name',
                                value: actualFragmentName
                            }
                        }]
                    }
                }], document.definitions) });
            return query;
        }
        function createFragmentMap(fragments) {
            if (fragments === void 0) {
                fragments = [];
            }
            var symTable = {};
            fragments.forEach(function (fragment) {
                symTable[fragment.name.value] = fragment;
            });
            return symTable;
        }
        function getFragmentFromSelection(selection, fragmentMap) {
            switch (selection.kind) {
                case 'InlineFragment':
                    return selection;
                case 'FragmentSpread':
                    {
                        var fragment = fragmentMap && fragmentMap[selection.name.value];
                        tsInvariant.invariant(fragment, 43);
                        return fragment;
                    }
                default:
                    return null;
            }
        }

        function makeReference(id) {
            return { __ref: String(id) };
        }
        function isReference(obj) {
            return obj && typeof obj === 'object' && typeof obj.__ref === 'string';
        }
        function isStringValue(value) {
            return value.kind === 'StringValue';
        }
        function isBooleanValue(value) {
            return value.kind === 'BooleanValue';
        }
        function isIntValue(value) {
            return value.kind === 'IntValue';
        }
        function isFloatValue(value) {
            return value.kind === 'FloatValue';
        }
        function isVariable(value) {
            return value.kind === 'Variable';
        }
        function isObjectValue(value) {
            return value.kind === 'ObjectValue';
        }
        function isListValue(value) {
            return value.kind === 'ListValue';
        }
        function isEnumValue(value) {
            return value.kind === 'EnumValue';
        }
        function isNullValue(value) {
            return value.kind === 'NullValue';
        }
        function valueToObjectRepresentation(argObj, name, value, variables) {
            if (isIntValue(value) || isFloatValue(value)) {
                argObj[name.value] = Number(value.value);
            } else if (isBooleanValue(value) || isStringValue(value)) {
                argObj[name.value] = value.value;
            } else if (isObjectValue(value)) {
                var nestedArgObj_1 = {};
                value.fields.map(function (obj) {
                    return valueToObjectRepresentation(nestedArgObj_1, obj.name, obj.value, variables);
                });
                argObj[name.value] = nestedArgObj_1;
            } else if (isVariable(value)) {
                var variableValue = (variables || {})[value.name.value];
                argObj[name.value] = variableValue;
            } else if (isListValue(value)) {
                argObj[name.value] = value.values.map(function (listValue) {
                    var nestedArgArrayObj = {};
                    valueToObjectRepresentation(nestedArgArrayObj, name, listValue, variables);
                    return nestedArgArrayObj[name.value];
                });
            } else if (isEnumValue(value)) {
                argObj[name.value] = value.value;
            } else if (isNullValue(value)) {
                argObj[name.value] = null;
            } else {
                throw new tsInvariant.InvariantError(33);
            }
        }
        function storeKeyNameFromField(field, variables) {
            var directivesObj = null;
            if (field.directives) {
                directivesObj = {};
                field.directives.forEach(function (directive) {
                    directivesObj[directive.name.value] = {};
                    if (directive.arguments) {
                        directive.arguments.forEach(function (_a) {
                            var name = _a.name,
                                value = _a.value;
                            return valueToObjectRepresentation(directivesObj[directive.name.value], name, value, variables);
                        });
                    }
                });
            }
            var argObj = null;
            if (field.arguments && field.arguments.length) {
                argObj = {};
                field.arguments.forEach(function (_a) {
                    var name = _a.name,
                        value = _a.value;
                    return valueToObjectRepresentation(argObj, name, value, variables);
                });
            }
            return getStoreKeyName(field.name.value, argObj, directivesObj);
        }
        var KNOWN_DIRECTIVES = ['connection', 'include', 'skip', 'client', 'rest', 'export'];
        function getStoreKeyName(fieldName, args, directives) {
            if (args && directives && directives['connection'] && directives['connection']['key']) {
                if (directives['connection']['filter'] && directives['connection']['filter'].length > 0) {
                    var filterKeys = directives['connection']['filter'] ? directives['connection']['filter'] : [];
                    filterKeys.sort();
                    var filteredArgs_1 = {};
                    filterKeys.forEach(function (key) {
                        filteredArgs_1[key] = args[key];
                    });
                    return directives['connection']['key'] + "(" + JSON.stringify(filteredArgs_1) + ")";
                } else {
                    return directives['connection']['key'];
                }
            }
            var completeFieldName = fieldName;
            if (args) {
                var stringifiedArgs = stringify(args);
                completeFieldName += "(" + stringifiedArgs + ")";
            }
            if (directives) {
                Object.keys(directives).forEach(function (key) {
                    if (KNOWN_DIRECTIVES.indexOf(key) !== -1) return;
                    if (directives[key] && Object.keys(directives[key]).length) {
                        completeFieldName += "@" + key + "(" + JSON.stringify(directives[key]) + ")";
                    } else {
                        completeFieldName += "@" + key;
                    }
                });
            }
            return completeFieldName;
        }
        function argumentsObjectFromField(field, variables) {
            if (field.arguments && field.arguments.length) {
                var argObj_1 = {};
                field.arguments.forEach(function (_a) {
                    var name = _a.name,
                        value = _a.value;
                    return valueToObjectRepresentation(argObj_1, name, value, variables);
                });
                return argObj_1;
            }
            return null;
        }
        function resultKeyNameFromField(field) {
            return field.alias ? field.alias.value : field.name.value;
        }
        function getTypenameFromResult(result, selectionSet, fragmentMap) {
            if (typeof result.__typename === 'string') {
                return result.__typename;
            }
            for (var _i = 0, _a = selectionSet.selections; _i < _a.length; _i++) {
                var selection = _a[_i];
                if (isField(selection)) {
                    if (selection.name.value === '__typename') {
                        return result[resultKeyNameFromField(selection)];
                    }
                } else {
                    var typename = getTypenameFromResult(result, getFragmentFromSelection(selection, fragmentMap).selectionSet, fragmentMap);
                    if (typeof typename === 'string') {
                        return typename;
                    }
                }
            }
        }
        function isField(selection) {
            return selection.kind === 'Field';
        }
        function isInlineFragment(selection) {
            return selection.kind === 'InlineFragment';
        }

        function checkDocument(doc) {
            tsInvariant.invariant(doc && doc.kind === 'Document', 24);
            var operations = doc.definitions.filter(function (d) {
                return d.kind !== 'FragmentDefinition';
            }).map(function (definition) {
                if (definition.kind !== 'OperationDefinition') {
                    throw new tsInvariant.InvariantError(25);
                }
                return definition;
            });
            tsInvariant.invariant(operations.length <= 1, 26);
            return doc;
        }
        function getOperationDefinition(doc) {
            checkDocument(doc);
            return doc.definitions.filter(function (definition) {
                return definition.kind === 'OperationDefinition';
            })[0];
        }
        function getOperationName(doc) {
            return doc.definitions.filter(function (definition) {
                return definition.kind === 'OperationDefinition' && definition.name;
            }).map(function (x) {
                return x.name.value;
            })[0] || null;
        }
        function getFragmentDefinitions(doc) {
            return doc.definitions.filter(function (definition) {
                return definition.kind === 'FragmentDefinition';
            });
        }
        function getQueryDefinition(doc) {
            var queryDef = getOperationDefinition(doc);
            tsInvariant.invariant(queryDef && queryDef.operation === 'query', 27);
            return queryDef;
        }
        function getFragmentDefinition(doc) {
            tsInvariant.invariant(doc.kind === 'Document', 28);
            tsInvariant.invariant(doc.definitions.length <= 1, 29);
            var fragmentDef = doc.definitions[0];
            tsInvariant.invariant(fragmentDef.kind === 'FragmentDefinition', 30);
            return fragmentDef;
        }
        function getMainDefinition(queryDoc) {
            checkDocument(queryDoc);
            var fragmentDefinition;
            for (var _i = 0, _a = queryDoc.definitions; _i < _a.length; _i++) {
                var definition = _a[_i];
                if (definition.kind === 'OperationDefinition') {
                    var operation = definition.operation;
                    if (operation === 'query' || operation === 'mutation' || operation === 'subscription') {
                        return definition;
                    }
                }
                if (definition.kind === 'FragmentDefinition' && !fragmentDefinition) {
                    fragmentDefinition = definition;
                }
            }
            if (fragmentDefinition) {
                return fragmentDefinition;
            }
            throw new tsInvariant.InvariantError(31);
        }
        function getDefaultValues(definition) {
            var defaultValues = Object.create(null);
            var defs = definition && definition.variableDefinitions;
            if (defs && defs.length) {
                defs.forEach(function (def) {
                    if (def.defaultValue) {
                        valueToObjectRepresentation(defaultValues, def.variable.name, def.defaultValue);
                    }
                });
            }
            return defaultValues;
        }

        function filterInPlace(array, test, context) {
            var target = 0;
            array.forEach(function (elem, i) {
                if (test.call(this, elem, i, array)) {
                    array[target++] = elem;
                }
            }, context);
            array.length = target;
            return array;
        }

        var TYPENAME_FIELD = {
            kind: 'Field',
            name: {
                kind: 'Name',
                value: '__typename'
            }
        };
        function isEmpty(op, fragments) {
            return op.selectionSet.selections.every(function (selection) {
                return selection.kind === 'FragmentSpread' && isEmpty(fragments[selection.name.value], fragments);
            });
        }
        function nullIfDocIsEmpty(doc) {
            return isEmpty(getOperationDefinition(doc) || getFragmentDefinition(doc), createFragmentMap(getFragmentDefinitions(doc))) ? null : doc;
        }
        function getDirectiveMatcher(directives) {
            return function directiveMatcher(directive) {
                return directives.some(function (dir) {
                    return dir.name && dir.name === directive.name.value || dir.test && dir.test(directive);
                });
            };
        }
        function removeDirectivesFromDocument(directives, doc) {
            var variablesInUse = Object.create(null);
            var variablesToRemove = [];
            var fragmentSpreadsInUse = Object.create(null);
            var fragmentSpreadsToRemove = [];
            var modifiedDoc = nullIfDocIsEmpty(visitor.visit(doc, {
                Variable: {
                    enter: function (node, _key, parent) {
                        if (parent.kind !== 'VariableDefinition') {
                            variablesInUse[node.name.value] = true;
                        }
                    }
                },
                Field: {
                    enter: function (node) {
                        if (directives && node.directives) {
                            var shouldRemoveField = directives.some(function (directive) {
                                return directive.remove;
                            });
                            if (shouldRemoveField && node.directives && node.directives.some(getDirectiveMatcher(directives))) {
                                if (node.arguments) {
                                    node.arguments.forEach(function (arg) {
                                        if (arg.value.kind === 'Variable') {
                                            variablesToRemove.push({
                                                name: arg.value.name.value
                                            });
                                        }
                                    });
                                }
                                if (node.selectionSet) {
                                    getAllFragmentSpreadsFromSelectionSet(node.selectionSet).forEach(function (frag) {
                                        fragmentSpreadsToRemove.push({
                                            name: frag.name.value
                                        });
                                    });
                                }
                                return null;
                            }
                        }
                    }
                },
                FragmentSpread: {
                    enter: function (node) {
                        fragmentSpreadsInUse[node.name.value] = true;
                    }
                },
                Directive: {
                    enter: function (node) {
                        if (getDirectiveMatcher(directives)(node)) {
                            return null;
                        }
                    }
                }
            }));
            if (modifiedDoc && filterInPlace(variablesToRemove, function (v) {
                return !!v.name && !variablesInUse[v.name];
            }).length) {
                modifiedDoc = removeArgumentsFromDocument(variablesToRemove, modifiedDoc);
            }
            if (modifiedDoc && filterInPlace(fragmentSpreadsToRemove, function (fs) {
                return !!fs.name && !fragmentSpreadsInUse[fs.name];
            }).length) {
                modifiedDoc = removeFragmentSpreadFromDocument(fragmentSpreadsToRemove, modifiedDoc);
            }
            return modifiedDoc;
        }
        function addTypenameToDocument(doc) {
            return visitor.visit(checkDocument(doc), {
                SelectionSet: {
                    enter: function (node, _key, parent) {
                        if (parent && parent.kind === 'OperationDefinition') {
                            return;
                        }
                        var selections = node.selections;
                        if (!selections) {
                            return;
                        }
                        var skip = selections.some(function (selection) {
                            return isField(selection) && (selection.name.value === '__typename' || selection.name.value.lastIndexOf('__', 0) === 0);
                        });
                        if (skip) {
                            return;
                        }
                        var field = parent;
                        if (isField(field) && field.directives && field.directives.some(function (d) {
                            return d.name.value === 'export';
                        })) {
                            return;
                        }
                        return tslib.__assign(tslib.__assign({}, node), { selections: tslib.__spreadArrays(selections, [TYPENAME_FIELD]) });
                    }
                }
            });
        }
        addTypenameToDocument.added = function (field) {
            return field === TYPENAME_FIELD;
        };
        var connectionRemoveConfig = {
            test: function (directive) {
                var willRemove = directive.name.value === 'connection';
                if (willRemove) {
                    if (!directive.arguments || !directive.arguments.some(function (arg) {
                        return arg.name.value === 'key';
                    })) {
                        true || tsInvariant.invariant.warn('Removing an @connection directive even though it does not have a key. ' + 'You may want to use the key parameter to specify a store key.');
                    }
                }
                return willRemove;
            }
        };
        function removeConnectionDirectiveFromDocument(doc) {
            return removeDirectivesFromDocument([connectionRemoveConfig], checkDocument(doc));
        }
        function getArgumentMatcher(config) {
            return function argumentMatcher(argument) {
                return config.some(function (aConfig) {
                    return argument.value && argument.value.kind === 'Variable' && argument.value.name && (aConfig.name === argument.value.name.value || aConfig.test && aConfig.test(argument));
                });
            };
        }
        function removeArgumentsFromDocument(config, doc) {
            var argMatcher = getArgumentMatcher(config);
            return nullIfDocIsEmpty(visitor.visit(doc, {
                OperationDefinition: {
                    enter: function (node) {
                        return tslib.__assign(tslib.__assign({}, node), { variableDefinitions: node.variableDefinitions ? node.variableDefinitions.filter(function (varDef) {
                                return !config.some(function (arg) {
                                    return arg.name === varDef.variable.name.value;
                                });
                            }) : [] });
                    }
                },
                Field: {
                    enter: function (node) {
                        var shouldRemoveField = config.some(function (argConfig) {
                            return argConfig.remove;
                        });
                        if (shouldRemoveField) {
                            var argMatchCount_1 = 0;
                            if (node.arguments) {
                                node.arguments.forEach(function (arg) {
                                    if (argMatcher(arg)) {
                                        argMatchCount_1 += 1;
                                    }
                                });
                            }
                            if (argMatchCount_1 === 1) {
                                return null;
                            }
                        }
                    }
                },
                Argument: {
                    enter: function (node) {
                        if (argMatcher(node)) {
                            return null;
                        }
                    }
                }
            }));
        }
        function removeFragmentSpreadFromDocument(config, doc) {
            function enter(node) {
                if (config.some(function (def) {
                    return def.name === node.name.value;
                })) {
                    return null;
                }
            }
            return nullIfDocIsEmpty(visitor.visit(doc, {
                FragmentSpread: { enter: enter },
                FragmentDefinition: { enter: enter }
            }));
        }
        function getAllFragmentSpreadsFromSelectionSet(selectionSet) {
            var allFragments = [];
            selectionSet.selections.forEach(function (selection) {
                if ((isField(selection) || isInlineFragment(selection)) && selection.selectionSet) {
                    getAllFragmentSpreadsFromSelectionSet(selection.selectionSet).forEach(function (frag) {
                        return allFragments.push(frag);
                    });
                } else if (selection.kind === 'FragmentSpread') {
                    allFragments.push(selection);
                }
            });
            return allFragments;
        }
        function buildQueryFromSelectionSet(document) {
            var definition = getMainDefinition(document);
            var definitionOperation = definition.operation;
            if (definitionOperation === 'query') {
                return document;
            }
            var modifiedDoc = visitor.visit(document, {
                OperationDefinition: {
                    enter: function (node) {
                        return tslib.__assign(tslib.__assign({}, node), { operation: 'query' });
                    }
                }
            });
            return modifiedDoc;
        }
        function removeClientSetsFromDocument(document) {
            checkDocument(document);
            var modifiedDoc = removeDirectivesFromDocument([{
                test: function (directive) {
                    return directive.name.value === 'client';
                },
                remove: true
            }], document);
            if (modifiedDoc) {
                modifiedDoc = visitor.visit(modifiedDoc, {
                    FragmentDefinition: {
                        enter: function (node) {
                            if (node.selectionSet) {
                                var isTypenameOnly = node.selectionSet.selections.every(function (selection) {
                                    return isField(selection) && selection.name.value === '__typename';
                                });
                                if (isTypenameOnly) {
                                    return null;
                                }
                            }
                        }
                    }
                });
            }
            return modifiedDoc;
        }

        exports.addTypenameToDocument = addTypenameToDocument;
        exports.argumentsObjectFromField = argumentsObjectFromField;
        exports.buildQueryFromSelectionSet = buildQueryFromSelectionSet;
        exports.checkDocument = checkDocument;
        exports.createFragmentMap = createFragmentMap;
        exports.getDefaultValues = getDefaultValues;
        exports.getDirectiveNames = getDirectiveNames;
        exports.getFragmentDefinition = getFragmentDefinition;
        exports.getFragmentDefinitions = getFragmentDefinitions;
        exports.getFragmentFromSelection = getFragmentFromSelection;
        exports.getFragmentQueryDocument = getFragmentQueryDocument;
        exports.getInclusionDirectives = getInclusionDirectives;
        exports.getMainDefinition = getMainDefinition;
        exports.getOperationDefinition = getOperationDefinition;
        exports.getOperationName = getOperationName;
        exports.getQueryDefinition = getQueryDefinition;
        exports.getStoreKeyName = getStoreKeyName;
        exports.getTypenameFromResult = getTypenameFromResult;
        exports.hasClientExports = hasClientExports;
        exports.hasDirectives = hasDirectives;
        exports.isField = isField;
        exports.isInlineFragment = isInlineFragment;
        exports.isReference = isReference;
        exports.makeReference = makeReference;
        exports.removeArgumentsFromDocument = removeArgumentsFromDocument;
        exports.removeClientSetsFromDocument = removeClientSetsFromDocument;
        exports.removeConnectionDirectiveFromDocument = removeConnectionDirectiveFromDocument;
        exports.removeDirectivesFromDocument = removeDirectivesFromDocument;
        exports.removeFragmentSpreadFromDocument = removeFragmentSpreadFromDocument;
        exports.resultKeyNameFromField = resultKeyNameFromField;
        exports.shouldInclude = shouldInclude;
        exports.storeKeyNameFromField = storeKeyNameFromField;
        exports.valueToObjectRepresentation = valueToObjectRepresentation;
        //# sourceMappingURL=utilities.cjs.js.map
    }
});
//# sourceMappingURL=utilities.cjs.js.map