"use strict";

Liferay.Loader.define("questions-web$graphql@15.0.0/error/locatedError", ['module', 'exports', 'require', './GraphQLError'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.locatedError = locatedError;

    var _GraphQLError = require("./GraphQLError");

    /**
     * Given an arbitrary Error, presumably thrown while attempting to execute a
     * GraphQL operation, produce a new GraphQLError aware of the location in the
     * document responsible for the original Error.
     */
    function locatedError(originalError, nodes, path) {
      var _nodes;

      // Note: this uses a brand-check to support GraphQL errors originating from
      // other contexts.
      if (Array.isArray(originalError.path)) {
        return originalError;
      }

      return new _GraphQLError.GraphQLError(originalError.message, (_nodes = originalError.nodes) !== null && _nodes !== void 0 ? _nodes : nodes, originalError.source, originalError.positions, path, originalError);
    }
  }
});
//# sourceMappingURL=locatedError.js.map