"use strict";

Liferay.Loader.define("questions-web$graphql@15.0.0/jsutils/keyValMap", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = keyValMap;

    /**
     * Creates a keyed JS object from an array, given a function to produce the keys
     * and a function to produce the values from each item in the array.
     *
     *     const phoneBook = [
     *       { name: 'Jon', num: '555-1234' },
     *       { name: 'Jenny', num: '867-5309' }
     *     ]
     *
     *     // { Jon: '555-1234', Jenny: '867-5309' }
     *     const phonesByName = keyValMap(
     *       phoneBook,
     *       entry => entry.name,
     *       entry => entry.num
     *     )
     *
     */
    function keyValMap(list, keyFn, valFn) {
      return list.reduce(function (map, item) {
        map[keyFn(item)] = valFn(item);
        return map;
      }, Object.create(null));
    }
  }
});
//# sourceMappingURL=keyValMap.js.map