"use strict";

Liferay.Loader.define("questions-web$graphql@15.0.0/jsutils/memoize3", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = memoize3;

    /**
     * Memoizes the provided three-argument function.
     */
    function memoize3(fn) {
      var cache0;

      function memoized(a1, a2, a3) {
        if (!cache0) {
          cache0 = new WeakMap();
        }

        var cache1 = cache0.get(a1);
        var cache2;

        if (cache1) {
          cache2 = cache1.get(a2);

          if (cache2) {
            var cachedValue = cache2.get(a3);

            if (cachedValue !== undefined) {
              return cachedValue;
            }
          }
        } else {
          cache1 = new WeakMap();
          cache0.set(a1, cache1);
        }

        if (!cache2) {
          cache2 = new WeakMap();
          cache1.set(a2, cache2);
        }

        var newValue = fn(a1, a2, a3);
        cache2.set(a3, newValue);
        return newValue;
      }

      return memoized;
    }
  }
});
//# sourceMappingURL=memoize3.js.map