"use strict";

Liferay.Loader.define("questions-web$graphql@15.0.0/jsutils/promiseReduce", ['module', 'exports', 'require', './isPromise'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = promiseReduce;

    var _isPromise = _interopRequireDefault(require("./isPromise"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Similar to Array.prototype.reduce(), however the reducing callback may return
     * a Promise, in which case reduction will continue after each promise resolves.
     *
     * If the callback does not return a Promise, then this function will also not
     * return a Promise.
     */
    function promiseReduce(values, callback, initialValue) {
      return values.reduce(function (previous, value) {
        return (0, _isPromise.default)(previous) ? previous.then(function (resolved) {
          return callback(resolved, value);
        }) : callback(previous, value);
      }, initialValue);
    }
  }
});
//# sourceMappingURL=promiseReduce.js.map