"use strict";

Liferay.Loader.define("questions-web$graphql@15.0.0/subscription/mapAsyncIterator", ['module', 'exports', 'require', '../polyfills/symbols'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = mapAsyncIterator;

    var _symbols = require("../polyfills/symbols");

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    /**
     * Given an AsyncIterable and a callback function, return an AsyncIterator
     * which produces values mapped via calling the callback function.
     */
    function mapAsyncIterator(iterable, callback, rejectCallback) {
      // $FlowFixMe
      var iteratorMethod = iterable[_symbols.SYMBOL_ASYNC_ITERATOR];
      var iterator = iteratorMethod.call(iterable);
      var $return;
      var abruptClose;

      if (typeof iterator.return === 'function') {
        $return = iterator.return;

        abruptClose = function abruptClose(error) {
          var rethrow = function rethrow() {
            return Promise.reject(error);
          };

          return $return.call(iterator).then(rethrow, rethrow);
        };
      }

      function mapResult(result) {
        return result.done ? result : asyncMapValue(result.value, callback).then(iteratorResult, abruptClose);
      }

      var mapReject;

      if (rejectCallback) {

        mapReject = function mapReject(error) {
          return asyncMapValue(error, rejectCallback).then(iteratorResult, abruptClose);
        };
        // Capture rejectCallback to ensure it cannot be null.
      }
      /* TODO: Flow doesn't support symbols as keys:
         https://github.com/facebook/flow/issues/3258 */

      return _defineProperty({
        next: function next() {
          return iterator.next().then(mapResult, mapReject);
        },
        return: function _return() {
          return $return ? $return.call(iterator).then(mapResult, mapReject) : Promise.resolve({
            value: undefined,
            done: true
          });
        },
        throw: function _throw(error) {
          if (typeof iterator.throw === 'function') {
            return iterator.throw(error).then(mapResult, mapReject);
          }

          return Promise.reject(error).catch(abruptClose);
        }
      }, _symbols.SYMBOL_ASYNC_ITERATOR, function () {
        return this;
      });
    }

    function asyncMapValue(value, callback) {
      return new Promise(function (resolve) {
        return resolve(callback(value));
      });
    }

    function iteratorResult(value) {
      return {
        value: value,
        done: false
      };
    }
  }
});
//# sourceMappingURL=mapAsyncIterator.js.map