"use strict";

Liferay.Loader.define("questions-web$graphql@15.0.0/utilities/typeFromAST", ['module', 'exports', 'require', '../jsutils/inspect', '../jsutils/invariant', '../language/kinds', '../type/definition'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.typeFromAST = typeFromAST;

    var _inspect = _interopRequireDefault(require("../jsutils/inspect"));

    var _invariant = _interopRequireDefault(require("../jsutils/invariant"));

    var _kinds = require("../language/kinds");

    var _definition = require("../type/definition");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function typeFromAST(schema, typeNode) {
      /* eslint-enable no-redeclare */
      var innerType;

      if (typeNode.kind === _kinds.Kind.LIST_TYPE) {
        innerType = typeFromAST(schema, typeNode.type);
        return innerType && (0, _definition.GraphQLList)(innerType);
      }

      if (typeNode.kind === _kinds.Kind.NON_NULL_TYPE) {
        innerType = typeFromAST(schema, typeNode.type);
        return innerType && (0, _definition.GraphQLNonNull)(innerType);
      }

      /* istanbul ignore else */
      if (typeNode.kind === _kinds.Kind.NAMED_TYPE) {
        return schema.getType(typeNode.name.value);
      } // Not reachable. All possible type nodes have been considered.


      /* istanbul ignore next */
      (0, _invariant.default)(false, 'Unexpected type node: ' + (0, _inspect.default)(typeNode));
    }
  }
});
//# sourceMappingURL=typeFromAST.js.map