"use strict";

Liferay.Loader.define("questions-web$graphql@15.0.0/validation/rules/FragmentsOnCompositeTypesRule", ['module', 'exports', 'require', '../../error/GraphQLError', '../../language/printer', '../../type/definition', '../../utilities/typeFromAST'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.FragmentsOnCompositeTypesRule = FragmentsOnCompositeTypesRule;

    var _GraphQLError = require("../../error/GraphQLError");

    var _printer = require("../../language/printer");

    var _definition = require("../../type/definition");

    var _typeFromAST = require("../../utilities/typeFromAST");

    /**
     * Fragments on composite type
     *
     * Fragments use a type condition to determine if they apply, since fragments
     * can only be spread into a composite type (object, interface, or union), the
     * type condition must also be a composite type.
     */
    function FragmentsOnCompositeTypesRule(context) {
      return {
        InlineFragment: function InlineFragment(node) {
          var typeCondition = node.typeCondition;

          if (typeCondition) {
            var type = (0, _typeFromAST.typeFromAST)(context.getSchema(), typeCondition);

            if (type && !(0, _definition.isCompositeType)(type)) {
              var typeStr = (0, _printer.print)(typeCondition);
              context.reportError(new _GraphQLError.GraphQLError("Fragment cannot condition on non composite type \"".concat(typeStr, "\"."), typeCondition));
            }
          }
        },
        FragmentDefinition: function FragmentDefinition(node) {
          var type = (0, _typeFromAST.typeFromAST)(context.getSchema(), node.typeCondition);

          if (type && !(0, _definition.isCompositeType)(type)) {
            var typeStr = (0, _printer.print)(node.typeCondition);
            context.reportError(new _GraphQLError.GraphQLError("Fragment \"".concat(node.name.value, "\" cannot condition on non composite type \"").concat(typeStr, "\"."), node.typeCondition));
          }
        }
      };
    }
  }
});
//# sourceMappingURL=FragmentsOnCompositeTypesRule.js.map