"use strict";

Liferay.Loader.define("questions-web$graphql@15.0.0/validation/rules/KnownFragmentNamesRule", ['module', 'exports', 'require', '../../error/GraphQLError'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.KnownFragmentNamesRule = KnownFragmentNamesRule;

    var _GraphQLError = require("../../error/GraphQLError");

    /**
     * Known fragment names
     *
     * A GraphQL document is only valid if all `...Fragment` fragment spreads refer
     * to fragments defined in the same document.
     */
    function KnownFragmentNamesRule(context) {
      return {
        FragmentSpread: function FragmentSpread(node) {
          var fragmentName = node.name.value;
          var fragment = context.getFragment(fragmentName);

          if (!fragment) {
            context.reportError(new _GraphQLError.GraphQLError("Unknown fragment \"".concat(fragmentName, "\"."), node.name));
          }
        }
      };
    }
  }
});
//# sourceMappingURL=KnownFragmentNamesRule.js.map