"use strict";

Liferay.Loader.define("questions-web$graphql@15.0.0/validation/rules/NoUndefinedVariablesRule", ['module', 'exports', 'require', '../../error/GraphQLError'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.NoUndefinedVariablesRule = NoUndefinedVariablesRule;

    var _GraphQLError = require("../../error/GraphQLError");

    /**
     * No undefined variables
     *
     * A GraphQL operation is only valid if all variables encountered, both directly
     * and via fragment spreads, are defined by that operation.
     */
    function NoUndefinedVariablesRule(context) {
      var variableNameDefined = Object.create(null);
      return {
        OperationDefinition: {
          enter: function enter() {
            variableNameDefined = Object.create(null);
          },
          leave: function leave(operation) {
            var usages = context.getRecursiveVariableUsages(operation);

            for (var _i2 = 0; _i2 < usages.length; _i2++) {
              var _ref2 = usages[_i2];
              var node = _ref2.node;
              var varName = node.name.value;

              if (variableNameDefined[varName] !== true) {
                context.reportError(new _GraphQLError.GraphQLError(operation.name ? "Variable \"$".concat(varName, "\" is not defined by operation \"").concat(operation.name.value, "\".") : "Variable \"$".concat(varName, "\" is not defined."), [node, operation]));
              }
            }
          }
        },
        VariableDefinition: function VariableDefinition(node) {
          variableNameDefined[node.variable.name.value] = true;
        }
      };
    }
  }
});
//# sourceMappingURL=NoUndefinedVariablesRule.js.map