"use strict";

Liferay.Loader.define("questions-web$graphql@15.0.0/validation/rules/UniqueArgumentNamesRule", ['module', 'exports', 'require', '../../error/GraphQLError'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.UniqueArgumentNamesRule = UniqueArgumentNamesRule;

    var _GraphQLError = require("../../error/GraphQLError");

    /**
     * Unique argument names
     *
     * A GraphQL field or directive is only valid if all supplied arguments are
     * uniquely named.
     */
    function UniqueArgumentNamesRule(context) {
      var knownArgNames = Object.create(null);
      return {
        Field: function Field() {
          knownArgNames = Object.create(null);
        },
        Directive: function Directive() {
          knownArgNames = Object.create(null);
        },
        Argument: function Argument(node) {
          var argName = node.name.value;

          if (knownArgNames[argName]) {
            context.reportError(new _GraphQLError.GraphQLError("There can be only one argument named \"".concat(argName, "\"."), [knownArgNames[argName], node.name]));
          } else {
            knownArgNames[argName] = node.name;
          }

          return false;
        }
      };
    }
  }
});
//# sourceMappingURL=UniqueArgumentNamesRule.js.map