"use strict";

Liferay.Loader.define("questions-web$graphql@15.0.0/validation/rules/UniqueDirectivesPerLocationRule", ['module', 'exports', 'require', '../../error/GraphQLError', '../../language/kinds', '../../language/predicates', '../../type/directives'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.UniqueDirectivesPerLocationRule = UniqueDirectivesPerLocationRule;

    var _GraphQLError = require("../../error/GraphQLError");

    var _kinds = require("../../language/kinds");

    var _predicates = require("../../language/predicates");

    var _directives = require("../../type/directives");

    /**
     * Unique directive names per location
     *
     * A GraphQL document is only valid if all non-repeatable directives at
     * a given location are uniquely named.
     */
    function UniqueDirectivesPerLocationRule(context) {
      var uniqueDirectiveMap = Object.create(null);
      var schema = context.getSchema();
      var definedDirectives = schema ? schema.getDirectives() : _directives.specifiedDirectives;

      for (var _i2 = 0; _i2 < definedDirectives.length; _i2++) {
        var directive = definedDirectives[_i2];
        uniqueDirectiveMap[directive.name] = !directive.isRepeatable;
      }

      var astDefinitions = context.getDocument().definitions;

      for (var _i4 = 0; _i4 < astDefinitions.length; _i4++) {
        var def = astDefinitions[_i4];

        if (def.kind === _kinds.Kind.DIRECTIVE_DEFINITION) {
          uniqueDirectiveMap[def.name.value] = !def.repeatable;
        }
      }

      var schemaDirectives = Object.create(null);
      var typeDirectivesMap = Object.create(null);
      return {
        // Many different AST nodes may contain directives. Rather than listing
        // them all, just listen for entering any node, and check to see if it
        // defines any directives.
        enter: function enter(node) {
          if (node.directives == null) {
            return;
          }

          var seenDirectives;

          if (node.kind === _kinds.Kind.SCHEMA_DEFINITION || node.kind === _kinds.Kind.SCHEMA_EXTENSION) {
            seenDirectives = schemaDirectives;
          } else if ((0, _predicates.isTypeDefinitionNode)(node) || (0, _predicates.isTypeExtensionNode)(node)) {
            var typeName = node.name.value;
            seenDirectives = typeDirectivesMap[typeName];

            if (seenDirectives === undefined) {
              typeDirectivesMap[typeName] = seenDirectives = Object.create(null);
            }
          } else {
            seenDirectives = Object.create(null);
          }

          for (var _i6 = 0, _node$directives2 = node.directives; _i6 < _node$directives2.length; _i6++) {
            var _directive = _node$directives2[_i6];
            var directiveName = _directive.name.value;

            if (uniqueDirectiveMap[directiveName]) {
              if (seenDirectives[directiveName]) {
                context.reportError(new _GraphQLError.GraphQLError("The directive \"@".concat(directiveName, "\" can only be used once at this location."), [seenDirectives[directiveName], _directive]));
              } else {
                seenDirectives[directiveName] = _directive;
              }
            }
          }
        }
      };
    }
  }
});
//# sourceMappingURL=UniqueDirectivesPerLocationRule.js.map