"use strict";

Liferay.Loader.define("questions-web$graphql@15.0.0/validation/rules/UniqueFieldDefinitionNamesRule", ['module', 'exports', 'require', '../../error/GraphQLError', '../../type/definition'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.UniqueFieldDefinitionNamesRule = UniqueFieldDefinitionNamesRule;

    var _GraphQLError = require("../../error/GraphQLError");

    var _definition = require("../../type/definition");

    /**
     * Unique field definition names
     *
     * A GraphQL complex type is only valid if all its fields are uniquely named.
     */
    function UniqueFieldDefinitionNamesRule(context) {
      var schema = context.getSchema();
      var existingTypeMap = schema ? schema.getTypeMap() : Object.create(null);
      var knownFieldNames = Object.create(null);
      return {
        InputObjectTypeDefinition: checkFieldUniqueness,
        InputObjectTypeExtension: checkFieldUniqueness,
        InterfaceTypeDefinition: checkFieldUniqueness,
        InterfaceTypeExtension: checkFieldUniqueness,
        ObjectTypeDefinition: checkFieldUniqueness,
        ObjectTypeExtension: checkFieldUniqueness
      };

      function checkFieldUniqueness(node) {
        var _node$fields;

        var typeName = node.name.value;

        if (!knownFieldNames[typeName]) {
          knownFieldNames[typeName] = Object.create(null);
        }
        /* istanbul ignore next (See https://github.com/graphql/graphql-js/issues/2203) */

        var fieldNodes = (_node$fields = node.fields) !== null && _node$fields !== void 0 ? _node$fields : [];
        var fieldNames = knownFieldNames[typeName];

        for (var _i2 = 0; _i2 < fieldNodes.length; _i2++) {
          var fieldDef = fieldNodes[_i2];
          var fieldName = fieldDef.name.value;

          if (hasField(existingTypeMap[typeName], fieldName)) {
            context.reportError(new _GraphQLError.GraphQLError("Field \"".concat(typeName, ".").concat(fieldName, "\" already exists in the schema. It cannot also be defined in this type extension."), fieldDef.name));
          } else if (fieldNames[fieldName]) {
            context.reportError(new _GraphQLError.GraphQLError("Field \"".concat(typeName, ".").concat(fieldName, "\" can only be defined once."), [fieldNames[fieldName], fieldDef.name]));
          } else {
            fieldNames[fieldName] = fieldDef.name;
          }
        }

        return false;
      }
    }

    function hasField(type, fieldName) {
      if ((0, _definition.isObjectType)(type) || (0, _definition.isInterfaceType)(type) || (0, _definition.isInputObjectType)(type)) {
        return type.getFields()[fieldName];
      }

      return false;
    }
  }
});
//# sourceMappingURL=UniqueFieldDefinitionNamesRule.js.map