"use strict";

Liferay.Loader.define("questions-web$graphql@15.0.0/validation/rules/UniqueVariableNamesRule", ['module', 'exports', 'require', '../../error/GraphQLError'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.UniqueVariableNamesRule = UniqueVariableNamesRule;

    var _GraphQLError = require("../../error/GraphQLError");

    /**
     * Unique variable names
     *
     * A GraphQL operation is only valid if all its variables are uniquely named.
     */
    function UniqueVariableNamesRule(context) {
      var knownVariableNames = Object.create(null);
      return {
        OperationDefinition: function OperationDefinition() {
          knownVariableNames = Object.create(null);
        },
        VariableDefinition: function VariableDefinition(node) {
          var variableName = node.variable.name.value;

          if (knownVariableNames[variableName]) {
            context.reportError(new _GraphQLError.GraphQLError("There can be only one variable named \"$".concat(variableName, "\"."), [knownVariableNames[variableName], node.variable.name]));
          } else {
            knownVariableNames[variableName] = node.variable.name;
          }
        }
      };
    }
  }
});
//# sourceMappingURL=UniqueVariableNamesRule.js.map