Liferay.Loader.define('questions-web$highlight.js@10.1.0/lib/languages/ceylon', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    /*
    Language: Ceylon
    Author: Lucas Werkmeister <mail@lucaswerkmeister.de>
    Website: https://ceylon-lang.org
    */

    /** @type LanguageFn */
    function ceylon(hljs) {
      // 2.3. Identifiers and keywords
      var KEYWORDS = 'assembly module package import alias class interface object given value ' + 'assign void function new of extends satisfies abstracts in out return ' + 'break continue throw assert dynamic if else switch case for while try ' + 'catch finally then let this outer super is exists nonempty';
      // 7.4.1 Declaration Modifiers

      // 7.4.2 Documentation

      var SUBST = {
        className: 'subst', excludeBegin: true, excludeEnd: true,
        begin: /``/, end: /``/,
        keywords: KEYWORDS,
        relevance: 10
      };
      var EXPRESSIONS = [{
        // verbatim string
        className: 'string',
        begin: '"""',
        end: '"""',
        relevance: 10
      }, {
        // string literal or template
        className: 'string',
        begin: '"', end: '"',
        contains: [SUBST]
      }, {
        // character literal
        className: 'string',
        begin: "'",
        end: "'"
      }, {
        // numeric literal
        className: 'number',
        begin: '#[0-9a-fA-F_]+|\\$[01_]+|[0-9_]+(?:\\.[0-9_](?:[eE][+-]?\\d+)?)?[kMGTPmunpf]?',
        relevance: 0
      }];
      SUBST.contains = EXPRESSIONS;

      return {
        name: 'Ceylon',
        keywords: {
          keyword: KEYWORDS + ' ' + ('shared abstract formal default actual variable late native deprecated ' + 'final sealed annotation suppressWarnings small'),
          meta: 'doc by license see throws tagged'
        },
        illegal: '\\$[^01]|#[^0-9a-fA-F]',
        contains: [hljs.C_LINE_COMMENT_MODE, hljs.COMMENT('/\\*', '\\*/', { contains: ['self'] }), {
          // compiler annotation
          className: 'meta',
          begin: '@[a-z]\\w*(?:\\:\"[^\"]*\")?'
        }].concat(EXPRESSIONS)
      };
    }

    module.exports = ceylon;
  }
});
//# sourceMappingURL=ceylon.js.map