Liferay.Loader.define('questions-web$highlight.js@10.1.0/lib/languages/d', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    /*
    Language: D
    Author: Aleksandar Ruzicic <aleksandar@ruzicic.info>
    Description: D is a language with C-like syntax and static typing. It pragmatically combines efficiency, control, and modeling power, with safety and programmer productivity.
    Version: 1.0a
    Website: https://dlang.org
    Date: 2012-04-08
    */

    /**
     * Known issues:
     *
     * - invalid hex string literals will be recognized as a double quoted strings
     *   but 'x' at the beginning of string will not be matched
     *
     * - delimited string literals are not checked for matching end delimiter
     *   (not possible to do with js regexp)
     *
     * - content of token string is colored as a string (i.e. no keyword coloring inside a token string)
     *   also, content of token string is not validated to contain only valid D tokens
     *
     * - special token sequence rule is not strictly following D grammar (anything following #line
     *   up to the end of line is matched as special token sequence)
     */

    /** @type LanguageFn */
    function d(hljs) {
      /**
       * Language keywords
       *
       * @type {Object}
       */
      var D_KEYWORDS = {
        $pattern: hljs.UNDERSCORE_IDENT_RE,
        keyword: 'abstract alias align asm assert auto body break byte case cast catch class ' + 'const continue debug default delete deprecated do else enum export extern final ' + 'finally for foreach foreach_reverse|10 goto if immutable import in inout int ' + 'interface invariant is lazy macro mixin module new nothrow out override package ' + 'pragma private protected public pure ref return scope shared static struct ' + 'super switch synchronized template this throw try typedef typeid typeof union ' + 'unittest version void volatile while with __FILE__ __LINE__ __gshared|10 ' + '__thread __traits __DATE__ __EOF__ __TIME__ __TIMESTAMP__ __VENDOR__ __VERSION__',
        built_in: 'bool cdouble cent cfloat char creal dchar delegate double dstring float function ' + 'idouble ifloat ireal long real short string ubyte ucent uint ulong ushort wchar ' + 'wstring',
        literal: 'false null true'
      };

      /**
       * Number literal regexps
       *
       * @type {String}
       */
      var decimal_integer_re = '(0|[1-9][\\d_]*)',
          decimal_integer_nosus_re = '(0|[1-9][\\d_]*|\\d[\\d_]*|[\\d_]+?\\d)',
          hexadecimal_digits_re = '([\\da-fA-F][\\da-fA-F_]*|_[\\da-fA-F][\\da-fA-F_]*)',
          decimal_exponent_re = '([eE][+-]?' + decimal_integer_nosus_re + ')',
          integer_re = '(' + decimal_integer_re + '|' + '0[bB][01_]+' + '|' + ('0[xX]' + hexadecimal_digits_re) + ')';

      /**
       * Escape sequence supported in D string and character literals
       *
       * @type {String}
       */
      var escape_sequence_re = '\\\\(' + '[\'"\\?\\\\abfnrtv]|' + // common escapes
      'u[\\dA-Fa-f]{4}|' + // four hex digit unicode codepoint
      '[0-7]{1,3}|' + // one to three octal digit ascii char code
      'x[\\dA-Fa-f]{2}|' + // two hex digit ascii char code
      'U[\\dA-Fa-f]{8}' + // eight hex digit unicode codepoint
      ')|' + '&[a-zA-Z\\d]{2,};'; // named character entity

      /**
       * D integer number literals
       *
       * @type {Object}
       */


      /**
       * [D_FLOAT_MODE description]
       * @type {Object}
       */


      /**
       * D character literal
       *
       * @type {Object}
       */


      /**
       * D string escape sequence
       *
       * @type {Object}
       */


      /**
       * D double quoted string literal
       *
       * @type {Object}
       */


      /**
       * D wysiwyg and delimited string literals
       *
       * @type {Object}
       */


      /**
       * D alternate wysiwyg string literal
       *
       * @type {Object}
       */


      /**
       * D hexadecimal string literal
       *
       * @type {Object}
       */


      /**
       * D delimited string literal
       *
       * @type {Object}
       */


      /**
       * Hashbang support
       *
       * @type {Object}
       */


      /**
       * D special token sequence
       *
       * @type {Object}
       */


      /**
       * D attributes
       *
       * @type {Object}
       */


      /**
       * D nesting comment
       *
       * @type {Object}
       */
      var D_NESTING_COMMENT_MODE = hljs.COMMENT('\\/\\+', '\\+\\/', {
        contains: ['self'],
        relevance: 10
      });

      return {
        name: 'D',
        keywords: D_KEYWORDS,
        contains: [hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, D_NESTING_COMMENT_MODE, {
          className: 'string',
          begin: 'x"[\\da-fA-F\\s\\n\\r]*"[cwd]?',
          relevance: 10
        }, {
          className: 'string',
          begin: '"',
          contains: [{
            begin: escape_sequence_re,
            relevance: 0
          }],
          end: '"[cwd]?'
        }, {
          className: 'string',
          begin: '[rq]"',
          end: '"[cwd]?',
          relevance: 5
        }, {
          className: 'string',
          begin: '`',
          end: '`[cwd]?'
        }, {
          className: 'string',
          begin: 'q"\\{',
          end: '\\}"'
        }, {
          className: 'number',
          begin: '\\b(' + ('(' + ('(0[xX](' + hexadecimal_digits_re + '\\.' + hexadecimal_digits_re + '|' + '\\.?' + hexadecimal_digits_re + ')[pP][+-]?' + decimal_integer_nosus_re + ')') + '|' + ('(' + decimal_integer_nosus_re + '(\\.\\d*|' + decimal_exponent_re + ')|' + '\\d+\\.' + decimal_integer_nosus_re + decimal_integer_nosus_re + '|' + '\\.' + decimal_integer_re + decimal_exponent_re + '?' + ')') + ')') + '([fF]|L|i|[fF]i|Li)?|' + integer_re + '(i|[fF]i|Li)' + ')',
          relevance: 0
        }, {
          className: 'number',
          begin: '\\b' + integer_re + '(L|u|U|Lu|LU|uL|UL)?',
          relevance: 0
        }, {
          className: 'string',
          begin: '\'(' + escape_sequence_re + '|.)', end: '\'',
          illegal: '.'
        }, {
          className: 'meta',
          begin: '^#!',
          end: '$',
          relevance: 5
        }, {
          className: 'meta',
          begin: '#(line)',
          end: '$',
          relevance: 5
        }, {
          className: 'keyword',
          begin: '@[a-zA-Z_][a-zA-Z_\\d]*'
        }]
      };
    }

    module.exports = d;
  }
});
//# sourceMappingURL=d.js.map