Liferay.Loader.define('questions-web$highlight.js@10.1.0/lib/languages/flix', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        /*
         Language: Flix
         Category: functional
         Author: Magnus Madsen <mmadsen@uwaterloo.ca>
         Website: https://flix.dev/
         */

        function flix(hljs) {

            var CHAR = {
                className: 'string',
                begin: /'(.|\\[xXuU][a-zA-Z0-9]+)'/
            };

            var NAME = {
                className: 'title',
                begin: /[^0-9\n\t "'(),.`{}\[\]:;][^\n\t "'(),.`{}\[\]:;]+|[^0-9\n\t "'(),.`{}\[\]:;=]/
            };

            var METHOD = {
                className: 'function',
                beginKeywords: 'def',
                end: /[:={\[(\n;]/,
                excludeEnd: true,
                contains: [NAME]
            };

            return {
                name: 'Flix',
                keywords: {
                    literal: 'true false',
                    keyword: 'case class def else enum if impl import in lat rel index let match namespace switch type yield with'
                },
                contains: [hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, CHAR, {
                    className: 'string',
                    variants: [{
                        begin: '"', end: '"'
                    }]
                }, METHOD, hljs.C_NUMBER_MODE]
            };
        }

        module.exports = flix;
    }
});
//# sourceMappingURL=flix.js.map