Liferay.Loader.define('questions-web$highlight.js@10.1.0/lib/languages/latex', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    /*
    Language: LaTeX
    Author: Vladimir Moskva <vladmos@gmail.com>
    Website: https://www.latex-project.org
    Category: markup
    */

    function latex(hljs) {
      var COMMAND = {
        className: 'tag',
        begin: /\\/,
        relevance: 0,
        contains: [{
          className: 'name',
          variants: [{ begin: /[a-zA-Z\u0430-\u044f\u0410-\u042f]+[*]?/ }, { begin: /[^a-zA-Z\u0430-\u044f\u0410-\u042f0-9]/ }],
          starts: {
            endsWithParent: true,
            relevance: 0,
            contains: [{
              className: 'string', // because it looks like attributes in HTML tags
              variants: [{ begin: /\[/, end: /\]/ }, { begin: /\{/, end: /\}/ }]
            }, {
              begin: /\s*=\s*/, endsWithParent: true,
              relevance: 0,
              contains: [{
                className: 'number',
                begin: /-?\d*\.?\d+(pt|pc|mm|cm|in|dd|cc|ex|em)?/
              }]
            }]
          }
        }]
      };

      return {
        name: 'LaTeX',
        aliases: ['tex'],
        contains: [COMMAND, {
          className: 'formula',
          contains: [COMMAND],
          relevance: 0,
          variants: [{ begin: /\$\$/, end: /\$\$/ }, { begin: /\$/, end: /\$/ }]
        }, hljs.COMMENT('%', '$', {
          relevance: 0
        })]
      };
    }

    module.exports = latex;
  }
});
//# sourceMappingURL=latex.js.map