Liferay.Loader.define('questions-web$highlight.js@10.1.0/lib/languages/markdown', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    /*
    Language: Markdown
    Requires: xml.js
    Author: John Crepezzi <john.crepezzi@gmail.com>
    Website: https://daringfireball.net/projects/markdown/
    Category: common, markup
    */

    function markdown(hljs) {
      const INLINE_HTML = {
        begin: '<', end: '>',
        subLanguage: 'xml',
        relevance: 0
      };

      const LINK_REFERENCE = {
        begin: /^\[[^\n]+\]:/,
        returnBegin: true,
        contains: [{
          className: 'symbol',
          begin: /\[/, end: /\]/,
          excludeBegin: true, excludeEnd: true
        }, {
          className: 'link',
          begin: /:\s*/, end: /$/,
          excludeBegin: true
        }]
      };
      const LINK = {
        begin: '\\[.+?\\][\\(\\[].*?[\\)\\]]',
        returnBegin: true,
        contains: [{
          className: 'string',
          begin: '\\[', end: '\\]',
          excludeBegin: true,
          returnEnd: true,
          relevance: 0
        }, {
          className: 'link',
          begin: '\\]\\(', end: '\\)',
          excludeBegin: true, excludeEnd: true
        }, {
          className: 'symbol',
          begin: '\\]\\[', end: '\\]',
          excludeBegin: true, excludeEnd: true
        }],
        relevance: 10
      };
      const BOLD = {
        className: 'strong',
        contains: [],
        variants: [{ begin: /_{2}/, end: /_{2}/ }, { begin: /\*{2}/, end: /\*{2}/ }]
      };
      const ITALIC = {
        className: 'emphasis',
        contains: [],
        variants: [{ begin: /\*(?!\*)/, end: /\*/ }, { begin: /_(?!_)/, end: /_/, relevance: 0 }]
      };
      BOLD.contains.push(ITALIC);
      ITALIC.contains.push(BOLD);

      var CONTAINABLE = [INLINE_HTML, LINK];

      BOLD.contains = BOLD.contains.concat(CONTAINABLE);
      ITALIC.contains = ITALIC.contains.concat(CONTAINABLE);

      CONTAINABLE = CONTAINABLE.concat(BOLD, ITALIC);

      const HEADER = {
        className: 'section',
        variants: [{
          begin: '^#{1,6}',
          end: '$',
          contains: CONTAINABLE
        }, {
          begin: '(?=^.+?\\n[=-]{2,}$)',
          contains: [{ begin: '^[=-]*$' }, { begin: '^', end: "\\n", contains: CONTAINABLE }]
        }]
      };

      const BLOCKQUOTE = {
        className: 'quote',
        begin: '^>\\s+',
        contains: CONTAINABLE,
        end: '$'
      };

      return {
        name: 'Markdown',
        aliases: ['md', 'mkdown', 'mkd'],
        contains: [HEADER, INLINE_HTML, {
          className: 'bullet',
          begin: '^[ \t]*([*+-]|(\\d+\\.))(?=\\s+)',
          end: '\\s+',
          excludeEnd: true
        }, BOLD, ITALIC, BLOCKQUOTE, {
          className: 'code',
          variants: [
          // TODO: fix to allow these to work with sublanguage also
          { begin: '(`{3,})(.|\\n)*?\\1`*[ ]*' }, { begin: '(~{3,})(.|\\n)*?\\1~*[ ]*' },
          // needed to allow markdown as a sublanguage to work
          { begin: '```', end: '```+[ ]*$' }, { begin: '~~~', end: '~~~+[ ]*$' }, { begin: '`.+?`' }, {
            begin: '(?=^( {4}|\\t))',
            // use contains to gobble up multiple lines to allow the block to be whatever size
            // but only have a single open/close tag vs one per line
            contains: [{ begin: '^( {4}|\\t)', end: '(\\n)$' }],
            relevance: 0
          }]
        }, {
          begin: '^[-\\*]{3,}', end: '$'
        }, LINK, LINK_REFERENCE]
      };
    }

    module.exports = markdown;
  }
});
//# sourceMappingURL=markdown.js.map