Liferay.Loader.define('questions-web$highlight.js@10.1.0/lib/languages/nix', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    /*
    Language: Nix
    Author: Domen Kožar <domen@dev.si>
    Description: Nix functional language
    Website: http://nixos.org/nix
    */

    function nix(hljs) {
      var NIX_KEYWORDS = {
        keyword: 'rec with let in inherit assert if else then',
        literal: 'true false or and null',
        built_in: 'import abort baseNameOf dirOf isNull builtins map removeAttrs throw ' + 'toString derivation'
      };
      var ANTIQUOTE = {
        className: 'subst',
        begin: /\$\{/,
        end: /}/,
        keywords: NIX_KEYWORDS
      };
      var ATTRS = {
        begin: /[a-zA-Z0-9-_]+(\s*=)/, returnBegin: true,
        relevance: 0,
        contains: [{
          className: 'attr',
          begin: /\S+/
        }]
      };

      var EXPRESSIONS = [hljs.NUMBER_MODE, hljs.HASH_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, {
        className: 'string',
        contains: [ANTIQUOTE],
        variants: [{ begin: "''", end: "''" }, { begin: '"', end: '"' }]
      }, ATTRS];
      ANTIQUOTE.contains = EXPRESSIONS;
      return {
        name: 'Nix',
        aliases: ["nixos"],
        keywords: NIX_KEYWORDS,
        contains: EXPRESSIONS
      };
    }

    module.exports = nix;
  }
});
//# sourceMappingURL=nix.js.map