Liferay.Loader.define('questions-web$highlight.js@10.1.0/lib/languages/php', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    /*
    Language: PHP
    Author: Victor Karamzin <Victor.Karamzin@enterra-inc.com>
    Contributors: Evgeny Stepanischev <imbolk@gmail.com>, Ivan Sagalaev <maniac@softwaremaniacs.org>
    Website: https://www.php.net
    Category: common
    */

    function php(hljs) {
      var VARIABLE = {
        begin: '\\$+[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*'
      };
      var PREPROCESSOR = {
        className: 'meta',
        variants: [{ begin: /<\?php/, relevance: 10 }, // boost for obvious PHP
        { begin: /<\?[=]?/ }, { begin: /\?>/ // end php tag
        }]
      };
      var STRING = {
        className: 'string',
        contains: [hljs.BACKSLASH_ESCAPE, PREPROCESSOR],
        variants: [{
          begin: 'b"', end: '"'
        }, {
          begin: 'b\'', end: '\''
        }, hljs.inherit(hljs.APOS_STRING_MODE, { illegal: null }), hljs.inherit(hljs.QUOTE_STRING_MODE, { illegal: null })]
      };
      var NUMBER = { variants: [hljs.BINARY_NUMBER_MODE, hljs.C_NUMBER_MODE] };
      var KEYWORDS = {
        keyword:
        // Magic constants:
        // <https://www.php.net/manual/en/language.constants.predefined.php>
        '__CLASS__ __DIR__ __FILE__ __FUNCTION__ __LINE__ __METHOD__ __NAMESPACE__ __TRAIT__ ' +
        // Function that look like language construct or language construct that look like function:
        // List of keywords that may not require parenthesis
        'die echo exit include include_once print require require_once ' +
        // These are not language construct (function) but operate on the currently-executing function and can access the current symbol table
        // 'compact extract func_get_arg func_get_args func_num_args get_called_class get_parent_class ' +
        // Other keywords:
        // <https://www.php.net/manual/en/reserved.php>
        // <https://www.php.net/manual/en/language.types.type-juggling.php>
        'array abstract and as binary bool boolean break callable case catch class clone const continue declare default do double else elseif empty enddeclare endfor endforeach endif endswitch endwhile eval extends final finally float for foreach from global goto if implements instanceof insteadof int integer interface isset iterable list new object or private protected public real return string switch throw trait try unset use var void while xor yield',
        literal: 'false null true',
        built_in:
        // Standard PHP library:
        // <https://www.php.net/manual/en/book.spl.php>
        'Error|0 ' + // error is too common a name esp since PHP is case in-sensitive
        'AppendIterator ArgumentCountError ArithmeticError ArrayIterator ArrayObject AssertionError BadFunctionCallException BadMethodCallException CachingIterator CallbackFilterIterator CompileError Countable DirectoryIterator DivisionByZeroError DomainException EmptyIterator ErrorException Exception FilesystemIterator FilterIterator GlobIterator InfiniteIterator InvalidArgumentException IteratorIterator LengthException LimitIterator LogicException MultipleIterator NoRewindIterator OutOfBoundsException OutOfRangeException OuterIterator OverflowException ParentIterator ParseError RangeException RecursiveArrayIterator RecursiveCachingIterator RecursiveCallbackFilterIterator RecursiveDirectoryIterator RecursiveFilterIterator RecursiveIterator RecursiveIteratorIterator RecursiveRegexIterator RecursiveTreeIterator RegexIterator RuntimeException SeekableIterator SplDoublyLinkedList SplFileInfo SplFileObject SplFixedArray SplHeap SplMaxHeap SplMinHeap SplObjectStorage SplObserver SplObserver SplPriorityQueue SplQueue SplStack SplSubject SplSubject SplTempFileObject TypeError UnderflowException UnexpectedValueException ' +
        // Reserved interfaces:
        // <https://www.php.net/manual/en/reserved.interfaces.php>
        'ArrayAccess Closure Generator Iterator IteratorAggregate Serializable Throwable Traversable WeakReference ' +
        // Reserved classes:
        // <https://www.php.net/manual/en/reserved.classes.php>
        'Directory __PHP_Incomplete_Class parent php_user_filter self static stdClass'
      };
      return {
        aliases: ['php', 'php3', 'php4', 'php5', 'php6', 'php7'],
        case_insensitive: true,
        keywords: KEYWORDS,
        contains: [hljs.HASH_COMMENT_MODE, hljs.COMMENT('//', '$', { contains: [PREPROCESSOR] }), hljs.COMMENT('/\\*', '\\*/', {
          contains: [{
            className: 'doctag',
            begin: '@[A-Za-z]+'
          }]
        }), hljs.COMMENT('__halt_compiler.+?;', false, {
          endsWithParent: true,
          keywords: '__halt_compiler'
        }), {
          className: 'string',
          begin: /<<<['"]?\w+['"]?$/, end: /^\w+;?$/,
          contains: [hljs.BACKSLASH_ESCAPE, {
            className: 'subst',
            variants: [{ begin: /\$\w+/ }, { begin: /\{\$/, end: /\}/ }]
          }]
        }, PREPROCESSOR, {
          className: 'keyword', begin: /\$this\b/
        }, VARIABLE, {
          // swallow composed identifiers to avoid parsing them as keywords
          begin: /(::|->)+[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*/
        }, {
          className: 'function',
          beginKeywords: 'fn function', end: /[;{]/, excludeEnd: true,
          illegal: '[$%\\[]',
          contains: [hljs.UNDERSCORE_TITLE_MODE, {
            className: 'params',
            begin: '\\(', end: '\\)',
            excludeBegin: true,
            excludeEnd: true,
            keywords: KEYWORDS,
            contains: ['self', VARIABLE, hljs.C_BLOCK_COMMENT_MODE, STRING, NUMBER]
          }]
        }, {
          className: 'class',
          beginKeywords: 'class interface', end: '{', excludeEnd: true,
          illegal: /[:\(\$"]/,
          contains: [{ beginKeywords: 'extends implements' }, hljs.UNDERSCORE_TITLE_MODE]
        }, {
          beginKeywords: 'namespace', end: ';',
          illegal: /[\.']/,
          contains: [hljs.UNDERSCORE_TITLE_MODE]
        }, {
          beginKeywords: 'use', end: ';',
          contains: [hljs.UNDERSCORE_TITLE_MODE]
        }, {
          begin: '=>' // No markup, just a relevance booster
        }, STRING, NUMBER]
      };
    }

    module.exports = php;
  }
});
//# sourceMappingURL=php.js.map