Liferay.Loader.define('questions-web$highlight.js@10.1.0/lib/languages/protobuf', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    /*
    Language: Protocol Buffers
    Author: Dan Tao <daniel.tao@gmail.com>
    Description: Protocol buffer message definition format
    Website: https://developers.google.com/protocol-buffers/docs/proto3
    Category: protocols
    */

    function protobuf(hljs) {
      return {
        name: 'Protocol Buffers',
        keywords: {
          keyword: 'package import option optional required repeated group oneof',
          built_in: 'double float int32 int64 uint32 uint64 sint32 sint64 ' + 'fixed32 fixed64 sfixed32 sfixed64 bool string bytes',
          literal: 'true false'
        },
        contains: [hljs.QUOTE_STRING_MODE, hljs.NUMBER_MODE, hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, {
          className: 'class',
          beginKeywords: 'message enum service', end: /\{/,
          illegal: /\n/,
          contains: [hljs.inherit(hljs.TITLE_MODE, {
            starts: { endsWithParent: true, excludeEnd: true // hack: eating everything after the first title
            } })]
        }, {
          className: 'function',
          beginKeywords: 'rpc',
          end: /[{;]/, excludeEnd: true,
          keywords: 'rpc returns'
        }, {
          begin: /^\s*[A-Z_]+/,
          end: /\s*=/, excludeEnd: true
        }]
      };
    }

    module.exports = protobuf;
  }
});
//# sourceMappingURL=protobuf.js.map