Liferay.Loader.define('questions-web$highlight.js@10.1.0/lib/languages/step21', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    /*
    Language: STEP Part 21
    Contributors: Adam Joseph Cook <adam.joseph.cook@gmail.com>
    Description: Syntax highlighter for STEP Part 21 files (ISO 10303-21).
    Website: https://en.wikipedia.org/wiki/ISO_10303-21
    */

    function step21(hljs) {

      return {
        name: 'STEP Part 21',
        aliases: ['p21', 'step', 'stp'],
        case_insensitive: true, // STEP 21 is case insensitive in theory, in practice all non-comments are capitalized.
        keywords: {
          $pattern: '[A-Z_][A-Z0-9_.]*',
          keyword: 'HEADER ENDSEC DATA'
        },
        contains: [{
          className: 'meta',
          begin: 'ISO-10303-21;',
          relevance: 10
        }, {
          className: 'meta',
          begin: 'END-ISO-10303-21;',
          relevance: 10
        }, hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, hljs.COMMENT('/\\*\\*!', '\\*/'), hljs.C_NUMBER_MODE, hljs.inherit(hljs.APOS_STRING_MODE, { illegal: null }), hljs.inherit(hljs.QUOTE_STRING_MODE, { illegal: null }), {
          className: 'string',
          begin: "'", end: "'"
        }, {
          className: 'symbol',
          variants: [{
            begin: '#', end: '\\d+',
            illegal: '\\W'
          }]
        }]
      };
    }

    module.exports = step21;
  }
});
//# sourceMappingURL=step21.js.map