Liferay.Loader.define('questions-web$highlight.js@10.1.0/lib/languages/yaml', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    /*
    Language: YAML
    Description: Yet Another Markdown Language
    Author: Stefan Wienert <stwienert@gmail.com>
    Contributors: Carl Baxter <carl@cbax.tech>
    Requires: ruby.js
    Website: https://yaml.org
    Category: common, config
    */
    function yaml(hljs) {
      var LITERALS = 'true false yes no null';

      // YAML spec allows non-reserved URI characters in tags.
      var URI_CHARACTERS = '[\\w#;/?:@&=+$,.~*\\\'()[\\]]+';

      // Define keys as starting with a word character
      // ...containing word chars, spaces, colons, forward-slashes, hyphens and periods
      // ...and ending with a colon followed immediately by a space, tab or newline.
      // The YAML spec allows for much more than this, but this covers most use-cases.

      var STRING = {
        className: 'string',
        relevance: 0,
        variants: [{ begin: /'/, end: /'/ }, { begin: /"/, end: /"/ }, { begin: /\S+/ }],
        contains: [hljs.BACKSLASH_ESCAPE, {
          className: 'template-variable',
          variants: [{ begin: '{{', end: '}}' }, // jinja templates Ansible
          { begin: '%{', end: '}' // Ruby i18n
          }]
        }]
      };

      // Strings inside of value containers (objects) can't contain braces,
      // brackets, or commas
      var CONTAINER_STRING = hljs.inherit(STRING, {
        variants: [{ begin: /'/, end: /'/ }, { begin: /"/, end: /"/ }, { begin: /[^\s,{}[\]]+/ }]
      });

      var VALUE_CONTAINER = {
        end: ',',
        endsWithParent: true,
        excludeEnd: true,
        contains: [],
        keywords: LITERALS,
        relevance: 0
      };


      var MODES = [{
        className: 'attr',
        variants: [{ begin: '\\w[\\w :\\/.-]*:(?=[ \t]|$)' }, { begin: '"\\w[\\w :\\/.-]*":(?=[ \t]|$)' }, // double quoted keys
        { begin: '\'\\w[\\w :\\/.-]*\':(?=[ \t]|$)' // single quoted keys
        }]
      }, {
        className: 'meta',
        begin: '^---\s*$',
        relevance: 10
      }, { // multi line string
        // Blocks start with a | or > followed by a newline
        //
        // Indentation of subsequent lines must be the same to
        // be considered part of the block
        className: 'string',
        begin: '[\\|>]([0-9]?[+-])?[ ]*\\n( *)[\\S ]+\\n(\\2[\\S ]+\\n?)*'
      }, { // Ruby/Rails erb
        begin: '<%[%=-]?',
        end: '[%-]?%>',
        subLanguage: 'ruby',
        excludeBegin: true,
        excludeEnd: true,
        relevance: 0
      }, { // named tags
        className: 'type',
        begin: '!\\w+!' + URI_CHARACTERS
      },
      // https://yaml.org/spec/1.2/spec.html#id2784064
      { // verbatim tags
        className: 'type',
        begin: '!<' + URI_CHARACTERS + ">"
      }, { // primary tags
        className: 'type',
        begin: '!' + URI_CHARACTERS
      }, { // secondary tags
        className: 'type',
        begin: '!!' + URI_CHARACTERS
      }, { // fragment id &ref
        className: 'meta',
        begin: '&' + hljs.UNDERSCORE_IDENT_RE + '$'
      }, { // fragment reference *ref
        className: 'meta',
        begin: '\\*' + hljs.UNDERSCORE_IDENT_RE + '$'
      }, { // array listing
        className: 'bullet',
        // TODO: remove |$ hack when we have proper look-ahead support
        begin: '\\-(?=[ ]|$)',
        relevance: 0
      }, hljs.HASH_COMMENT_MODE, {
        beginKeywords: LITERALS,
        keywords: { literal: LITERALS }
      }, {
        className: 'number',
        begin: '\\b' + '[0-9]{4}(-[0-9][0-9]){0,2}' + '([Tt \\t][0-9][0-9]?(:[0-9][0-9]){2})?' + '(\\.[0-9]*)?' + '([ \\t])*(Z|[-+][0-9][0-9]?(:[0-9][0-9])?)?' + '\\b'
      },
      // numbers are any valid C-style number that
      // sit isolated from other words
      {
        className: 'number',
        begin: hljs.C_NUMBER_RE + '\\b'
      }, {
        begin: '{',
        end: '}',
        contains: [VALUE_CONTAINER],
        illegal: '\\n',
        relevance: 0
      }, {
        begin: '\\[',
        end: '\\]',
        contains: [VALUE_CONTAINER],
        illegal: '\\n',
        relevance: 0
      }, STRING];

      var VALUE_MODES = [...MODES];
      VALUE_MODES.pop();
      VALUE_MODES.push(CONTAINER_STRING);
      VALUE_CONTAINER.contains = VALUE_MODES;

      return {
        name: 'YAML',
        case_insensitive: true,
        aliases: ['yml', 'YAML'],
        contains: MODES
      };
    }

    module.exports = yaml;
  }
});
//# sourceMappingURL=yaml.js.map