'use strict';

Liferay.Loader.define('questions-web$ts-invariant@0.4.4/lib/invariant', ['module', 'exports', 'require', 'questions-web$tslib'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        Object.defineProperty(exports, '__esModule', { value: true });

        var tslib = require('questions-web$tslib');

        var genericMessage = "Invariant Violation";
        var _a = Object.setPrototypeOf,
            setPrototypeOf = _a === void 0 ? function (obj, proto) {
            obj.__proto__ = proto;
            return obj;
        } : _a;
        var InvariantError = /** @class */function (_super) {
            tslib.__extends(InvariantError, _super);
            function InvariantError(message) {
                if (message === void 0) {
                    message = genericMessage;
                }
                var _this = _super.call(this, typeof message === "number" ? genericMessage + ": " + message + " (see https://github.com/apollographql/invariant-packages)" : message) || this;
                _this.framesToPop = 1;
                _this.name = genericMessage;
                setPrototypeOf(_this, InvariantError.prototype);
                return _this;
            }
            return InvariantError;
        }(Error);
        function invariant(condition, message) {
            if (!condition) {
                throw new InvariantError(message);
            }
        }
        function wrapConsoleMethod(method) {
            return function () {
                return console[method].apply(console, arguments);
            };
        }
        (function (invariant) {
            invariant.warn = wrapConsoleMethod("warn");
            invariant.error = wrapConsoleMethod("error");
        })(invariant || (invariant = {}));
        // Code that uses ts-invariant with rollup-plugin-invariant may want to
        // import this process stub to avoid errors evaluating process.env.NODE_ENV.
        // However, because most ESM-to-CJS compilers will rewrite the process import
        // as tsInvariant.process, which prevents proper replacement by minifiers, we
        // also attempt to define the stub globally when it is not already defined.
        exports.process = { env: {} };
        if (typeof process === "object") {
            exports.process = process;
        } else try {
            // Using Function to evaluate this assignment in global scope also escapes
            // the strict mode of the current module, thereby allowing the assignment.
            // Inspired by https://github.com/facebook/regenerator/pull/369.
            Function("stub", "process = stub")(exports.process);
        } catch (atLeastWeTried) {
            // The assignment can fail if a Content Security Policy heavy-handedly
            // forbids Function usage. In those environments, developers should take
            // extra care to replace process.env.NODE_ENV in their production builds,
            // or define an appropriate global.process polyfill.
        }
        var invariant$1 = invariant;

        exports.default = invariant$1;
        exports.InvariantError = InvariantError;
        exports.invariant = invariant;
        //# sourceMappingURL=invariant.js.map
    }
});
//# sourceMappingURL=invariant.js.map