/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ratings.test.util;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.test.rule.Inject;
import com.liferay.ratings.kernel.exception.NoSuchStatsException;
import com.liferay.ratings.kernel.model.RatingsStats;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.ratings.test.util.RatingsTestUtil;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseRatingsTestCase {
    @DeleteAfterTestRun
    protected Group group;
    @Inject
    private RatingsStatsLocalService _ratingsStatsLocalService;

    @Before
    public void setUp() throws Exception {
        this.group = GroupTestUtil.addGroup();
    }

    @Test(expected=NoSuchStatsException.class)
    public void testDeleteRatings() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> baseModel = this.addBaseModel(this.getParentBaseModel(this.group, serviceContext), serviceContext);
        Class<?> clazz = this.getBaseModelClass();
        RatingsStats ratingsStats = RatingsTestUtil.addStats(clazz.getName(), this.getRatingsClassPK((ClassedModel)baseModel));
        this.deleteBaseModel(baseModel, serviceContext);
        this._ratingsStatsLocalService.getRatingsStats(ratingsStats.getStatsId());
    }

    protected abstract BaseModel<?> addBaseModel(BaseModel<?> var1, ServiceContext var2) throws Exception;

    protected abstract BaseModel<?> deleteBaseModel(BaseModel<?> var1, ServiceContext var2) throws Exception;

    protected abstract Class<?> getBaseModelClass();

    protected BaseModel<?> getParentBaseModel(Group group, ServiceContext serviceContext) throws Exception {
        return group;
    }

    protected long getRatingsClassPK(ClassedModel classedModel) {
        return (Long)classedModel.getPrimaryKeyObj();
    }
}

