/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.reading.time.web.internal.message;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.reading.time.message.ReadingTimeMessageProvider;
import com.liferay.reading.time.model.ReadingTimeEntry;
import java.time.Duration;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"display.style=simple"})
public class SimpleReadingTimeMessageProviderImpl
implements ReadingTimeMessageProvider {
    public String provide(Duration readingTimeDuration, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)locale, SimpleReadingTimeMessageProviderImpl.class);
        long readingTimeInMinutes = readingTimeDuration.toMinutes();
        if (readingTimeInMinutes == 0L) {
            readingTimeInMinutes = 1L;
        }
        return LanguageUtil.format((ResourceBundle)resourceBundle, (String)(readingTimeInMinutes == 1L ? "x-minute" : "x-minutes"), (Object)readingTimeInMinutes);
    }

    public String provide(ReadingTimeEntry readingTimeEntry, Locale locale) {
        return this.provide(Duration.ofMillis(readingTimeEntry.getReadingTime()), locale);
    }
}

