/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.redirect.internal.configuration.admin.service;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.redirect.internal.configuration.RedirectURLConfiguration;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.redirect.internal.configuration.RedirectURLConfiguration"}, immediate=true, property={"service.pid=com.liferay.redirect.internal.configuration.RedirectURLConfiguration.scoped"}, service={ManagedServiceFactory.class, RedirectURLManagedServiceFactory.class})
public class RedirectURLManagedServiceFactory
implements ManagedServiceFactory {
    private final Map<Long, RedirectURLConfiguration> _companyConfigurationBeans = new ConcurrentHashMap<Long, RedirectURLConfiguration>();
    private final Map<String, Long> _pidCompanyIdMapping = new ConcurrentHashMap<String, Long>();
    private volatile RedirectURLConfiguration _systemRedirectURLConfiguration;

    public void deleted(String pid) {
        this._unmapPid(pid);
    }

    public RedirectURLConfiguration getCompanyRedirectURLConfiguration(long companyId) {
        if (this._companyConfigurationBeans.containsKey(companyId)) {
            return this._companyConfigurationBeans.get(companyId);
        }
        return this._systemRedirectURLConfiguration;
    }

    public String getName() {
        return "com.liferay.redirect.internal.configuration.RedirectURLConfiguration.scoped";
    }

    public void updated(String pid, Dictionary dictionary) throws ConfigurationException {
        this._unmapPid(pid);
        long companyId = GetterUtil.getLong(dictionary.get("companyId"), (long)0L);
        if (companyId != 0L) {
            this._pidCompanyIdMapping.put(pid, companyId);
            this._companyConfigurationBeans.put(companyId, (RedirectURLConfiguration)ConfigurableUtil.createConfigurable(RedirectURLConfiguration.class, (Dictionary)dictionary));
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._systemRedirectURLConfiguration = (RedirectURLConfiguration)ConfigurableUtil.createConfigurable(RedirectURLConfiguration.class, properties);
    }

    private void _unmapPid(String pid) {
        if (this._pidCompanyIdMapping.containsKey(pid)) {
            long companyId = this._pidCompanyIdMapping.remove(pid);
            this._companyConfigurationBeans.remove(companyId);
        }
    }
}

