/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.redirect.internal.messaging;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.redirect.internal.configuration.RedirectConfiguration;
import com.liferay.redirect.service.RedirectNotFoundEntryLocalService;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.redirect.internal.configuration.RedirectConfiguration"}, immediate=true, service={MessageListener.class})
public class CheckRedirectNotFoundEntriesMessageListener
extends BaseMessageListener {
    private volatile RedirectConfiguration _redirectConfiguration;
    @Reference
    private RedirectNotFoundEntryLocalService _redirectNotFoundEntryLocalService;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._redirectConfiguration = (RedirectConfiguration)ConfigurableUtil.createConfigurable(RedirectConfiguration.class, properties);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, this._redirectConfiguration.checkRedirectNotFoundEntriesInterval(), TimeUnit.HOUR);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        this._removeMaximumOverflowRedirectNotFoundEntries();
        this._removeOldRedirectNotFoundEntries();
    }

    private void _removeMaximumOverflowRedirectNotFoundEntries() throws Exception {
        int maximumNumberOfRedirectNotFoundEntries;
        int redirectNotFoundEntriesCount = this._redirectNotFoundEntryLocalService.getRedirectNotFoundEntriesCount();
        if (redirectNotFoundEntriesCount < (maximumNumberOfRedirectNotFoundEntries = this._redirectConfiguration.maximumNumberOfRedirectNotFoundEntries())) {
            return;
        }
        ActionableDynamicQuery actionableDynamicQuery = this._redirectNotFoundEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.setLimit(maximumNumberOfRedirectNotFoundEntries, redirectNotFoundEntriesCount));
        actionableDynamicQuery.setAddOrderCriteriaMethod(dynamicQuery -> dynamicQuery.addOrder(OrderFactoryUtil.desc((String)"modifiedDate")));
        actionableDynamicQuery.setPerformActionMethod(arg_0 -> ((RedirectNotFoundEntryLocalService)this._redirectNotFoundEntryLocalService).deleteRedirectNotFoundEntry(arg_0));
        actionableDynamicQuery.performActions();
    }

    private void _removeOldRedirectNotFoundEntries() throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._redirectNotFoundEntryLocalService.getActionableDynamicQuery();
        int redirectNotFoundEntryMaxAge = this._redirectConfiguration.redirectNotFoundEntryMaxAge();
        Date thresholdDate = new Date(System.currentTimeMillis() - (long)redirectNotFoundEntryMaxAge * 86400000L);
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.lt((String)"modifiedDate", (Object)thresholdDate)));
        actionableDynamicQuery.setPerformActionMethod(arg_0 -> ((RedirectNotFoundEntryLocalService)this._redirectNotFoundEntryLocalService).deleteRedirectNotFoundEntry(arg_0));
        actionableDynamicQuery.performActions();
    }
}

