/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.redirect.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.kernel.search.query.FieldQueryFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.query.QueryHelper;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.redirect.model.RedirectNotFoundEntry"}, service={KeywordQueryContributor.class})
public class RedirectNotFoundEntryKeywordQueryContributor
implements KeywordQueryContributor {
    @Reference
    protected FieldQueryFactory fieldQueryFactory;
    @Reference
    private QueryHelper _queryHelper;

    public void contribute(String keywords, BooleanQuery booleanQuery, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        try {
            SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
            this._queryHelper.addSearchTerm(booleanQuery, searchContext, "url", false);
            String groupBaseURL = (String)((Object)searchContext.getAttribute("groupBaseURL"));
            if (Validator.isNotNull((String)keywords)) {
                booleanQuery.add((Query)this._getMatchQuery("urlParts", keywords), BooleanClauseOccur.SHOULD);
                booleanQuery.add((Query)new MatchQuery("urlParts", keywords), BooleanClauseOccur.SHOULD);
            }
            if (Validator.isNotNull((String)groupBaseURL) && Validator.isNotNull((String)keywords) && keywords.startsWith(groupBaseURL)) {
                Query query = this.fieldQueryFactory.createQuery("url", StringUtil.removeSubstring((String)keywords, (String)groupBaseURL), false, false);
                booleanQuery.add(query, BooleanClauseOccur.SHOULD);
            }
        }
        catch (ParseException parseException) {
            throw new SystemException((Throwable)parseException);
        }
    }

    private MatchQuery _getMatchQuery(String field, String keywords) {
        MatchQuery sourceURLPartsMatchQuery = new MatchQuery(field, keywords);
        sourceURLPartsMatchQuery.setType(MatchQuery.Type.PHRASE_PREFIX);
        return sourceURLPartsMatchQuery;
    }
}

