/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.redirect.internal.security.permission.resource;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.redirect.model.RedirectEntry;
import com.liferay.redirect.service.RedirectEntryLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.redirect.model.RedirectEntry"}, service={ModelResourcePermission.class})
public class RedirectEntryModelResourcePermission
implements ModelResourcePermission<RedirectEntry> {
    @Reference(target="(resource.name=com.liferay.redirect)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private RedirectEntryLocalService _redirectEntryLocalService;

    public void check(PermissionChecker permissionChecker, long redirectEntryId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, redirectEntryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, RedirectEntry.class.getName(), redirectEntryId, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, RedirectEntry redirectEntry, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, redirectEntry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, RedirectEntry.class.getName(), redirectEntry.getRedirectEntryId(), new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long redirectEntryId, String actionId) throws PortalException {
        return this._contains(permissionChecker, this._redirectEntryLocalService.getRedirectEntry(redirectEntryId), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, RedirectEntry redirectEntry, String actionId) {
        return this._contains(permissionChecker, redirectEntry, actionId);
    }

    public String getModelName() {
        return RedirectEntry.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }

    private boolean _contains(PermissionChecker permissionChecker, RedirectEntry redirectEntry, String actionId) {
        if (permissionChecker.hasOwnerPermission(redirectEntry.getCompanyId(), RedirectEntry.class.getName(), redirectEntry.getRedirectEntryId(), redirectEntry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(redirectEntry.getGroupId(), RedirectEntry.class.getName(), redirectEntry.getRedirectEntryId(), actionId);
    }
}

