/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.redirect.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.redirect.model.RedirectEntry;
import com.liferay.redirect.service.RedirectEntryServiceUtil;
import java.util.Date;
import java.util.List;

public class RedirectEntryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(RedirectEntryServiceHttp.class);
    private static final Class<?>[] _addRedirectEntryParameterTypes0 = new Class[]{Long.TYPE, String.class, Date.class, Boolean.TYPE, String.class, ServiceContext.class};
    private static final Class<?>[] _addRedirectEntryParameterTypes1 = new Class[]{Long.TYPE, String.class, Date.class, String.class, Boolean.TYPE, String.class, Boolean.TYPE, ServiceContext.class};
    private static final Class<?>[] _deleteRedirectEntryParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _fetchRedirectEntryParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getRedirectEntriesParameterTypes4 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getRedirectEntriesCountParameterTypes5 = new Class[]{Long.TYPE};
    private static final Class<?>[] _updateRedirectEntryParameterTypes6 = new Class[]{Long.TYPE, String.class, Date.class, Boolean.TYPE, String.class};
    private static final Class<?>[] _updateRedirectEntryParameterTypes7 = new Class[]{Long.TYPE, String.class, Date.class, String.class, Boolean.TYPE, String.class, Boolean.TYPE};

    public static RedirectEntry addRedirectEntry(HttpPrincipal httpPrincipal, long groupId, String destinationURL, Date expirationDate, boolean permanent, String sourceURL, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RedirectEntryServiceUtil.class, "addRedirectEntry", (Class[])_addRedirectEntryParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, destinationURL, expirationDate, permanent, sourceURL, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (RedirectEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static RedirectEntry addRedirectEntry(HttpPrincipal httpPrincipal, long groupId, String destinationURL, Date expirationDate, String groupBaseURL, boolean permanent, String sourceURL, boolean updateChainedRedirectEntries, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RedirectEntryServiceUtil.class, "addRedirectEntry", (Class[])_addRedirectEntryParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, destinationURL, expirationDate, groupBaseURL, permanent, sourceURL, updateChainedRedirectEntries, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (RedirectEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static RedirectEntry deleteRedirectEntry(HttpPrincipal httpPrincipal, long redirectEntryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RedirectEntryServiceUtil.class, "deleteRedirectEntry", (Class[])_deleteRedirectEntryParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{redirectEntryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (RedirectEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static RedirectEntry fetchRedirectEntry(HttpPrincipal httpPrincipal, long redirectEntryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RedirectEntryServiceUtil.class, "fetchRedirectEntry", (Class[])_fetchRedirectEntryParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{redirectEntryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (RedirectEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<RedirectEntry> getRedirectEntries(HttpPrincipal httpPrincipal, long groupId, int start, int end, OrderByComparator<RedirectEntry> orderByComparator) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RedirectEntryServiceUtil.class, "getRedirectEntries", (Class[])_getRedirectEntriesParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getRedirectEntriesCount(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RedirectEntryServiceUtil.class, "getRedirectEntriesCount", (Class[])_getRedirectEntriesCountParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static RedirectEntry updateRedirectEntry(HttpPrincipal httpPrincipal, long redirectEntryId, String destinationURL, Date expirationDate, boolean permanent, String sourceURL) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RedirectEntryServiceUtil.class, "updateRedirectEntry", (Class[])_updateRedirectEntryParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{redirectEntryId, destinationURL, expirationDate, permanent, sourceURL});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (RedirectEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static RedirectEntry updateRedirectEntry(HttpPrincipal httpPrincipal, long redirectEntryId, String destinationURL, Date expirationDate, String groupBaseURL, boolean permanent, String sourceURL, boolean updateChainedRedirectEntries) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RedirectEntryServiceUtil.class, "updateRedirectEntry", (Class[])_updateRedirectEntryParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{redirectEntryId, destinationURL, expirationDate, groupBaseURL, permanent, sourceURL, updateChainedRedirectEntries});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (RedirectEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

