/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.redirect.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.LayoutFriendlyURLException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.redirect.exception.CircularRedirectEntryException;
import com.liferay.redirect.exception.DuplicateRedirectEntrySourceURLException;
import com.liferay.redirect.exception.RequiredRedirectEntryDestinationURLException;
import com.liferay.redirect.exception.RequiredRedirectEntrySourceURLException;
import com.liferay.redirect.model.RedirectEntry;
import com.liferay.redirect.model.RedirectNotFoundEntry;
import com.liferay.redirect.service.RedirectNotFoundEntryLocalService;
import com.liferay.redirect.service.base.RedirectEntryLocalServiceBaseImpl;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.redirect.model.RedirectEntry"}, service={AopService.class})
public class RedirectEntryLocalServiceImpl
extends RedirectEntryLocalServiceBaseImpl {
    @Reference
    private RedirectNotFoundEntryLocalService _redirectNotFoundEntryLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;

    public void addEntryResources(RedirectEntry entry, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this._resourceLocalService.addResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), RedirectEntry.class.getName(), entry.getRedirectEntryId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addEntryResources(RedirectEntry entry, ModelPermissions modelPermissions) throws PortalException {
        this._resourceLocalService.addModelResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), RedirectEntry.class.getName(), entry.getRedirectEntryId(), modelPermissions);
    }

    @Indexable(type=IndexableType.REINDEX)
    public RedirectEntry addRedirectEntry(long groupId, String destinationURL, Date expirationDate, boolean permanent, String sourceURL, ServiceContext serviceContext) throws PortalException {
        this._validate(destinationURL, sourceURL);
        if (this.redirectEntryPersistence.fetchByG_S(groupId, sourceURL) != null) {
            throw new DuplicateRedirectEntrySourceURLException();
        }
        RedirectEntry redirectEntry = this.redirectEntryPersistence.create(this.counterLocalService.increment());
        redirectEntry.setUuid(serviceContext.getUuid());
        redirectEntry.setGroupId(groupId);
        redirectEntry.setCompanyId(serviceContext.getCompanyId());
        redirectEntry.setUserId(serviceContext.getUserId());
        redirectEntry.setDestinationURL(destinationURL);
        redirectEntry.setExpirationDate(expirationDate);
        redirectEntry.setPermanent(permanent);
        redirectEntry.setSourceURL(sourceURL);
        redirectEntry = (RedirectEntry)this.redirectEntryPersistence.update((BaseModel)redirectEntry);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addEntryResources(redirectEntry, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addEntryResources(redirectEntry, serviceContext.getModelPermissions());
        }
        RedirectNotFoundEntry redirectNotFoundEntry = this._redirectNotFoundEntryLocalService.fetchRedirectNotFoundEntry(groupId, sourceURL);
        if (redirectNotFoundEntry != null) {
            this._redirectNotFoundEntryLocalService.deleteRedirectNotFoundEntry(redirectNotFoundEntry);
        }
        return redirectEntry;
    }

    @Indexable(type=IndexableType.REINDEX)
    public RedirectEntry addRedirectEntry(long groupId, String destinationURL, Date expirationDate, String groupBaseURL, boolean permanent, String sourceURL, boolean updateChainedRedirectEntries, ServiceContext serviceContext) throws PortalException {
        this._checkDestinationURLMustNotBeEqualToSourceURL(destinationURL, groupBaseURL, sourceURL);
        RedirectEntry redirectEntry = this.addRedirectEntry(groupId, destinationURL, expirationDate, permanent, sourceURL, serviceContext);
        this._checkChainedRedirectEntries(groupBaseURL, redirectEntry);
        if (updateChainedRedirectEntries) {
            redirectEntry = this._updateChainedRedirectEntries(groupBaseURL, redirectEntry);
        }
        return redirectEntry;
    }

    public RedirectEntry fetchRedirectEntry(long groupId, String sourceURL) {
        return this.redirectEntryLocalService.fetchRedirectEntry(groupId, sourceURL, false);
    }

    public RedirectEntry fetchRedirectEntry(long groupId, String sourceURL, boolean updateLastOccurrenceDate) {
        RedirectEntry redirectEntry = this.redirectEntryPersistence.fetchByG_S(groupId, sourceURL);
        if (redirectEntry != null) {
            if (this._isExpired(redirectEntry)) {
                return null;
            }
            if (updateLastOccurrenceDate && (redirectEntry.getLastOccurrenceDate() == null || !this._isInTheSameDay(redirectEntry.getLastOccurrenceDate(), DateUtil.newDate()))) {
                redirectEntry.setLastOccurrenceDate(new Date());
                redirectEntry = this.redirectEntryLocalService.updateRedirectEntry(redirectEntry);
            }
        }
        return redirectEntry;
    }

    public List<RedirectEntry> getRedirectEntries(long groupId, int start, int end, OrderByComparator<RedirectEntry> orderByComparator) {
        return this.redirectEntryPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<RedirectEntry> getRedirectEntries(long groupId, String destinationURL) {
        return ListUtil.filter((List)this.redirectEntryPersistence.findByG_D(groupId, destinationURL), redirectEntry -> !this._isExpired((RedirectEntry)redirectEntry));
    }

    public int getRedirectEntriesCount(long groupId) {
        return this.redirectEntryPersistence.countByGroupId(groupId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public RedirectEntry updateRedirectEntry(long redirectEntryId, String destinationURL, Date expirationDate, boolean permanent, String sourceURL) throws PortalException {
        this._validate(destinationURL, sourceURL);
        RedirectEntry redirectEntry = this.getRedirectEntry(redirectEntryId);
        RedirectEntry existingRedirectEntry = this.redirectEntryPersistence.fetchByG_S(redirectEntry.getGroupId(), sourceURL);
        if (existingRedirectEntry != null && existingRedirectEntry.getRedirectEntryId() != redirectEntryId) {
            throw new DuplicateRedirectEntrySourceURLException();
        }
        redirectEntry.setDestinationURL(destinationURL);
        redirectEntry.setExpirationDate(expirationDate);
        redirectEntry.setPermanent(permanent);
        redirectEntry.setSourceURL(sourceURL);
        return (RedirectEntry)this.redirectEntryPersistence.update((BaseModel)redirectEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public RedirectEntry updateRedirectEntry(long redirectEntryId, String destinationURL, Date expirationDate, String groupBaseURL, boolean permanent, String sourceURL, boolean updateChainedRedirectEntries) throws PortalException {
        this._checkDestinationURLMustNotBeEqualToSourceURL(destinationURL, groupBaseURL, sourceURL);
        RedirectEntry redirectEntry = this.redirectEntryLocalService.updateRedirectEntry(redirectEntryId, destinationURL, expirationDate, permanent, sourceURL);
        this._checkChainedRedirectEntries(groupBaseURL, redirectEntry);
        if (updateChainedRedirectEntries) {
            redirectEntry = this._updateChainedRedirectEntries(groupBaseURL, redirectEntry);
        }
        return redirectEntry;
    }

    private void _checkChainedRedirectEntries(String groupBaseURL, RedirectEntry redirectEntry) throws PortalException {
        List chainedRedirectEntries = this.redirectEntryLocalService.getRedirectEntries(redirectEntry.getGroupId(), groupBaseURL + "/" + redirectEntry.getSourceURL());
        for (RedirectEntry chainedRedirectEntry : chainedRedirectEntries) {
            this._checkMustNotFormALoopWithAnotherRedirectEntry(redirectEntry.getDestinationURL(), groupBaseURL, chainedRedirectEntry.getSourceURL());
        }
        RedirectEntry chainedRedirectEntry = this.redirectEntryLocalService.fetchRedirectEntry(redirectEntry.getGroupId(), StringUtil.removeSubstring((String)redirectEntry.getDestinationURL(), (String)(groupBaseURL + "/")));
        if (chainedRedirectEntry != null) {
            this._checkMustNotFormALoopWithAnotherRedirectEntry(chainedRedirectEntry.getDestinationURL(), groupBaseURL, redirectEntry.getSourceURL());
        }
    }

    private void _checkDestinationURLMustNotBeEqualToSourceURL(String destinationURL, String groupBaseURL, String sourceURL) throws CircularRedirectEntryException.DestinationURLMustNotBeEqualToSourceURL {
        String completeSourceURL = groupBaseURL + "/" + sourceURL;
        if (StringUtil.equalsIgnoreCase((String)completeSourceURL, (String)destinationURL)) {
            throw new CircularRedirectEntryException.DestinationURLMustNotBeEqualToSourceURL(sourceURL, destinationURL);
        }
    }

    private void _checkMustNotFormALoopWithAnotherRedirectEntry(String destinationURL, String groupBaseURL, String sourceURL) throws CircularRedirectEntryException.MustNotFormALoopWithAnotherRedirectEntry {
        String completeSourceURL = groupBaseURL + "/" + sourceURL;
        if (StringUtil.equalsIgnoreCase((String)completeSourceURL, (String)destinationURL)) {
            throw new CircularRedirectEntryException.MustNotFormALoopWithAnotherRedirectEntry();
        }
    }

    private Instant _getDayInstant(Date date) {
        Instant instant = date.toInstant();
        return instant.truncatedTo(ChronoUnit.DAYS);
    }

    private boolean _isExpired(RedirectEntry redirectEntry) {
        Date expirationDate = redirectEntry.getExpirationDate();
        return expirationDate != null && DateUtil.compareTo((Date)expirationDate, (Date)DateUtil.newDate()) <= 0;
    }

    private boolean _isInTheSameDay(Date date1, Date date2) {
        Instant instant1 = this._getDayInstant(date1);
        Instant instant2 = this._getDayInstant(date2);
        return instant1.equals(instant2);
    }

    private RedirectEntry _updateChainedRedirectEntries(String groupBaseURL, RedirectEntry redirectEntry) throws PortalException {
        List chainedRedirectEntries = this.redirectEntryLocalService.getRedirectEntries(redirectEntry.getGroupId(), groupBaseURL + "/" + redirectEntry.getSourceURL());
        for (RedirectEntry chainedRedirectEntry : chainedRedirectEntries) {
            RedirectEntry updatedRedirectEntry = this.redirectEntryLocalService.updateRedirectEntry(chainedRedirectEntry.getRedirectEntryId(), redirectEntry.getDestinationURL(), chainedRedirectEntry.getExpirationDate(), chainedRedirectEntry.isPermanent(), chainedRedirectEntry.getSourceURL());
            RedirectEntry destinationRedirectEntry = this.redirectEntryLocalService.fetchRedirectEntry(redirectEntry.getGroupId(), StringUtil.removeSubstring((String)updatedRedirectEntry.getDestinationURL(), (String)(groupBaseURL + "/")));
            if (destinationRedirectEntry == null) continue;
            this._checkMustNotFormALoopWithAnotherRedirectEntry(updatedRedirectEntry.getDestinationURL(), groupBaseURL, destinationRedirectEntry.getSourceURL());
        }
        RedirectEntry chainedRedirectEntry = this.redirectEntryLocalService.fetchRedirectEntry(redirectEntry.getGroupId(), StringUtil.removeSubstring((String)redirectEntry.getDestinationURL(), (String)(groupBaseURL + "/")));
        if (chainedRedirectEntry != null) {
            return this.redirectEntryLocalService.updateRedirectEntry(redirectEntry.getRedirectEntryId(), chainedRedirectEntry.getDestinationURL(), redirectEntry.getExpirationDate(), redirectEntry.isPermanent(), redirectEntry.getSourceURL());
        }
        return redirectEntry;
    }

    private void _validate(String destinationURL, String sourceURL) throws PortalException {
        if (Validator.isNull((String)destinationURL)) {
            throw new RequiredRedirectEntryDestinationURLException();
        }
        if (Validator.isNull((String)sourceURL)) {
            throw new RequiredRedirectEntrySourceURLException();
        }
        if (sourceURL.startsWith("/")) {
            throw new LayoutFriendlyURLException(1);
        }
        int exceptionType = LayoutImpl.validateFriendlyURL((String)("/" + sourceURL), (boolean)true);
        if (exceptionType != -1) {
            throw new LayoutFriendlyURLException(exceptionType);
        }
    }
}

