/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.redirect.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.redirect.model.RedirectEntry;
import com.liferay.redirect.service.base.RedirectEntryServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"json.web.service.context.name=redirect", "json.web.service.context.path=RedirectEntry"}, service={AopService.class})
public class RedirectEntryServiceImpl
extends RedirectEntryServiceBaseImpl {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(resource.name=com.liferay.redirect)")
    private volatile PortletResourcePermission _portletResourcePermission;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.redirect.model.RedirectEntry)")
    private volatile ModelResourcePermission<RedirectEntry> _redirectEntryModelResourcePermission;

    public RedirectEntry addRedirectEntry(long groupId, String destinationURL, Date expirationDate, boolean permanent, String sourceURL, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_ENTRY");
        return this.redirectEntryLocalService.addRedirectEntry(groupId, destinationURL, expirationDate, permanent, sourceURL, serviceContext);
    }

    public RedirectEntry addRedirectEntry(long groupId, String destinationURL, Date expirationDate, String groupBaseURL, boolean permanent, String sourceURL, boolean updateChainedRedirectEntries, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_ENTRY");
        return this.redirectEntryLocalService.addRedirectEntry(groupId, destinationURL, expirationDate, groupBaseURL, permanent, sourceURL, updateChainedRedirectEntries, serviceContext);
    }

    public RedirectEntry deleteRedirectEntry(long redirectEntryId) throws PortalException {
        this._redirectEntryModelResourcePermission.check(this.getPermissionChecker(), redirectEntryId, "DELETE");
        return this.redirectEntryLocalService.deleteRedirectEntry(redirectEntryId);
    }

    public RedirectEntry fetchRedirectEntry(long redirectEntryId) throws PortalException {
        RedirectEntry redirectEntry = this.redirectEntryLocalService.fetchRedirectEntry(redirectEntryId);
        if (redirectEntry != null) {
            this._redirectEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)redirectEntry, "VIEW");
        }
        return redirectEntry;
    }

    public List<RedirectEntry> getRedirectEntries(long groupId, int start, int end, OrderByComparator<RedirectEntry> orderByComparator) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.hasPermission(groupId, RedirectEntry.class.getName(), RedirectEntry.class.getName(), "VIEW")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{RedirectEntry.class.getName(), RedirectEntry.class.getName(), "VIEW"});
        }
        return this.redirectEntryLocalService.getRedirectEntries(groupId, start, end, orderByComparator);
    }

    public int getRedirectEntriesCount(long groupId) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.hasPermission(groupId, RedirectEntry.class.getName(), RedirectEntry.class.getName(), "VIEW")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{RedirectEntry.class.getName(), RedirectEntry.class.getName(), "VIEW"});
        }
        return this.redirectEntryLocalService.getRedirectEntriesCount(groupId);
    }

    public RedirectEntry updateRedirectEntry(long redirectEntryId, String destinationURL, Date expirationDate, boolean permanent, String sourceURL) throws PortalException {
        this._redirectEntryModelResourcePermission.check(this.getPermissionChecker(), redirectEntryId, "UPDATE");
        return this.redirectEntryLocalService.updateRedirectEntry(redirectEntryId, destinationURL, expirationDate, permanent, sourceURL);
    }

    public RedirectEntry updateRedirectEntry(long redirectEntryId, String destinationURL, Date expirationDate, String groupBaseURL, boolean permanent, String sourceURL, boolean updateChainedRedirectEntries) throws PortalException {
        this._redirectEntryModelResourcePermission.check(this.getPermissionChecker(), redirectEntryId, "UPDATE");
        return this.redirectEntryLocalService.updateRedirectEntry(redirectEntryId, destinationURL, expirationDate, groupBaseURL, permanent, sourceURL, updateChainedRedirectEntries);
    }
}

