/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.redirect.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.view.count.ViewCountManager;
import com.liferay.redirect.model.RedirectNotFoundEntry;
import com.liferay.redirect.service.base.RedirectNotFoundEntryLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.redirect.model.RedirectNotFoundEntry"}, service={AopService.class})
public class RedirectNotFoundEntryLocalServiceImpl
extends RedirectNotFoundEntryLocalServiceBaseImpl {
    @Reference
    private Portal _portal;
    @Reference
    private ViewCountManager _viewCountManager;

    @Indexable(type=IndexableType.REINDEX)
    public RedirectNotFoundEntry addOrUpdateRedirectNotFoundEntry(Group group, String url) {
        RedirectNotFoundEntry redirectNotFoundEntry = this.redirectNotFoundEntryPersistence.fetchByG_U(group.getGroupId(), url);
        if (redirectNotFoundEntry == null) {
            redirectNotFoundEntry = this.redirectNotFoundEntryPersistence.create(this.counterLocalService.increment());
            redirectNotFoundEntry.setGroupId(group.getGroupId());
            redirectNotFoundEntry.setCompanyId(group.getCompanyId());
            redirectNotFoundEntry.setUrl(url);
            redirectNotFoundEntry = (RedirectNotFoundEntry)this.redirectNotFoundEntryPersistence.update((BaseModel)redirectNotFoundEntry);
        }
        this._viewCountManager.incrementViewCount(redirectNotFoundEntry.getCompanyId(), this._portal.getClassNameId(RedirectNotFoundEntry.class), redirectNotFoundEntry.getRedirectNotFoundEntryId(), 1);
        return redirectNotFoundEntry;
    }

    public RedirectNotFoundEntry fetchRedirectNotFoundEntry(long groupId, String url) {
        return this.redirectNotFoundEntryPersistence.fetchByG_U(groupId, url);
    }

    public List<RedirectNotFoundEntry> getRedirectNotFoundEntries(long groupId, Boolean ignored, Date minModifiedDate, int start, int end, OrderByComparator<RedirectNotFoundEntry> orderByComparator) {
        return this.redirectNotFoundEntryLocalService.dynamicQuery(this._getRedirectNotFoundEntriesDynamicQuery(groupId, ignored, minModifiedDate, orderByComparator), start, end);
    }

    public List<RedirectNotFoundEntry> getRedirectNotFoundEntries(long groupId, Date minModifiedDate, int start, int end, OrderByComparator<RedirectNotFoundEntry> orderByComparator) {
        return this.redirectNotFoundEntryLocalService.dynamicQuery(this._getRedirectNotFoundEntriesDynamicQuery(groupId, null, minModifiedDate, orderByComparator), start, end);
    }

    public List<RedirectNotFoundEntry> getRedirectNotFoundEntries(long groupId, int start, int end, OrderByComparator<RedirectNotFoundEntry> orderByComparator) {
        return this.redirectNotFoundEntryPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public int getRedirectNotFoundEntriesCount(long groupId) {
        return this.redirectNotFoundEntryPersistence.countByGroupId(groupId);
    }

    public int getRedirectNotFoundEntriesCount(long groupId, Boolean ignored, Date minModifiedDate) {
        return GetterUtil.getInteger((Object)this.redirectNotFoundEntryLocalService.dynamicQueryCount(this._getRedirectNotFoundEntriesDynamicQuery(groupId, ignored, minModifiedDate)));
    }

    public int getRedirectNotFoundEntriesCount(long groupId, Date minModifiedDate) {
        return GetterUtil.getInteger((Object)this.redirectNotFoundEntryLocalService.dynamicQueryCount(this._getRedirectNotFoundEntriesDynamicQuery(groupId, null, minModifiedDate)));
    }

    @Indexable(type=IndexableType.REINDEX)
    public RedirectNotFoundEntry updateRedirectNotFoundEntry(long redirectNotFoundEntryId, boolean ignored) throws PortalException {
        RedirectNotFoundEntry redirectNotFoundEntry = this.redirectNotFoundEntryLocalService.getRedirectNotFoundEntry(redirectNotFoundEntryId);
        redirectNotFoundEntry.setIgnored(ignored);
        return (RedirectNotFoundEntry)this.redirectNotFoundEntryPersistence.update((BaseModel)redirectNotFoundEntry);
    }

    private DynamicQuery _getRedirectNotFoundEntriesDynamicQuery(long groupId, Boolean ignored, Date minModifiedDate) {
        DynamicQuery redirectNotFoundEntriesDynamicQuery = this.redirectNotFoundEntryLocalService.dynamicQuery();
        redirectNotFoundEntriesDynamicQuery.add(RestrictionsFactoryUtil.eq((String)"groupId", (Object)groupId));
        if (ignored != null) {
            redirectNotFoundEntriesDynamicQuery.add(RestrictionsFactoryUtil.eq((String)"ignored", (Object)ignored));
        }
        if (minModifiedDate != null) {
            redirectNotFoundEntriesDynamicQuery.add(RestrictionsFactoryUtil.gt((String)"modifiedDate", (Object)minModifiedDate));
        }
        return redirectNotFoundEntriesDynamicQuery;
    }

    private DynamicQuery _getRedirectNotFoundEntriesDynamicQuery(long groupId, Boolean ignored, Date minModifiedDate, OrderByComparator<RedirectNotFoundEntry> orderByComparator) {
        DynamicQuery redirectNotFoundEntriesDynamicQuery = this._getRedirectNotFoundEntriesDynamicQuery(groupId, ignored, minModifiedDate);
        if (orderByComparator != null) {
            OrderFactoryUtil.addOrderByComparator((DynamicQuery)redirectNotFoundEntriesDynamicQuery, orderByComparator);
        } else {
            redirectNotFoundEntriesDynamicQuery.addOrder(OrderFactoryUtil.asc((String)"createDate"));
        }
        return redirectNotFoundEntriesDynamicQuery;
    }
}

