/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.roles.admin.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.DataLevel;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_roles_admin_web_portlet_RolesAdminPortlet"}, service={PortletDataHandler.class})
public class RolesAdminPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "roles_admin";
    public static final String SCHEMA_VERSION = "1.0.0";
    @Reference
    private Portal _portal;
    private RoleLocalService _roleLocalService;
    private UserLocalService _userLocalService;

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public boolean isSupportsDataStrategyCopyAsNew() {
        return false;
    }

    @Activate
    protected void activate() {
        this.setDataLevel(DataLevel.PORTAL);
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(Role.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "roles", true, true, new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "system-roles", true, false)}, Role.class.getName(), "referrer-class-name-all")});
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(RolesAdminPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        List roles = this._roleLocalService.getRoles(portletDataContext.getCompanyId());
        for (Role role : roles) {
            if (role.isSystem() || role.isTeam()) continue;
            this._roleLocalService.deleteRole(role);
        }
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortalPermissions();
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        ActionableDynamicQuery actionableDynamicQuery = this.getRoleActionableDynamicQuery(portletDataContext, true);
        actionableDynamicQuery.performActions();
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortalPermissions();
        Element rolesElement = portletDataContext.getImportDataGroupElement(Role.class);
        List roleElements = rolesElement.elements();
        for (Element roleElement : roleElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)roleElement);
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this.getRoleActionableDynamicQuery(portletDataContext, false);
        actionableDynamicQuery.performCount();
    }

    protected ActionableDynamicQuery getRoleActionableDynamicQuery(final PortletDataContext portletDataContext, final boolean export) {
        ExportActionableDynamicQuery actionableDynamicQuery = this._roleLocalService.getExportActionableDynamicQuery(portletDataContext);
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
                long classNameId = RolesAdminPortletDataHandler.this._portal.getClassNameId(Team.class);
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                dynamicQuery.add(classNameIdProperty.ne((Object)classNameId));
            }
        });
        final ActionableDynamicQuery.PerformActionMethod performActionMethod = actionableDynamicQuery.getPerformActionMethod();
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Role>(){

            public void performAction(Role role) throws PortalException {
                if (!export) {
                    return;
                }
                long defaultUserId = RolesAdminPortletDataHandler.this._userLocalService.getDefaultUserId(portletDataContext.getCompanyId());
                if (!portletDataContext.getBooleanParameter(RolesAdminPortletDataHandler.NAMESPACE, "system-roles") && role.getUserId() == defaultUserId) {
                    return;
                }
                performActionMethod.performAction((Object)role);
            }
        });
        return actionableDynamicQuery;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setRoleLocalService(RoleLocalService roleLocalService) {
        this._roleLocalService = roleLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

