/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.salesforce.connector.internal.instance.lifecycle;

import com.liferay.dispatch.executor.DispatchTaskExecutor;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.repository.DispatchFileRepository;
import com.liferay.dispatch.service.DispatchTriggerLocalService;
import com.liferay.dispatch.talend.archive.TalendArchiveParserUtil;
import com.liferay.portal.instance.lifecycle.InitialRequestPortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=100"}, service={PortalInstanceLifecycleListener.class})
public class AddSalesforceConnectorPortalInstanceLifecycleListener
extends InitialRequestPortalInstanceLifecycleListener {
    @Reference
    private DispatchFileRepository _dispatchFileRepository;
    @Reference(target="(dispatch.task.executor.type=talend)")
    private DispatchTaskExecutor _dispatchTaskExecutor;
    @Reference
    private DispatchTriggerLocalService _dispatchTriggerLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    protected void doPortalInstanceRegistered(long companyId) throws Exception {
        this._addDispatchTrigger(companyId, "etl-salesforce-account-connector-0.4.zip");
        this._addDispatchTrigger(companyId, "etl-salesforce-order-connector-0.7.zip");
        this._addDispatchTrigger(companyId, "etl-salesforce-price-list-connector-0.7.zip");
        this._addDispatchTrigger(companyId, "etl-salesforce-product-connector-0.4.zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addDispatchTrigger(long companyId, String name) throws Exception {
        DispatchTrigger dispatchTrigger = this._dispatchTriggerLocalService.fetchDispatchTrigger(companyId, name);
        if (dispatchTrigger != null) {
            return;
        }
        Class<?> clazz = ((Object)((Object)this)).getClass();
        File connectorArchiveFile = FileUtil.createTempFile((InputStream)clazz.getResourceAsStream("/" + name));
        try (FileInputStream fileInputStream = new FileInputStream(connectorArchiveFile);){
            UnicodeProperties unicodeProperties = new UnicodeProperties();
            TalendArchiveParserUtil.updateUnicodeProperties((InputStream)fileInputStream, (UnicodeProperties)unicodeProperties);
            long userId = this._userLocalService.getGuestUserId(companyId);
            dispatchTrigger = this._dispatchTriggerLocalService.addDispatchTrigger(null, userId, this._dispatchTaskExecutor, "talend", unicodeProperties, name, true);
            this._dispatchFileRepository.addFileEntry(userId, dispatchTrigger.getDispatchTriggerId(), name, 0L, "application/zip", (InputStream)new FileInputStream(connectorArchiveFile));
        }
        finally {
            FileUtil.delete((File)connectorArchiveFile);
        }
    }
}

