/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sass.compiler.jni.internal;

import com.liferay.sass.compiler.SassCompiler;
import com.liferay.sass.compiler.jni.internal.JniSassCompilerException;
import com.liferay.sass.compiler.jni.internal.libsass.LiferaysassLibrary;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;

public class JniSassCompiler
implements SassCompiler {
    private static final LiferaysassLibrary _liferaysassLibrary = LiferaysassLibrary.INSTANCE;
    private final String _tmpDirName;

    public JniSassCompiler() {
        this(System.getProperty("java.io.tmpdir"));
    }

    public JniSassCompiler(String tmpDirName) {
        this._tmpDirName = tmpDirName;
    }

    public String compileFile(String inputFileName, String includeDirName) throws JniSassCompilerException {
        return this.compileFile(inputFileName, includeDirName, false, "");
    }

    public String compileFile(String inputFileName, String includeDirName, boolean generateSourceMap) throws JniSassCompilerException {
        return this.compileFile(inputFileName, includeDirName, generateSourceMap, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compileFile(String inputFileName, String includeDirName, boolean generateSourceMap, String sourceMapFileName) throws JniSassCompilerException {
        String string;
        LiferaysassLibrary.Sass_File_Context sassFileContext = null;
        try {
            LiferaysassLibrary.Sass_Context sassContext;
            int errorStatus;
            File inputFile = new File(inputFileName);
            String includeDirNames = includeDirName + File.pathSeparator + inputFile.getParent();
            if (sourceMapFileName == null || sourceMapFileName.equals("")) {
                sourceMapFileName = this.getOutputFileName(inputFileName) + ".map";
            }
            if ((errorStatus = _liferaysassLibrary.sass_context_get_error_status(sassContext = _liferaysassLibrary.sass_file_context_get_context(sassFileContext = this.createSassFileContext(inputFileName, includeDirNames, generateSourceMap, sourceMapFileName)))) != 0) {
                String errorMessage = _liferaysassLibrary.sass_context_get_error_message(sassContext);
                throw new JniSassCompilerException(errorMessage);
            }
            String output = _liferaysassLibrary.sass_context_get_output_string(sassContext);
            if (generateSourceMap) {
                try {
                    File sourceMapFile = new File(sourceMapFileName);
                    String sourceMapOutput = _liferaysassLibrary.sass_context_get_source_map_string(sassContext);
                    this.write(sourceMapFile, sourceMapOutput);
                }
                catch (Exception e) {
                    System.out.println("Unable to create source map");
                }
            }
            if (output == null) {
                throw new JniSassCompilerException("Null output");
            }
            string = output;
        }
        catch (Throwable throwable) {
            try {
                if (sassFileContext != null) {
                    _liferaysassLibrary.sass_delete_file_context(sassFileContext);
                }
            }
            catch (Throwable t) {
                throw new JniSassCompilerException(t);
            }
            throw throwable;
        }
        try {
            if (sassFileContext != null) {
                _liferaysassLibrary.sass_delete_file_context(sassFileContext);
            }
        }
        catch (Throwable t) {
            throw new JniSassCompilerException(t);
        }
        return string;
    }

    public String compileString(String input, String includeDirName) throws JniSassCompilerException {
        return this.compileString(input, "", includeDirName, false);
    }

    public String compileString(String input, String inputFileName, String includeDirName, boolean generateSourceMap) throws JniSassCompilerException {
        return this.compileString(input, inputFileName, includeDirName, generateSourceMap, "");
    }

    public String compileString(String input, String inputFileName, String includeDirName, boolean generateSourceMap, String sourceMapFileName) throws JniSassCompilerException {
        try {
            if (inputFileName == null || inputFileName.equals("")) {
                inputFileName = this._tmpDirName + "tmp.scss";
                if (generateSourceMap) {
                    System.out.println("Source maps require a valid file name");
                    generateSourceMap = false;
                }
            }
            int index = inputFileName.lastIndexOf("/") + 1;
            String dirName = inputFileName.substring(0, index);
            String fileName = inputFileName.substring(index);
            String outputFileName = this.getOutputFileName(fileName);
            if (sourceMapFileName == null || sourceMapFileName.equals("")) {
                sourceMapFileName = dirName + outputFileName + ".map";
            }
            File tempFile = new File(dirName, "tmp.scss");
            tempFile.deleteOnExit();
            this.write(tempFile, input);
            String output = this.compileFile(tempFile.getCanonicalPath(), includeDirName, generateSourceMap, sourceMapFileName);
            if (generateSourceMap) {
                File sourceMapFile = new File(sourceMapFileName);
                String sourceMapContent = new String(Files.readAllBytes(sourceMapFile.toPath()));
                sourceMapContent = sourceMapContent.replaceAll("tmp\\.scss", fileName);
                sourceMapContent = sourceMapContent.replaceAll("tmp\\.css", outputFileName);
                this.write(sourceMapFile, sourceMapContent);
            }
            return output;
        }
        catch (Throwable t) {
            throw new JniSassCompilerException(t);
        }
    }

    protected LiferaysassLibrary.Sass_File_Context createSassFileContext(String inputFileName, String includeDirNames, boolean generateSourceMap, String sourceMapFileName) {
        LiferaysassLibrary.Sass_File_Context sassFileContext = _liferaysassLibrary.sass_make_file_context(inputFileName);
        LiferaysassLibrary.Sass_Options sassOptions = _liferaysassLibrary.sass_make_options();
        _liferaysassLibrary.sass_option_set_include_path(sassOptions, includeDirNames);
        _liferaysassLibrary.sass_option_set_input_path(sassOptions, inputFileName);
        _liferaysassLibrary.sass_option_set_output_path(sassOptions, "");
        _liferaysassLibrary.sass_option_set_output_style(sassOptions, 0);
        _liferaysassLibrary.sass_option_set_source_comments(sassOptions, (byte)0);
        if (generateSourceMap) {
            _liferaysassLibrary.sass_option_set_source_map_contents(sassOptions, (byte)0);
            _liferaysassLibrary.sass_option_set_source_map_embed(sassOptions, (byte)0);
            _liferaysassLibrary.sass_option_set_source_map_file(sassOptions, sourceMapFileName);
            _liferaysassLibrary.sass_option_set_omit_source_map_url(sassOptions, (byte)0);
        }
        _liferaysassLibrary.sass_file_context_set_options(sassFileContext, sassOptions);
        _liferaysassLibrary.sass_compile_file_context(sassFileContext);
        return sassFileContext;
    }

    protected String getOutputFileName(String fileName) {
        return fileName.replaceAll("scss$", "css");
    }

    protected void write(File file, String string) throws IOException {
        if (!file.exists()) {
            File parentFile = file.getParentFile();
            parentFile.mkdirs();
            file.createNewFile();
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8");){
            writer.write(string);
        }
    }
}

