/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.runtime;

import com.ochafik.lang.jnaerator.runtime.Mangling;
import com.sun.jna.FunctionMapper;
import com.sun.jna.NativeLibrary;
import com.sun.jna.win32.StdCallFunctionMapper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MangledFunctionMapper
implements FunctionMapper {
    public static final Map<Object, Object> DEFAULT_OPTIONS;
    public List<FunctionMapper> linked = new ArrayList<FunctionMapper>();

    public MangledFunctionMapper(FunctionMapper ... linked) {
        this.linked.addAll(Arrays.asList(linked));
    }

    public String getFunctionName(NativeLibrary library, Method method) {
        Mangling name = method.getAnnotation(Mangling.class);
        if (name != null) {
            for (String n : name.value()) {
                try {
                    if (library.getGlobalVariableAddress(n) != null) {
                        return n;
                    }
                    if (n.startsWith("_") && library.getGlobalVariableAddress(n = n.substring(1)) != null) {
                        return n;
                    }
                }
                catch (Throwable ex2) {
                    Object ex2 = null;
                }
            }
        }
        if (this.linked != null) {
            for (FunctionMapper fm : this.linked) {
                String n = fm.getFunctionName(library, method);
                if (n == null || library.getGlobalVariableAddress(n) == null) continue;
                return n;
            }
        }
        return method.getName();
    }

    static {
        HashMap<String, MangledFunctionMapper> m = new HashMap<String, MangledFunctionMapper>();
        m.put("function-mapper", new MangledFunctionMapper(new StdCallFunctionMapper()));
        DEFAULT_OPTIONS = Collections.unmodifiableMap(m);
    }
}

